/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.expression;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserException
extends Exception {
    private static final long serialVersionUID = 30402L;
    private String currentToken;
    private int lineNumber;
    private int columnNumber;
    private List<String> tokenSequence;
    private boolean classNameExpected = false;
    private boolean objectPropertyNameExpected = false;
    private boolean dataPropertyNameExpected = false;
    private boolean individualNameExpected = false;
    private boolean datatypeNameExpected = false;
    private boolean integerExpected = false;
    private boolean annotationPropertyExpected = false;
    private boolean ontologyNameExpected = false;
    private Set<String> expectedKeywords;
    private int startPos;

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean ontologyNameExpected, String ... keywords) {
        this(tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, keywords);
        this.ontologyNameExpected = ontologyNameExpected;
    }

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, Set<String> expectedKeywords) {
        this.currentToken = tokenSequence.iterator().next();
        this.tokenSequence = tokenSequence;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.classNameExpected = classNameExpected;
        this.objectPropertyNameExpected = objectPropertyNameExpected;
        this.dataPropertyNameExpected = dataPropertyNameExpected;
        this.individualNameExpected = individualNameExpected;
        this.datatypeNameExpected = datatypeNameExpected;
        this.annotationPropertyExpected = annotationPropertyExpected;
        this.expectedKeywords = expectedKeywords;
        this.startPos = startPos;
    }

    public ParserException(List<String> tokenSeqence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, String ... keywords) {
        this(tokenSeqence, startPos, lineNumber, columnNumber, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyExpected, CollectionFactory.createSet((Object[])keywords));
    }

    public ParserException(List<String> tokenSequence, int lineNumber, int columnNumber, boolean integerExpected, int startPos) {
        this(tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, new HashSet<String>());
        this.integerExpected = integerExpected;
    }

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, String ... keywords) {
        this(tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, keywords);
    }

    public List<String> getTokenSequence() {
        return this.tokenSequence;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public boolean isClassNameExpected() {
        return this.classNameExpected;
    }

    public boolean isObjectPropertyNameExpected() {
        return this.objectPropertyNameExpected;
    }

    public boolean isDataPropertyNameExpected() {
        return this.dataPropertyNameExpected;
    }

    public boolean isIndividualNameExpected() {
        return this.individualNameExpected;
    }

    public boolean isDatatypeNameExpected() {
        return this.datatypeNameExpected;
    }

    public boolean isAnnotationPropertyNameExpected() {
        return this.annotationPropertyExpected;
    }

    public boolean isOntologyNameExpected() {
        return this.ontologyNameExpected;
    }

    public Set<String> getExpectedKeywords() {
        return this.expectedKeywords;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Encountered ");
        sb.append(this.currentToken);
        sb.append(" at line ");
        sb.append(this.lineNumber);
        sb.append(" column ");
        sb.append(this.columnNumber);
        sb.append(". Expected one of:\n");
        if (this.ontologyNameExpected) {
            sb.append("\tOntology name\n");
        }
        if (this.classNameExpected) {
            sb.append("\tClass name\n");
        }
        if (this.objectPropertyNameExpected) {
            sb.append("\tObject property name\n");
        }
        if (this.dataPropertyNameExpected) {
            sb.append("\tData property name\n");
        }
        if (this.individualNameExpected) {
            sb.append("\tIndividual name\n");
        }
        if (this.datatypeNameExpected) {
            sb.append("\tDatatype name\n");
        }
        if (this.annotationPropertyExpected) {
            sb.append("\tAnnotation property\n");
        }
        if (this.integerExpected) {
            sb.append("\tInteger\n");
        }
        for (String kw : this.expectedKeywords) {
            sb.append("\t");
            sb.append(kw);
            sb.append("\n");
        }
        return sb.toString();
    }
}

