/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPSubClassOfHandler
extends TriplePredicateHandler {
    public TPSubClassOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
    }

    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        return super.canHandle(subject, predicate, object) && this.isTyped(subject, predicate, object);
    }

    private boolean isTyped(IRI subject, IRI predicate, IRI object) {
        return this.getConsumer().isClassExpression(subject) && this.getConsumer().isClassExpression(object);
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.getConsumer().addClassExpression(subject, false);
        this.getConsumer().addClassExpression(object, false);
        return !this.isStrict() && !this.isSubjectOrObjectAnonymous(subject, object);
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.isStrict()) {
            if (this.isClassExpressionStrict(subject) && this.isClassExpressionStrict(object)) {
                this.translate(subject, predicate, object);
            }
        } else if (this.isClassExpressionLax(subject) && this.isClassExpressionLax(object)) {
            this.translate(subject, predicate, object);
        }
    }

    private void translate(IRI subject, IRI predicate, IRI object) {
        OWLClassExpression subClass = this.translateClassExpression(subject);
        OWLClassExpression supClass = this.translateClassExpression(object);
        Set<OWLAnnotation> pendingAnnotations = this.getConsumer().getPendingAnnotations();
        OWLSubClassOfAxiom ax = this.getDataFactory().getOWLSubClassOfAxiom(subClass, supClass, pendingAnnotations);
        this.addAxiom((OWLAxiom)ax);
        this.consumeTriple(subject, predicate, object);
    }
}

