/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.io.IOException;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.rdfxml.parser.IRIProvider;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OWLRDFXMLParserSAXException;
import org.coode.owlapi.rdfxml.parser.TranslatedOntologyChangeException;
import org.coode.owlapi.rdfxml.parser.TranslatedUnloadedImportException;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rdf.syntax.RDFParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        InputSource is = null;
        try {
            final RDFXMLOntologyFormat format = new RDFXMLOntologyFormat();
            final RDFParser parser = new RDFParser(){

                public void startPrefixMapping(String prefix, String IRI2) throws SAXException {
                    super.startPrefixMapping(prefix, IRI2);
                    format.setPrefix(prefix, IRI2);
                }

                public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(namespaceIRI, localName, qName, atts);
                }
            };
            IRIProvider prov = new IRIProvider(){

                public IRI getIRI(String s) {
                    return parser.getIRI(s);
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, new AnonymousNodeChecker(){

                public boolean isAnonymousNode(IRI iri) {
                    return parser.isAnonymousNodeIRI(iri.toString());
                }

                public boolean isAnonymousSharedNode(String iri) {
                    return parser.isAnonymousNodeID(iri);
                }

                public boolean isAnonymousNode(String iri) {
                    return parser.isAnonymousNodeIRI(iri);
                }
            }, configuration);
            consumer.setIRIProvider(prov);
            consumer.setOntologyFormat((RDFOntologyFormat)format);
            is = this.getInputSource(documentSource);
            parser.parse(is, consumer);
            RDFXMLOntologyFormat rDFXMLOntologyFormat = format;
            return rDFXMLOntologyFormat;
        }
        catch (TranslatedOntologyChangeException e) {
            throw e.getCause();
        }
        catch (TranslatedUnloadedImportException e) {
            throw e.getCause();
        }
        catch (SAXException e) {
            throw new OWLRDFXMLParserSAXException(e);
        }
        finally {
            if (is != null && is.getByteStream() != null) {
                is.getByteStream().close();
            } else if (is != null && is.getCharacterStream() != null) {
                is.getCharacterStream().close();
            }
        }
    }
}

