/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.xml.XMLWriter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.Namespaces;

public class RDFXMLWriter {
    private XMLWriter writer;

    RDFXMLWriter(XMLWriter writer) {
        this.writer = writer;
    }

    public void writeStartElement(IRI elementName) throws IOException {
        this.writer.writeStartElement(elementName.toString());
    }

    public void writeParseTypeAttribute() throws IOException {
        this.writer.writeAttribute(Namespaces.RDF + "parseType", "Collection");
    }

    public void writeDatatypeAttribute(IRI datatypeIRI) throws IOException {
        this.writer.writeAttribute(Namespaces.RDF + "datatype", datatypeIRI.toString());
    }

    public void writeTextContent(String text) throws IOException {
        this.writer.writeTextContent(text);
    }

    public void writeLangAttribute(String lang) throws IOException {
        this.writer.writeAttribute("xml:lang", lang);
    }

    public void writeEndElement() throws IOException {
        this.writer.writeEndElement();
    }

    public void writeAboutAttribute(IRI value) throws IOException {
        this.writeAttribute(Namespaces.RDF + "about", value);
    }

    public void writeNodeIDAttribute(RDFResourceNode node) throws IOException {
        this.writeAttribute(Namespaces.RDF + "nodeID", IRI.create((String)node.toString()));
    }

    private void writeAttribute(String attributeName, IRI value) throws IOException {
        this.writer.writeAttribute(attributeName, value.toString());
    }

    public void writeOWLObject(OWLObject owlObject) {
    }

    public void writeResourceAttribute(IRI value) throws IOException {
        this.writeAttribute(Namespaces.RDF + "resource", value);
    }

    public void startDocument() throws IOException {
        this.writer.startDocument(Namespaces.RDF + "RDF");
    }

    public void endDocument() throws IOException {
        this.writer.endDocument();
    }

    public void writeComment(String comment) throws IOException {
        this.writer.writeComment(comment);
    }
}

