/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.ArrayList;
import java.util.List;
import org.coode.owlapi.obo.parser.OBOFrame;
import org.coode.owlapi.obo.parser.OBOParserHandler;
import org.coode.owlapi.obo.parser.OBOTagValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawFrameHandler
implements OBOParserHandler {
    private String currentFrameType;
    private List<OBOTagValuePair> currentTagValuePairs = new ArrayList<OBOTagValuePair>();
    private OBOFrame headerFrame;
    private List<OBOFrame> typeDefFrames = new ArrayList<OBOFrame>();
    private List<OBOFrame> nonTypeDefFrames = new ArrayList<OBOFrame>();

    @Override
    public void startHeader() {
        this.currentTagValuePairs.clear();
    }

    @Override
    public void endHeader() {
        this.headerFrame = new OBOFrame(this.currentTagValuePairs);
    }

    @Override
    public void startFrame(String frameType) {
        this.currentFrameType = frameType;
        this.currentTagValuePairs.clear();
    }

    @Override
    public void endFrame() {
        this.storeCurrentFrame();
    }

    private OBOFrame storeCurrentFrame() {
        OBOFrame frame = new OBOFrame(this.currentFrameType, this.currentTagValuePairs);
        if (frame.isTypeDefFrame()) {
            this.typeDefFrames.add(frame);
        } else {
            this.nonTypeDefFrames.add(frame);
        }
        return frame;
    }

    @Override
    public void handleTagValue(String tag, String value, String qualifierBlock, String comment) {
        OBOTagValuePair tvp = new OBOTagValuePair(tag, value, qualifierBlock, comment);
        this.currentTagValuePairs.add(tvp);
    }

    public OBOFrame getHeaderFrame() {
        return this.headerFrame;
    }

    public List<OBOFrame> getTypeDefFrames() {
        return this.typeDefFrames;
    }

    public List<OBOFrame> getNonTypeDefFrames() {
        return this.nonTypeDefFrames;
    }
}

