/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.manchesterowlsyntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxParserException;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class ManchesterOWLSyntaxOntologyParser
extends AbstractOWLParser {
    private static final String COMMENT_START_CHAR = "#";
    private static final String DEFAULT_FILE_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        try {
            BufferedReader br = null;
            ManchesterOWLSyntaxOntologyFormat format = new ManchesterOWLSyntaxOntologyFormat();
            try {
                String line;
                br = documentSource.isReaderAvailable() ? new BufferedReader(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new BufferedReader(new InputStreamReader(documentSource.getInputStream(), DEFAULT_FILE_ENCODING)) : new BufferedReader(new InputStreamReader(this.getInputStream(documentSource.getDocumentIRI()), DEFAULT_FILE_ENCODING)));
                StringBuilder sb = new StringBuilder();
                int lineCount = 1;
                boolean foundMagicNumber = false;
                while ((line = br.readLine()) != null) {
                    String trimmedLine;
                    sb.append(line);
                    sb.append("\n");
                    if (!foundMagicNumber && (trimmedLine = line.trim()).length() > 0 && !trimmedLine.startsWith(COMMENT_START_CHAR)) {
                        if (this.startsWithMagicNumber(line)) {
                            foundMagicNumber = true;
                        } else {
                            int startCol = line.indexOf(trimmedLine) + 1;
                            StringBuilder msg = new StringBuilder();
                            msg.append("Encountered '");
                            msg.append(trimmedLine);
                            msg.append("' at line ");
                            msg.append(lineCount);
                            msg.append(" column ");
                            msg.append(startCol);
                            msg.append(".  Expected either 'Ontology:' or 'Prefix:'");
                            throw new ManchesterOWLSyntaxParserException(msg.toString(), lineCount, startCol);
                        }
                    }
                    ++lineCount;
                }
                String s = sb.toString();
                OWLDataFactory df = ontology.getOWLOntologyManager().getOWLDataFactory();
                ManchesterOWLSyntaxEditorParser parser = new ManchesterOWLSyntaxEditorParser(configuration, df, s);
                format = parser.parseOntology(ontology);
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            return format;
        }
        catch (ParserException e) {
            throw new ManchesterOWLSyntaxParserException(e.getMessage(), e, e.getLineNumber(), e.getColumnNumber());
        }
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    private boolean startsWithMagicNumber(String line) {
        return line.indexOf(ManchesterOWLSyntax.PREFIX.toString()) != -1 || line.indexOf(ManchesterOWLSyntax.ONTOLOGY.toString()) != -1;
    }
}

