/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.functionalrenderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.string.EscapeUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectRenderer
implements OWLObjectVisitor {
    private DefaultPrefixManager prefixManager;
    protected OWLOntology ontology;
    private Writer writer;
    private int pos;
    int lastNewLinePos;
    private boolean writeEnitiesAsURIs;
    private OWLObject focusedObject;

    public OWLObjectRenderer(OWLOntologyManager man, OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = writer;
        this.writeEnitiesAsURIs = true;
        this.prefixManager = new DefaultPrefixManager();
        OWLOntologyFormat ontologyFormat = man.getOntologyFormat(ontology);
        if (ontologyFormat instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat prefixFormat = (PrefixOWLOntologyFormat)ontologyFormat;
            for (String prefixName : prefixFormat.getPrefixNames()) {
                String prefix = prefixFormat.getPrefix(prefixName);
                this.prefixManager.setPrefix(prefixName, prefix);
            }
        }
        if (!ontology.isAnonymous()) {
            String defPrefix = ontology.getOntologyID().getOntologyIRI() + "#";
            this.prefixManager.setDefaultPrefix(defPrefix);
        }
        this.focusedObject = man.getOWLDataFactory().getOWLThing();
    }

    public void setPrefixManager(DefaultPrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }

    public void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    public void writePrefix(String prefix, String namespace) {
        this.write("Prefix");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.write("\n");
    }

    public void writePrefixes() {
        for (String prefix : this.prefixManager.getPrefixName2PrefixMap().keySet()) {
            this.writePrefix(prefix, this.prefixManager.getPrefix(prefix));
        }
    }

    private void write(OWLXMLVocabulary v) {
        this.write(v.getShortName());
    }

    private void write(String s) {
        try {
            int newLineIndex = s.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(IRI iri) {
        String iriString = iri.toString();
        String qname = this.prefixManager.getPrefixIRI(iri);
        if (qname != null && !qname.equals(iriString)) {
            this.write(qname);
        } else {
            this.write("<");
            this.write(iriString);
            this.write(">");
        }
    }

    private void writeFullIRI(IRI iri) {
        this.write("<");
        this.write(iri.toString());
        this.write(">");
    }

    public void visit(OWLOntology ontology) {
        this.writePrefixes();
        this.write("\n\n");
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.write("(");
        if (!ontology.isAnonymous()) {
            this.writeFullIRI(ontology.getOntologyID().getOntologyIRI());
            if (ontology.getOntologyID().getVersionIRI() != null) {
                this.write("\n");
                this.writeFullIRI(ontology.getOntologyID().getVersionIRI());
            }
            this.write("\n");
        }
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.write(OWLXMLVocabulary.IMPORT);
            this.write("(");
            this.writeFullIRI(decl.getIRI());
            this.write(")\n");
        }
        for (OWLAnnotation ontologyAnnotation : ontology.getAnnotations()) {
            ontologyAnnotation.accept((OWLObjectVisitor)this);
            this.write("\n");
        }
        this.write("\n");
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        for (OWLEntity ent : new TreeSet(ontology.getSignature())) {
            writtenAxioms.addAll(this.writeAxioms(ent));
        }
        ArrayList remainingAxioms = new ArrayList(ontology.getAxioms());
        remainingAxioms.removeAll(writtenAxioms);
        for (OWLAxiom ax : remainingAxioms) {
            ax.accept((OWLObjectVisitor)this);
            this.write("\n");
        }
        this.write(")");
    }

    public Set<OWLAxiom> writeAxioms(OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.setFocusedObject((OWLObject)entity);
        writtenAxioms.addAll(this.writeDeclarations(entity));
        writtenAxioms.addAll(this.writeAnnotations(entity));
        ArrayList axs = new ArrayList();
        axs.addAll((Collection)entity.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<Set<? extends OWLAxiom>>(){

            public Set<? extends OWLAxiom> visit(OWLClass cls) {
                return OWLObjectRenderer.this.ontology.getAxioms(cls);
            }

            public Set<? extends OWLAxiom> visit(OWLObjectProperty property) {
                return OWLObjectRenderer.this.ontology.getAxioms((OWLObjectPropertyExpression)property);
            }

            public Set<? extends OWLAxiom> visit(OWLDataProperty property) {
                return OWLObjectRenderer.this.ontology.getAxioms(property);
            }

            public Set<? extends OWLAxiom> visit(OWLNamedIndividual individual) {
                return OWLObjectRenderer.this.ontology.getAxioms((OWLIndividual)individual);
            }

            public Set<? extends OWLAxiom> visit(OWLDatatype datatype) {
                return OWLObjectRenderer.this.ontology.getAxioms(datatype);
            }

            public Set<? extends OWLAxiom> visit(OWLAnnotationProperty property) {
                return OWLObjectRenderer.this.ontology.getAxioms(property);
            }
        }));
        Collections.sort(axs);
        for (OWLAxiom ax : axs) {
            if (ax.getAxiomType().equals(AxiomType.DIFFERENT_INDIVIDUALS) || ax.getAxiomType().equals(AxiomType.DISJOINT_CLASSES) && ((OWLDisjointClassesAxiom)ax).getClassExpressions().size() > 2) continue;
            ax.accept((OWLObjectVisitor)this);
            writtenAxioms.add(ax);
            this.write("\n");
        }
        return writtenAxioms;
    }

    public Set<OWLAxiom> writeDeclarations(OWLEntity entity) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : this.ontology.getDeclarationAxioms(entity)) {
            ax.accept((OWLObjectVisitor)this);
            axioms.add(ax);
            this.write("\n");
        }
        return axioms;
    }

    public Set<OWLAxiom> writeAnnotations(OWLEntity entity) {
        HashSet<OWLAxiom> annotationAssertions = new HashSet<OWLAxiom>();
        for (OWLAnnotationAxiom ax : entity.getAnnotationAssertionAxioms(this.ontology)) {
            ax.accept((OWLObjectVisitor)this);
            annotationAssertions.add((OWLAxiom)ax);
            this.write("\n");
        }
        return annotationAssertions;
    }

    public void write(OWLXMLVocabulary v, OWLObject o) {
        this.write(v);
        this.write("(");
        o.accept((OWLObjectVisitor)this);
        this.write(")");
    }

    private void write(Collection<? extends OWLObject> objects) {
        if (objects.size() > 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.write(" ");
            }
        } else if (objects.size() == 2) {
            OWLObject rhs;
            OWLObject lhs;
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject objA = it.next();
            OWLObject objB = it.next();
            if (objA.equals(this.focusedObject)) {
                lhs = objA;
                rhs = objB;
            } else {
                lhs = objB;
                rhs = objA;
            }
            lhs.accept((OWLObjectVisitor)this);
            this.writeSpace();
            rhs.accept((OWLObjectVisitor)this);
        } else if (objects.size() == 1) {
            objects.iterator().next().accept((OWLObjectVisitor)this);
        }
    }

    private void write(List<? extends OWLObject> objects) {
        if (objects.size() > 1) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.write(" ");
            }
        } else if (objects.size() == 1) {
            objects.iterator().next().accept((OWLObjectVisitor)this);
        }
    }

    public void writeOpenBracket() {
        this.write("(");
    }

    public void writeCloseBracket() {
        this.write(")");
    }

    public void writeSpace() {
        this.write(" ");
    }

    public void write(OWLAnnotation annotation) {
    }

    public void writeAnnotations(OWLAxiom ax) {
        for (OWLAnnotation anno : ax.getAnnotations()) {
            anno.accept((OWLObjectVisitor)this);
            this.write(" ");
        }
    }

    public void writeAxiomStart(OWLXMLVocabulary v, OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    public void writeAxiomEnd() {
        this.write(")");
    }

    public void writePropertyCharacteristic(OWLXMLVocabulary v, OWLAxiom ax, OWLPropertyExpression<?, ?> prop) {
        this.writeAxiomStart(v, ax);
        prop.accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, (OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, (OWLAxiom)axiom);
        this.writeEnitiesAsURIs = false;
        axiom.getEntity().accept((OWLObjectVisitor)this);
        this.writeEnitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, (OWLAxiom)axiom);
        this.write(axiom.getIndividuals());
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, (OWLAxiom)axiom);
        this.write(axiom.getClassExpressions());
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, (OWLAxiom)axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, (OWLAxiom)axiom);
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(axiom.getClassExpressions());
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_ASSERTION, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getValue().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, (OWLAxiom)axiom);
        this.write(axiom.getClassExpressions());
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, (OWLAxiom)axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.write(axiom.getProperties());
        this.writeAxiomEnd();
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        Iterator it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write(" ");
        }
        this.writeCloseBracket();
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUAL, (OWLAxiom)axiom);
        this.write(axiom.getIndividuals());
        this.writeAxiomEnd();
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, (OWLAxiom)axiom);
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLClass desc) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        desc.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyRange> void writeRestriction(OWLXMLVocabulary v, OWLCardinalityRestriction<R, P, F> restriction) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        restriction.getProperty().accept((OWLObjectVisitor)this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLPropertyExpression<?, ?> prop, OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        prop.accept((OWLObjectVisitor)this);
        this.writeSpace();
        filler.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, (OWLQuantifiedDataRestriction)desc);
    }

    public void visit(OWLDataExactCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLDataMaxCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLDataMinCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLDataSomeValuesFrom desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, (OWLQuantifiedDataRestriction)desc);
    }

    public void visit(OWLDataHasValue desc) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, desc.getProperty(), desc.getValue());
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, (OWLQuantifiedObjectRestriction)desc);
    }

    public void visit(OWLObjectComplementOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, (OWLObject)desc.getOperand());
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLObjectIntersectionOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(desc.getOperands());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, (OWLCardinalityRestriction)desc);
    }

    public void visit(OWLObjectOneOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        this.write(desc.getIndividuals());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasSelf desc) {
        this.write(OWLXMLVocabulary.OBJECT_HAS_SELF, (OWLObject)desc.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, (OWLQuantifiedObjectRestriction)desc);
    }

    public void visit(OWLObjectUnionOf desc) {
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        this.write(desc.getOperands());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasValue desc) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, desc.getProperty(), desc.getValue());
    }

    public void visit(OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, (OWLObject)node.getDataRange());
    }

    public void visit(OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.write("(");
        this.write(node.getValues());
        this.write(")");
    }

    public void visit(OWLDatatype node) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATATYPE);
            this.writeOpenBracket();
        }
        node.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLDatatypeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDatatype().accept((OWLObjectVisitor)this);
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            this.writeSpace();
            restriction.accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.writeSpace();
        node.getFacetValue().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString(node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else if (!node.isRDFPlainLiteral()) {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    public void visit(OWLDataProperty property) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLObjectProperty property) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLObjectInverseOf property) {
        this.write(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        this.writeOpenBracket();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLNamedIndividual individual) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.NAMED_INDIVIDUAL);
            this.writeOpenBracket();
        }
        individual.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLHasKeyAxiom axiom) {
        OWLPropertyExpression prop;
        this.writeAxiomStart(OWLXMLVocabulary.HAS_KEY, (OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.write(" ");
        this.write("(");
        Iterator it = axiom.getObjectPropertyExpressions().iterator();
        while (it.hasNext()) {
            prop = (OWLPropertyExpression)it.next();
            prop.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write(" ");
        }
        this.write(") (");
        it = axiom.getDataPropertyExpressions().iterator();
        while (it.hasNext()) {
            prop = (OWLPropertyExpression)it.next();
            prop.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.write(" ");
        }
        this.write(")");
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        axiom.getRange().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF, (OWLAxiom)axiom);
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(OWLDataIntersectionOf node) {
        this.write(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(node.getOperands());
        this.writeCloseBracket();
    }

    public void visit(OWLDataUnionOf node) {
        this.write(OWLXMLVocabulary.DATA_UNION_OF);
        this.writeOpenBracket();
        this.write(node.getOperands());
        this.writeCloseBracket();
    }

    public void visit(OWLAnnotationProperty property) {
        if (!this.writeEnitiesAsURIs) {
            this.write(OWLXMLVocabulary.ANNOTATION_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEnitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    public void visit(IRI iri) {
        this.write(iri);
    }

    public void visit(OWLAnnotation node) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.write("(");
        for (OWLAnnotation anno : node.getAnnotations()) {
            anno.accept((OWLObjectVisitor)this);
            this.write(" ");
        }
        node.getProperty().accept((OWLObjectVisitor)this);
        this.write(" ");
        node.getValue().accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATATYPE_DEFINITION, (OWLAxiom)axiom);
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(SWRLRule rule) {
        this.writeAxiomStart(OWLXMLVocabulary.DL_SAFE_RULE, (OWLAxiom)rule);
        this.write(OWLXMLVocabulary.BODY);
        this.writeOpenBracket();
        this.write(rule.getBody());
        this.writeCloseBracket();
        this.write(OWLXMLVocabulary.HEAD);
        this.writeOpenBracket();
        this.write(rule.getHead());
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLClassAtom node) {
        this.write(OWLXMLVocabulary.CLASS_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLDataRangeAtom node) {
        this.write(OWLXMLVocabulary.DATA_RANGE_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.write(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(node.getArguments());
        this.writeCloseBracket();
    }

    public void visit(SWRLVariable node) {
        this.write(OWLXMLVocabulary.VARIABLE);
        this.writeOpenBracket();
        node.getIRI().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.write(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }
}

