/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.krssparser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.owl.krssparser.KRSSOWLParserException;
import org.coode.owl.krssparser.KRSSParserConstants;
import org.coode.owl.krssparser.KRSSParserTokenManager;
import org.coode.owl.krssparser.ParseException;
import org.coode.owl.krssparser.Token;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.vocab.Namespaces;
import uk.ac.manchester.cs.JavaCharStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRSSParser
implements KRSSParserConstants {
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, IRI> string2IRI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private String base;
    public KRSSParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[24];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setOntology(OWLOntology ontology, OWLDataFactory dataFactory) {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        this.string2IRI = new HashMap<String, IRI>();
        this.base = !ontology.isAnonymous() ? ontology.getOntologyID().getOntologyIRI() + "#" : Namespaces.OWL.toString();
    }

    protected void addAxiom(OWLAxiom ax) throws KRSSOWLParserException {
        try {
            ((OWLMutableOntology)this.ontology).applyChange((OWLOntologyChange)new AddAxiom(this.ontology, ax));
        }
        catch (OWLOntologyChangeException e) {
            throw new KRSSOWLParserException(e);
        }
    }

    public IRI getIRI(String s) {
        s = this.base + s;
        IRI iri = this.string2IRI.get(s);
        if (iri == null) {
            iri = IRI.create((String)s);
            this.string2IRI.put(s, iri);
        }
        return iri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    public final void parse() throws ParseException, KRSSOWLParserException {
        while (this.jj_2_1(2)) {
            OWLAxiom ax = this.TBoxStatement();
            if (ax == null) continue;
            this.addAxiom(ax);
        }
        if (this.jj_2_2(2)) {
            this.jj_consume_token(17);
        }
        while (this.jj_2_3(2)) {
            this.ABoxStatement();
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(18);
        }
        this.jj_consume_token(0);
    }

    public final OWLAxiom TBoxStatement() throws ParseException {
        OWLAxiom ax;
        if (this.jj_2_5(2)) {
            ax = this.DefinePrimitiveConcept();
        } else if (this.jj_2_6(2)) {
            ax = this.DefineConcept();
        } else if (this.jj_2_7(2)) {
            ax = this.DefinePrimitiveRole();
        } else if (this.jj_2_8(2)) {
            ax = this.Transitive();
        } else if (this.jj_2_9(2)) {
            ax = this.Range();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLAxiom DefinePrimitiveConcept() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(20);
        OWLClassExpression subClass = this.ConceptName();
        OWLClassExpression superClass = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLSubClassOfAxiom(subClass, superClass);
    }

    public final OWLAxiom DefineConcept() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(21);
        OWLClassExpression clsA = this.ConceptName();
        OWLClassExpression clsB = this.ConceptExpression();
        this.jj_consume_token(16);
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        ops.add(clsA);
        ops.add(clsB);
        return this.dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    public final OWLAxiom DefinePrimitiveRole() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(22);
        OWLObjectProperty subProp = this.RoleName();
        OWLObjectProperty superProp = this.RoleName();
        if (this.jj_2_10(2)) {
            this.jj_consume_token(42);
            this.RoleName();
        }
        this.jj_consume_token(16);
        if (superProp != null) {
            return this.dataFactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProp, (OWLObjectPropertyExpression)superProp);
        }
        throw new Error("Missing return statement in function");
    }

    public final OWLAxiom Transitive() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(24);
        OWLObjectProperty prop = this.RoleName();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)prop);
    }

    public final OWLAxiom Range() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(26);
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression rng = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)prop, rng);
    }

    public final OWLClassExpression ConceptExpression() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_11(2)) {
            desc = this.ConceptName();
        } else if (this.jj_2_12(2)) {
            desc = this.And();
        } else if (this.jj_2_13(2)) {
            desc = this.Or();
        } else if (this.jj_2_14(2)) {
            desc = this.Not();
        } else if (this.jj_2_15(2)) {
            desc = this.All();
        } else if (this.jj_2_16(2)) {
            desc = this.Some();
        } else if (this.jj_2_17(2)) {
            desc = this.AtLeast();
        } else if (this.jj_2_18(2)) {
            desc = this.AtMost();
        } else if (this.jj_2_19(2)) {
            desc = this.Exactly();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLClassExpression ConceptName() throws ParseException {
        IRI iri = this.Name();
        return this.dataFactory.getOWLClass(iri);
    }

    public final Set<OWLClassExpression> ConceptSet() throws ParseException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        do {
            OWLClassExpression desc = this.ConceptExpression();
            descs.add(desc);
        } while (this.jj_2_20(2));
        return descs;
    }

    public final OWLClassExpression And() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(27);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectIntersectionOf(operands);
    }

    public final OWLClassExpression Or() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(28);
        Set<OWLClassExpression> operands = this.ConceptSet();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectUnionOf(operands);
    }

    public final OWLClassExpression Not() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(29);
        OWLClassExpression operand = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectComplementOf(operand);
    }

    public final OWLClassExpression All() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(30);
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)prop, filler);
    }

    public final OWLClassExpression Some() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(31);
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, filler);
    }

    public final OWLClassExpression AtLeast() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(33);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)prop, filler);
    }

    public final OWLClassExpression AtMost() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(34);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)prop, filler);
    }

    public final OWLClassExpression Exactly() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(35);
        int card = this.Integer();
        OWLObjectProperty prop = this.RoleName();
        OWLClassExpression filler = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectExactCardinality(card, (OWLObjectPropertyExpression)prop, filler);
    }

    public final OWLObjectProperty RoleName() throws ParseException {
        IRI iri = this.Name();
        return this.dataFactory.getOWLObjectProperty(iri);
    }

    public final OWLAxiom ABoxStatement() throws ParseException {
        OWLAxiom ax;
        if (this.jj_2_21(2)) {
            ax = this.Instance();
        } else if (this.jj_2_22(2)) {
            ax = this.Related();
        } else if (this.jj_2_23(2)) {
            ax = this.Equal();
        } else if (this.jj_2_24(2)) {
            ax = this.Distinct();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLAxiom Instance() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(36);
        OWLIndividual ind = this.IndividualName();
        OWLClassExpression type = this.ConceptExpression();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLClassAssertionAxiom(type, ind);
    }

    public final OWLAxiom Related() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(37);
        OWLIndividual subj = this.IndividualName();
        OWLObjectProperty prop = this.RoleName();
        OWLIndividual obj = this.IndividualName();
        this.jj_consume_token(16);
        return this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)prop, subj, obj);
    }

    public final OWLAxiom Equal() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(15);
        this.jj_consume_token(38);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(16);
        inds.add(indA);
        inds.add(indB);
        return this.dataFactory.getOWLSameIndividualAxiom(inds);
    }

    public final OWLAxiom Distinct() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(15);
        this.jj_consume_token(39);
        OWLIndividual indA = this.IndividualName();
        OWLIndividual indB = this.IndividualName();
        this.jj_consume_token(16);
        inds.add(indA);
        inds.add(indB);
        return this.dataFactory.getOWLDifferentIndividualsAxiom(inds);
    }

    public final OWLIndividual IndividualName() throws ParseException {
        IRI name = this.Name();
        return this.dataFactory.getOWLNamedIndividual(name);
    }

    public final IRI Name() throws ParseException {
        Token t = this.jj_consume_token(40);
        return this.getIRI(t.image);
    }

    public final int Integer() throws ParseException {
        Token t = this.jj_consume_token(41);
        return Integer.parseInt(t.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    private boolean jj_3_24() {
        return this.jj_3R_25();
    }

    private boolean jj_3_7() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_16() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3_23() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_8() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_15() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_23() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(37);
    }

    private boolean jj_3_6() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_15() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3_22() {
        return this.jj_3R_23();
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_14() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_14() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(28);
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_21() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_6() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private boolean jj_3_13() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_23()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_24()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_13() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(27);
    }

    private boolean jj_3_9() {
        return this.jj_3R_10();
    }

    private boolean jj_3_19() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_11() {
        return this.jj_3R_26();
    }

    private boolean jj_3_5() {
        return this.jj_3R_6();
    }

    private boolean jj_3_20() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_8()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_9()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_13();
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3_1() {
        return this.jj_3R_4();
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_12() {
        return this.jj_3R_26();
    }

    private boolean jj_3_18() {
        return this.jj_3R_19();
    }

    private boolean jj_3_8() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_11() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_14()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_15()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_16()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_17()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_18()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_19()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_10() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    public KRSSParser(InputStream stream) {
        this(stream, null);
    }

    public KRSSParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new KRSSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public KRSSParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new KRSSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public KRSSParser(KRSSParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(KRSSParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[43];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 43; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 24; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        KRSSParser.jj_la1_init_0();
        KRSSParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = 30402L;

        private LookaheadSuccess() {
        }
    }
}

