/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owlapi.krssrenderer;

import de.uulm.ecs.ai.owlapi.krssrenderer.KRSS2Vocabulary;
import de.uulm.ecs.ai.owlapi.krssrenderer.KRSSObjectRenderer;
import de.uulm.ecs.ai.owlapi.krssrenderer.KRSSVocabulary;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRSS2ObjectRenderer
extends KRSSObjectRenderer {
    private final Set<OWLSubPropertyChainOfAxiom> leftRightIdentityUsed = new HashSet<OWLSubPropertyChainOfAxiom>();
    protected boolean ignoreDeclarations = false;

    public KRSS2ObjectRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer writer) {
        super(manager, ontology, writer);
    }

    public void setIgnoreDeclarations(boolean ignoreDeclarations) {
        this.ignoreDeclarations = ignoreDeclarations;
    }

    protected void write(KRSS2Vocabulary v) {
        this.write(v.toString());
    }

    @Override
    public final void visit(OWLOntology ontology) {
        this.reset();
        for (OWLClass eachClass : ontology.getClassesInSignature()) {
            if (this.ignoreDeclarations && ontology.getAxioms(eachClass).size() == 1 && ontology.getDeclarationAxioms((OWLEntity)eachClass).size() == 1) continue;
            boolean primitive = !eachClass.isDefined(ontology);
            this.writeOpenBracket();
            if (primitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                this.flatten(eachClass.getSuperClasses(ontology), KRSSVocabulary.AND);
                this.writeCloseBracket();
                this.writeln();
                for (OWLClassExpression description : eachClass.getEquivalentClasses(ontology)) {
                    this.writeOpenBracket();
                    this.write((OWLClassExpression)eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.write(description);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write((OWLClassExpression)eachClass);
            this.flatten(eachClass.getEquivalentClasses(ontology), KRSSVocabulary.AND);
            this.writeCloseBracket();
            this.writeln();
            for (OWLClassExpression description : eachClass.getSuperClasses(ontology)) {
                this.writeOpenBracket();
                this.write((OWLClassExpression)eachClass);
                this.write(KRSS2Vocabulary.IMPLIES);
                this.write(description);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLObjectProperty property : this.sort(ontology.getObjectPropertiesInSignature())) {
            Set desc;
            Iterator inverses;
            if (this.ignoreDeclarations && ontology.getAxioms((OWLObjectPropertyExpression)property).size() == 1 && ontology.getDeclarationAxioms((OWLEntity)property).size() == 1) continue;
            this.writeOpenBracket();
            Set properties = property.getEquivalentProperties(ontology);
            boolean isPrimitive = properties.isEmpty();
            if (isPrimitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write((OWLPropertyExpression<?, ?>)property);
                Set superProperties = property.getSuperProperties(ontology);
                if (superProperties.size() == 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENT_ATTR);
                    this.writeSpace();
                    this.write((OWLPropertyExpression)superProperties.iterator().next());
                } else if (superProperties.size() > 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENTS_ATTR);
                    this.writeSpace();
                    this.flattenProperties(superProperties, null);
                } else {
                    Set<OWLSubPropertyChainOfAxiom> chainAxioms = this.getPropertyChainSubPropertyAxiomsFor((OWLPropertyExpression<?, ?>)property);
                    if (chainAxioms.size() == 1) {
                        OWLSubPropertyChainOfAxiom axiom = chainAxioms.iterator().next();
                        if (this.isLeftIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.LEFTIDENTITY_ATTR);
                            this.write((OWLPropertyExpression)axiom.getPropertyChain().get(0));
                        } else if (this.isRightIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.RIGHTIDENTITY_ATTR);
                            this.write((OWLPropertyExpression)axiom.getPropertyChain().get(1));
                        }
                    }
                }
            } else if (properties.isEmpty()) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write((OWLPropertyExpression<?, ?>)property);
                this.writeSpace();
            } else {
                this.write(KRSS2Vocabulary.DEFINE_ROLE);
                this.write((OWLPropertyExpression<?, ?>)property);
                OWLObjectPropertyExpression expr = (OWLObjectPropertyExpression)properties.iterator().next();
                this.write((OWLPropertyExpression<?, ?>)expr);
                properties.remove(expr);
                this.writeSpace();
            }
            if (property.isTransitive(ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (property.isSymmetric(ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (property.isReflexive(ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.REFLEXIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if ((inverses = property.getInverses(ontology).iterator()).hasNext()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.INVERSE_ATTR);
                this.write((OWLPropertyExpression)inverses.next());
            }
            if (!(desc = property.getDomains(ontology)).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.DOMAIN_ATTR);
                this.flatten(desc, KRSSVocabulary.AND);
            }
            if (!(desc = property.getRanges(ontology)).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(desc, KRSSVocabulary.AND);
            }
            this.writeCloseBracket();
            this.writeln();
            while (inverses.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.INVERSE);
                this.write((OWLPropertyExpression<?, ?>)property);
                this.write((OWLPropertyExpression)inverses.next());
                this.writeOpenBracket();
                this.writeln();
            }
            for (OWLObjectPropertyExpression expr : properties) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
                this.write((OWLPropertyExpression<?, ?>)property);
                this.write((OWLPropertyExpression<?, ?>)expr);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLNamedIndividual individual : this.sort(ontology.getIndividualsInSignature())) {
            if (this.ignoreDeclarations && ontology.getAxioms((OWLIndividual)individual).size() == 1 && ontology.getDeclarationAxioms((OWLEntity)individual).size() == 1) continue;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_INDIVIDUAL);
            this.write((OWLIndividual)individual);
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLAxiom axiom : ontology.getAxioms()) {
            axiom.accept((OWLObjectVisitor)this);
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    @Override
    public final void visit(OWLSubClassOfAxiom axiom) {
        if (!(axiom.getSubClass() instanceof OWLClass)) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES);
            this.write(axiom.getSubClass());
            this.write(axiom.getSuperClass());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        List descs = this.sort(axiom.getClassExpressions());
        int size = descs.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DISJOINT);
                this.write((OWLClassExpression)descs.get(i));
                this.write((OWLClassExpression)descs.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        List properties = this.sort(axiom.getProperties());
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
                this.write((OWLPropertyExpression)properties.get(i));
                this.write((OWLPropertyExpression)properties.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        List properties = this.sort(axiom.getProperties());
        int size = properties.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DISJOINT_ROLES);
                this.write((OWLPropertyExpression)properties.get(i));
                this.write((OWLPropertyExpression)properties.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
    }

    @Override
    public final void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write(axiom.getProperty());
        this.write((OWLIndividual)axiom.getObject());
        this.writeln();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!(axiom.getSubProperty() instanceof OWLObjectProperty)) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES_ROLE);
            this.write(axiom.getSubProperty());
            this.write(axiom.getSuperProperty());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        List descriptions = this.sort(axiom.getClassExpressions());
        int size = descriptions.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write((OWLClassExpression)descriptions.get(i));
                this.write((OWLClassExpression)descriptions.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (this.leftRightIdentityUsed.contains(axiom)) {
            return;
        }
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ROLE_INCLUSTION);
        this.writeSpace();
        this.writeChain(axiom.getPropertyChain(), 0);
        this.writeSpace();
        this.write((OWLPropertyExpression<?, ?>)axiom.getSuperProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    protected void writeChain(List<OWLObjectPropertyExpression> expressions, int i) {
        if (i == expressions.size() - 1) {
            this.write((OWLPropertyExpression)expressions.get(i));
        } else {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.COMPOSE);
            this.write((OWLPropertyExpression)expressions.get(i));
            this.writeChain(expressions, i + 1);
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
        this.writeln();
    }

    @Override
    public final void visit(OWLClass desc) {
        this.write(desc.getIRI());
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ONE_OF);
        for (OWLIndividual individual : desc.getIndividuals()) {
            this.write(individual);
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public final void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INV);
        this.writeSpace();
        property.getInverseProperty();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    protected boolean isLeftIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        Iterator chain;
        if (axiom.getSuperProperty().equals(property) && (chain = axiom.getPropertyChain().iterator()).hasNext() && chain.next() instanceof OWLObjectProperty && chain.hasNext() && ((OWLObjectPropertyExpression)chain.next()).equals(property)) {
            return !chain.hasNext();
        }
        return false;
    }

    protected boolean isRightIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        Iterator chain;
        if (axiom.getSuperProperty().equals(property) && (chain = axiom.getPropertyChain().iterator()).hasNext() && ((OWLObjectPropertyExpression)chain.next()).equals(property) && chain.hasNext()) {
            chain.next();
            return !chain.hasNext();
        }
        return false;
    }

    protected Set<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxiomsFor(OWLPropertyExpression<?, ?> property) {
        HashSet<OWLSubPropertyChainOfAxiom> axioms = new HashSet<OWLSubPropertyChainOfAxiom>();
        for (OWLSubPropertyChainOfAxiom axiom : this.ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            if (!axiom.getSuperProperty().equals(property)) continue;
            axioms.add(axiom);
        }
        return axioms;
    }

    public void reset() {
        this.leftRightIdentityUsed.clear();
    }
}

