/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.obolibrary.macro.AbstractDataVisitorEx;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionGCIVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger(MacroExpansionGCIVisitor.class);
    protected final OWLOntology inputOntology;
    protected final OWLOntology outputOntology;
    protected final AbstractDataVisitorEx dataVisitor;
    protected final boolean shouldAddExpansionMarker;
    protected boolean preserveAnnotationsWhenExpanding = false;

    public MacroExpansionGCIVisitor(OWLOntology inputOntology, OWLOntologyManager outputManager, boolean preserveAnnotationsWhenExpanding) {
        this(outputManager, inputOntology, false);
        this.preserveAnnotationsWhenExpanding = preserveAnnotationsWhenExpanding;
    }

    public MacroExpansionGCIVisitor(OWLOntologyManager outputManager, OWLOntology inputOntology, boolean shouldAddExpansionMarker) {
        this.inputOntology = inputOntology;
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
        try {
            this.outputOntology = outputManager.createOntology(inputOntology.getOntologyID());
        }
        catch (Exception ex) {
            throw new OWLRuntimeException((Throwable)ex);
        }
        this.dataVisitor = new AbstractDataVisitorEx(inputOntology.getOWLOntologyManager().getOWLDataFactory());
    }

    public OWLOntology createGCIOntology() {
        MacroExpansions expansions = new MacroExpansions();
        this.outputOntology.add(expansions.getNewAxioms());
        this.outputOntology.remove(expansions.getRmAxioms());
        return this.outputOntology;
    }

    public boolean shouldPreserveAnnotationsWhenExpanding() {
        return this.preserveAnnotationsWhenExpanding;
    }

    public void setPreserveAnnotationsWhenExpanding(boolean preserveAnnotationsWhenExpanding) {
        this.preserveAnnotationsWhenExpanding = preserveAnnotationsWhenExpanding;
    }

    private class GCIVisitor
    extends AbstractMacroExpansionVisitor {
        final Set<OWLAnnotation> expansionMarkingAnnotations;

        GCIVisitor(OWLOntology inputOntology, Set<OWLAxiom> newAxioms) {
            super(inputOntology, MacroExpansionGCIVisitor.this.shouldAddExpansionMarker);
            this.expansionMarkingAnnotations = MacroExpansionGCIVisitor.this.shouldAddExpansionMarker ? Collections.singleton(this.expansionMarkerAnnotation) : EMPTY_ANNOTATIONS;
            this.rangeVisitor = MacroExpansionGCIVisitor.this.dataVisitor;
            this.classVisitor = new ClassVisitor(newAxioms);
            this.rebuild(inputOntology);
        }

        class ClassVisitor
        extends AbstractMacroExpansionVisitor.AbstractClassExpressionVisitorEx {
            private Set<OWLAxiom> newAxioms;

            public ClassVisitor(Set<OWLAxiom> newAxioms) {
                super(GCIVisitor.this);
                this.newAxioms = newAxioms;
            }

            @Override
            @Nullable
            protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
                OWLClassExpression gciRHS = GCIVisitor.this.expandObject(filler, p);
                if (gciRHS != null) {
                    OWLObjectSomeValuesFrom gciLHS = GCIVisitor.this.df.getOWLObjectSomeValuesFrom(p, filler);
                    OWLEquivalentClassesAxiom ax = GCIVisitor.this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS, GCIVisitor.this.expansionMarkingAnnotations);
                    this.newAxioms.add((OWLAxiom)ax);
                }
                return gciRHS;
            }

            @Override
            @Nullable
            protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
                OWLClassExpression gciRHS = GCIVisitor.this.expandObject(filler, p);
                if (gciRHS != null) {
                    OWLObjectHasValue gciLHS = GCIVisitor.this.df.getOWLObjectHasValue(p, filler);
                    OWLEquivalentClassesAxiom ax = GCIVisitor.this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS, GCIVisitor.this.expansionMarkingAnnotations);
                    this.newAxioms.add((OWLAxiom)ax);
                }
                return gciRHS;
            }
        }
    }

    private class MacroExpansions {
        private final Set<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        private final Set<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();
        GCIVisitor visitor;

        public MacroExpansions() {
            this.visitor = new GCIVisitor(MacroExpansionGCIVisitor.this.inputOntology, this.newAxioms);
            MacroExpansionGCIVisitor.this.inputOntology.axioms(AxiomType.SUBCLASS_OF).forEach(axiom -> {
                OWLAxiom cfr_ignored_0 = (OWLAxiom)axiom.accept((OWLAxiomVisitorEx)this.visitor);
            });
            MacroExpansionGCIVisitor.this.inputOntology.axioms(AxiomType.EQUIVALENT_CLASSES).forEach(axiom -> {
                OWLAxiom cfr_ignored_0 = (OWLAxiom)axiom.accept((OWLAxiomVisitorEx)this.visitor);
            });
            MacroExpansionGCIVisitor.this.inputOntology.axioms(AxiomType.CLASS_ASSERTION).forEach(axiom -> {
                OWLAxiom cfr_ignored_0 = (OWLAxiom)axiom.accept((OWLAxiomVisitorEx)this.visitor);
            });
            MacroExpansionGCIVisitor.this.inputOntology.axioms(AxiomType.ANNOTATION_ASSERTION).forEach(this::expand);
        }

        public Set<OWLAxiom> getNewAxioms() {
            return this.newAxioms;
        }

        public Set<OWLAxiom> getRmAxioms() {
            return this.rmAxioms;
        }

        private boolean expand(OWLAnnotationAssertionAxiom ax) {
            OWLAnnotationProperty prop = (OWLAnnotationProperty)ax.getProperty();
            AtomicBoolean didExpansion = new AtomicBoolean(false);
            String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
            if (expandTo != null) {
                LOG.info("Template to Expand{}", (Object)expandTo);
                expandTo = expandTo.replaceAll("\\?X", this.visitor.getTool().getId((IRI)ax.getSubject()));
                expandTo = expandTo.replaceAll("\\?Y", this.visitor.getTool().getId((IRI)ax.getValue()));
                LOG.info("Expanding {}", (Object)expandTo);
                try {
                    this.visitor.getTool().parseManchesterExpressionFrames(expandTo).forEach(axp -> {
                        OWLAxiom axiom = axp.getAxiom();
                        if (MacroExpansionGCIVisitor.this.shouldPreserveAnnotationsWhenExpanding()) {
                            axiom = axiom.getAnnotatedAxiom(this.visitor.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)ax));
                        }
                        this.newAxioms.add(axiom);
                        didExpansion.set(true);
                    });
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return didExpansion.get();
        }
    }
}

