/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacroExpansionVisitor
implements OWLAxiomVisitorEx<OWLAxiom> {
    static final Logger LOG = LoggerFactory.getLogger(AbstractMacroExpansionVisitor.class);
    static final Set<OWLAnnotation> EMPTY_ANNOTATIONS = Collections.emptySet();
    final OWLDataFactory df;
    @Nonnull
    final Map<IRI, String> expandAssertionToMap;
    @Nonnull
    protected final Map<IRI, String> expandExpressionMap;
    @Nonnull
    protected OWLDataVisitorEx<OWLDataRange> rangeVisitor;
    @Nonnull
    protected OWLClassExpressionVisitorEx<OWLClassExpression> classVisitor;
    protected ManchesterSyntaxTool manchesterSyntaxTool;
    protected final OWLAnnotationProperty OIO_ISEXPANSION;
    protected final OWLAnnotation expansionMarkerAnnotation;
    private boolean shouldAddExpansionMarker = false;

    protected AbstractMacroExpansionVisitor(OWLOntology ontology, boolean shouldAddExpansionMarker) {
        this(ontology);
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
    }

    protected AbstractMacroExpansionVisitor(OWLOntology o) {
        this.df = o.getOWLOntologyManager().getOWLDataFactory();
        this.expandExpressionMap = new HashMap<IRI, String>();
        this.expandAssertionToMap = new HashMap<IRI, String>();
        OWLAnnotationProperty ap424 = this.df.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000424.getIRI());
        o.objectPropertiesInSignature().forEach(p -> EntitySearcher.getAnnotationObjects((OWLEntity)p, (Stream)o.importsClosure(), (OWLAnnotationProperty)ap424).forEach(a -> this.mapToExpand((OWLObjectProperty)p, (OWLAnnotation)a)));
        o.annotationPropertiesInSignature().forEach(p -> this.expandAssertions(o, (OWLAnnotationProperty)p));
        this.OIO_ISEXPANSION = this.df.getOWLAnnotationProperty(IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#", (String)"is_expansion"));
        this.expansionMarkerAnnotation = this.df.getOWLAnnotation(this.OIO_ISEXPANSION, (OWLAnnotationValue)this.df.getOWLLiteral(true));
    }

    protected void mapToExpand(OWLObjectProperty p, OWLAnnotation a) {
        OWLAnnotationValue v = a.getValue();
        if (v instanceof OWLLiteral) {
            String str = ((OWLLiteral)v).getLiteral();
            LOG.info("mapping {} to {}", (Object)p.getIRI(), (Object)str);
            this.expandExpressionMap.put(p.getIRI(), str);
        }
    }

    public OWLAnnotation getExpansionMarkerAnnotation() {
        return this.expansionMarkerAnnotation;
    }

    public OWLAxiom doDefault(Object o) {
        return (OWLAxiom)o;
    }

    public OWLAnnotationProperty getOIO_ISEXPANSION() {
        return this.OIO_ISEXPANSION;
    }

    public void rebuild(OWLOntology input) {
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(input);
    }

    public ManchesterSyntaxTool getTool() {
        return this.manchesterSyntaxTool;
    }

    protected void expandAssertions(OWLOntology o, OWLAnnotationProperty p) {
        OWLAnnotationProperty ap425 = this.df.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000425.getIRI());
        EntitySearcher.getAnnotationObjects((OWLEntity)p, (Stream)o.importsClosure(), (OWLAnnotationProperty)ap425).map(a -> a.getValue().asLiteral()).filter(v -> v.isPresent()).forEach(v -> {
            String str = ((OWLLiteral)v.get()).getLiteral();
            LOG.info("assertion mapping {} to {}", (Object)p, (Object)str);
            this.expandAssertionToMap.put(p.getIRI(), str);
        });
    }

    @Nullable
    protected OWLClassExpression expandObject(Object filler, OWLObjectPropertyExpression p) {
        OWLClassExpression result = null;
        IRI iri = ((OWLObjectProperty)p).getIRI();
        IRI templateVal = null;
        if (this.expandExpressionMap.containsKey(iri)) {
            if (filler instanceof OWLObjectOneOf) {
                templateVal = this.valFromOneOf(filler);
            }
            if (filler instanceof OWLNamedObject) {
                templateVal = ((OWLNamedObject)filler).getIRI();
            }
            if (templateVal != null) {
                result = this.resultFromVal(iri, templateVal);
            }
        }
        return result;
    }

    @Nullable
    protected OWLClassExpression resultFromVal(IRI iri, IRI templateVal) {
        String tStr = this.expandExpressionMap.get(iri);
        String exStr = tStr.replace("?Y", this.manchesterSyntaxTool.getId(templateVal));
        try {
            return this.manchesterSyntaxTool.parseManchesterExpression(exStr);
        }
        catch (ParserException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected IRI valFromOneOf(Object filler) {
        Iterator inds = ((OWLObjectOneOf)filler).individuals().filter(x -> x instanceof OWLNamedIndividual).iterator();
        if (inds.hasNext()) {
            OWLIndividual ind = (OWLIndividual)inds.next();
            if (!inds.hasNext()) {
                return ((OWLNamedObject)ind).getIRI();
            }
        }
        return null;
    }

    public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression newSubclass = (OWLClassExpression)subClass.accept(this.classVisitor);
        OWLClassExpression superClass = axiom.getSuperClass();
        OWLClassExpression newSuperclass = (OWLClassExpression)superClass.accept(this.classVisitor);
        if (subClass.equals(newSubclass) && superClass.equals(newSuperclass)) {
            return axiom;
        }
        return this.df.getOWLSubClassOfAxiom(newSubclass, newSuperclass, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public Set<OWLAnnotation> getAnnotationsWithOptionalExpansionMarker(OWLAxiom axiom) {
        Set annotations = OWLAPIStreamUtils.asSet((Stream)axiom.annotations());
        if (this.shouldAddExpansionMarker) {
            annotations.add(this.expansionMarkerAnnotation);
        }
        return annotations;
    }

    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        HashSet ops = new HashSet();
        AtomicBoolean sawChange = new AtomicBoolean(false);
        axiom.classExpressions().forEach(op -> {
            OWLClassExpression newOp = (OWLClassExpression)op.accept(this.classVisitor);
            ops.add(newOp);
            if (!op.equals(newOp)) {
                sawChange.set(true);
            }
        });
        if (!sawChange.get()) {
            return axiom;
        }
        return this.df.getOWLDisjointClassesAxiom(ops, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        HashSet newOps = new HashSet();
        AtomicBoolean sawChange = new AtomicBoolean(false);
        axiom.classExpressions().forEach(op -> {
            OWLClassExpression newOp = (OWLClassExpression)op.accept(this.classVisitor);
            newOps.add(newOp);
            if (!op.equals(newOp)) {
                sawChange.set(true);
            }
        });
        if (!sawChange.get()) {
            return axiom;
        }
        return this.df.getOWLDisjointUnionAxiom(axiom.getOWLClass(), newOps, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = (OWLClassExpression)axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept(this.classVisitor))) {
            return axiom;
        }
        return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = (OWLClassExpression)axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept(this.classVisitor))) {
            return axiom;
        }
        return this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression newRange;
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        if (range.equals(newRange = (OWLClassExpression)range.accept(this.classVisitor))) {
            return axiom;
        }
        return this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        OWLDataRange newRange;
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        if (range.equals(newRange = (OWLDataRange)range.accept(this.rangeVisitor))) {
            return axiom;
        }
        return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        OWLClassExpression newClassExpression;
        OWLClassExpression classExpression = axiom.getClassExpression();
        if (classExpression.isAnonymous() && !classExpression.equals(newClassExpression = (OWLClassExpression)classExpression.accept(this.classVisitor))) {
            return this.df.getOWLClassAssertionAxiom(newClassExpression, axiom.getIndividual(), this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        HashSet newExpressions = new HashSet();
        AtomicBoolean sawChange = new AtomicBoolean(false);
        axiom.classExpressions().forEach(op -> {
            OWLClassExpression newExpression = (OWLClassExpression)op.accept(this.classVisitor);
            newExpressions.add(newExpression);
            if (!op.equals(newExpression)) {
                sawChange.set(true);
            }
        });
        if (!sawChange.get()) {
            return axiom;
        }
        return this.df.getOWLEquivalentClassesAxiom(newExpressions, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public abstract class AbstractClassExpressionVisitorEx
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected AbstractClassExpressionVisitorEx() {
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf ce) {
            return AbstractMacroExpansionVisitor.this.df.getOWLObjectIntersectionOf(ce.operands().map(o -> (OWLClassExpression)o.accept((OWLClassExpressionVisitorEx)this)));
        }

        public OWLClassExpression visit(OWLObjectUnionOf ce) {
            return AbstractMacroExpansionVisitor.this.df.getOWLObjectUnionOf(ce.operands().map(o -> (OWLClassExpression)o.accept((OWLClassExpressionVisitorEx)this)));
        }

        public OWLClassExpression visit(OWLObjectComplementOf ce) {
            return AbstractMacroExpansionVisitor.this.df.getOWLObjectComplementOf((OWLClassExpression)ce.getOperand().accept((OWLClassExpressionVisitorEx)this));
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom ce) {
            OWLClassExpression filler = (OWLClassExpression)ce.getFiller();
            OWLObjectPropertyExpression p = ce.getProperty();
            OWLClassExpression result = null;
            if (p.isOWLObjectProperty()) {
                result = this.expandOWLObjSomeVal(filler, p);
            }
            if (result == null) {
                result = AbstractMacroExpansionVisitor.this.df.getOWLObjectSomeValuesFrom(ce.getProperty(), (OWLClassExpression)filler.accept((OWLClassExpressionVisitorEx)this));
            }
            return result;
        }

        @Nullable
        protected abstract OWLClassExpression expandOWLObjSomeVal(OWLClassExpression var1, OWLObjectPropertyExpression var2);

        public OWLClassExpression visit(OWLObjectHasValue ce) {
            OWLClassExpression result = null;
            OWLIndividual filler = (OWLIndividual)ce.getFiller();
            OWLObjectPropertyExpression p = ce.getProperty();
            if (p.isOWLObjectProperty()) {
                result = this.expandOWLObjHasVal(ce, filler, p);
            }
            if (result == null) {
                result = AbstractMacroExpansionVisitor.this.df.getOWLObjectHasValue(ce.getProperty(), filler);
            }
            return result;
        }

        @Nullable
        protected abstract OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue var1, OWLIndividual var2, OWLObjectPropertyExpression var3);

        public OWLClassExpression visit(OWLObjectAllValuesFrom ce) {
            return (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public OWLClassExpression visit(OWLObjectMinCardinality ce) {
            OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
            return AbstractMacroExpansionVisitor.this.df.getOWLObjectMinCardinality(ce.getCardinality(), ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality ce) {
            return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality ce) {
            OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
            return AbstractMacroExpansionVisitor.this.df.getOWLObjectMaxCardinality(ce.getCardinality(), ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom ce) {
            OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept(AbstractMacroExpansionVisitor.this.rangeVisitor);
            return AbstractMacroExpansionVisitor.this.df.getOWLDataSomeValuesFrom(ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom ce) {
            OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept(AbstractMacroExpansionVisitor.this.rangeVisitor);
            return AbstractMacroExpansionVisitor.this.df.getOWLDataAllValuesFrom(ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataHasValue ce) {
            return (OWLClassExpression)ce.asSomeValuesFrom().accept((OWLClassExpressionVisitorEx)this);
        }

        public OWLClassExpression visit(OWLDataExactCardinality ce) {
            return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality ce) {
            int card = ce.getCardinality();
            OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept(AbstractMacroExpansionVisitor.this.rangeVisitor);
            return AbstractMacroExpansionVisitor.this.df.getOWLDataMaxCardinality(card, ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataMinCardinality ce) {
            int card = ce.getCardinality();
            OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept(AbstractMacroExpansionVisitor.this.rangeVisitor);
            return AbstractMacroExpansionVisitor.this.df.getOWLDataMinCardinality(card, ce.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLClass ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLObjectHasSelf ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLObjectOneOf ce) {
            return ce;
        }
    }
}

