/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPIOwl2Obo {
    private static final String MIN_CARDINALITY = "minCardinality";
    private static final String MAX_CARDINALITY = "maxCardinality";
    @Nonnull
    private static final String TOP_BOTTOM_NONTRANSLATEABLE = "Assertions using owl:Thing or owl:Nothing are not translateable OBO";
    private static final Logger LOG = LoggerFactory.getLogger(OWLAPIOwl2Obo.class);
    private static final String IRI_CLASS_SYNONYMTYPEDEF = "http://purl.obolibrary.org/obo/IAO_synonymtypedef";
    private static final String IRI_CLASS_SUBSETDEF = "http://purl.obolibrary.org/obo/IAO_subsetdef";
    protected final Pattern absoulteURLPattern = Pattern.compile("<\\s*http.*?>");
    private static final Set<String> SKIPPED_QUALIFIERS = new HashSet<String>(Arrays.asList("gci_relation", "gci_filler", "cardinality", "minCardinality", "maxCardinality", "all_some", "all_only"));
    @Nonnull
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected final OWLDataFactory fac;
    protected OBODoc obodoc;
    protected Set<OWLAxiom> untranslatableAxioms;
    protected Map<String, String> idSpaceMap;
    @Nonnull
    public static final Map<String, String> ANNOTATIONPROPERTYMAP = OWLAPIOwl2Obo.initAnnotationPropertyMap();
    protected Set<OWLAnnotationProperty> apToDeclare;
    protected String ontologyId;
    protected boolean strictConversion;
    protected boolean discardUntranslatable = false;
    private boolean muteUntranslatableAxioms = false;

    protected final void init() {
        this.idSpaceMap = new HashMap<String, String>();
        this.idSpaceMap.put("http://www.obofoundry.org/ro/ro.owl#", "OBO_REL");
        this.untranslatableAxioms = new HashSet<OWLAxiom>();
        this.apToDeclare = new HashSet<OWLAnnotationProperty>();
    }

    public OWLAPIOwl2Obo(@Nonnull OWLOntologyManager translationManager) {
        this.manager = translationManager;
        this.fac = this.manager.getOWLDataFactory();
        this.init();
    }

    @Nonnull
    protected static Map<String, String> initAnnotationPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : OWLAPIObo2Owl.ANNOTATIONPROPERTYMAP.keySet()) {
            IRI propIRI = OWLAPIObo2Owl.ANNOTATIONPROPERTYMAP.get(key);
            map.put(propIRI.toString(), key);
        }
        return map;
    }

    public void setStrictConversion(boolean b) {
        this.strictConversion = b;
    }

    public boolean getStrictConversion() {
        return this.strictConversion;
    }

    public boolean isDiscardUntranslatable() {
        return this.discardUntranslatable;
    }

    public void setDiscardUntranslatable(boolean discardUntranslatable) {
        this.discardUntranslatable = discardUntranslatable;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(@Nonnull OWLOntologyManager manager) {
        this.manager = manager;
    }

    @Nonnull
    public OBODoc getObodoc() {
        return (OBODoc)OWLAPIPreconditions.verifyNotNull((Object)this.obodoc);
    }

    public void setObodoc(@Nonnull OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    @Nonnull
    public OBODoc convert(@Nonnull OWLOntology ont) {
        this.owlOntology = ont;
        this.ontologyId = OWLAPIOwl2Obo.getOntologyId(ont);
        this.init();
        return this.tr();
    }

    @Nonnull
    protected OWLOntology getOWLOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.owlOntology);
    }

    public Collection<OWLAxiom> getUntranslatableAxioms() {
        return this.untranslatableAxioms;
    }

    @Nonnull
    protected OBODoc tr() {
        this.setObodoc(new OBODoc());
        this.preProcess();
        this.tr(this.getOWLOntology());
        ArrayList axioms = new ArrayList(this.getOWLOntology().getAxioms(AxiomType.DECLARATION));
        axioms.sort(null);
        axioms.forEach(this::consume);
        AxiomType.skipDeclarations().flatMap(t -> this.getOWLOntology().getAxioms(t).stream()).map(x -> x).forEach(this::consume);
        if (!this.untranslatableAxioms.isEmpty() && !this.discardUntranslatable) {
            try {
                String axiomString = OwlStringTools.translate(this.untranslatableAxioms, this.manager);
                if (axiomString != null) {
                    Frame headerFrame = this.getObodoc().getHeaderFrame();
                    if (headerFrame == null) {
                        headerFrame = new Frame(Frame.FrameType.HEADER);
                        this.getObodoc().setHeaderFrame(headerFrame);
                    }
                    headerFrame.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS, axiomString));
                }
            }
            catch (OwlStringTools.OwlStringException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
        return this.getObodoc();
    }

    protected void consume(OWLAxiom ax) {
        if (ax instanceof OWLDeclarationAxiom) {
            this.tr((OWLDeclarationAxiom)ax);
        } else if (ax instanceof OWLSubClassOfAxiom) {
            this.tr((OWLSubClassOfAxiom)ax);
        } else if (ax instanceof OWLDisjointClassesAxiom) {
            this.tr((OWLDisjointClassesAxiom)ax);
        } else if (ax instanceof OWLEquivalentClassesAxiom) {
            this.tr((OWLEquivalentClassesAxiom)ax);
        } else if (ax instanceof OWLClassAssertionAxiom) {
            this.tr((OWLClassAssertionAxiom)ax);
        } else if (ax instanceof OWLEquivalentObjectPropertiesAxiom) {
            this.tr((OWLEquivalentObjectPropertiesAxiom)ax);
        } else if (ax instanceof OWLSubAnnotationPropertyOfAxiom) {
            this.tr((OWLSubAnnotationPropertyOfAxiom)ax);
        } else if (ax instanceof OWLSubObjectPropertyOfAxiom) {
            this.tr((OWLSubObjectPropertyOfAxiom)ax);
        } else if (ax instanceof OWLObjectPropertyRangeAxiom) {
            this.tr((OWLObjectPropertyRangeAxiom)ax);
        } else if (ax instanceof OWLFunctionalObjectPropertyAxiom) {
            this.tr((OWLFunctionalObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLSymmetricObjectPropertyAxiom) {
            this.tr((OWLSymmetricObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLAsymmetricObjectPropertyAxiom) {
            this.tr((OWLAsymmetricObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLObjectPropertyDomainAxiom) {
            this.tr((OWLObjectPropertyDomainAxiom)ax);
        } else if (ax instanceof OWLInverseFunctionalObjectPropertyAxiom) {
            this.tr((OWLInverseFunctionalObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLInverseObjectPropertiesAxiom) {
            this.tr((OWLInverseObjectPropertiesAxiom)ax);
        } else if (ax instanceof OWLDisjointObjectPropertiesAxiom) {
            this.tr((OWLDisjointObjectPropertiesAxiom)ax);
        } else if (ax instanceof OWLReflexiveObjectPropertyAxiom) {
            this.tr((OWLReflexiveObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLTransitiveObjectPropertyAxiom) {
            this.tr((OWLTransitiveObjectPropertyAxiom)ax);
        } else if (ax instanceof OWLSubPropertyChainOfAxiom) {
            this.tr((OWLSubPropertyChainOfAxiom)ax);
        } else if (!(ax instanceof OWLAnnotationAssertionAxiom)) {
            this.error(ax, false);
        }
    }

    protected void preProcess() {
        String viewRel = null;
        for (OWLAnnotation ann : this.getOWLOntology().getAnnotations()) {
            if (!ann.getProperty().getIRI().equals((Object)Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.getIRI())) continue;
            OWLAnnotationValue v = ann.getValue();
            if (v instanceof OWLLiteral) {
                viewRel = ((OWLLiteral)v).getLiteral();
                break;
            }
            viewRel = OWLAPIOwl2Obo.getIdentifier((IRI)v);
            break;
        }
        if (viewRel != null) {
            HashSet<OWLEquivalentClassesAxiom> rmAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            HashSet<OWLEquivalentClassesAxiom> newAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            for (OWLEquivalentClassesAxiom eca : this.getOWLOntology().getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                int numNamed = 0;
                HashSet<Object> xs = new HashSet<Object>();
                for (OWLClassExpression x : eca.getClassExpressions()) {
                    if (x instanceof OWLClass) {
                        xs.add(x);
                        ++numNamed;
                        continue;
                    }
                    if (x instanceof OWLObjectSomeValuesFrom) {
                        OWLObjectProperty p = (OWLObjectProperty)((OWLObjectSomeValuesFrom)x).getProperty();
                        if (!this.getIdentifier((OWLObject)p).equals(viewRel)) {
                            LOG.error("Expected: {} got: {} in {}", new Object[]{viewRel, p, eca});
                        }
                        xs.add(((OWLObjectSomeValuesFrom)x).getFiller());
                        continue;
                    }
                    LOG.error("Unexpected: {}", (Object)eca);
                }
                if (numNamed == 1) {
                    rmAxioms.add(eca);
                    newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
                    continue;
                }
                LOG.error("ECA did not fit expected pattern: {}", (Object)eca);
            }
            this.getOWLOntology().getOWLOntologyManager().removeAxioms(this.getOWLOntology(), rmAxioms);
            this.getOWLOntology().getOWLOntologyManager().addAxioms(this.getOWLOntology(), newAxioms);
        }
    }

    protected void add(@Nullable Frame f) {
        if (f != null) {
            try {
                this.getObodoc().addFrame(f);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected boolean trObjectProperty(@Nullable OWLObjectProperty prop, @Nullable String tag, @Nullable String value, @Nonnull Set<OWLAnnotation> annotations) {
        Clause clause;
        if (prop == null || value == null) {
            return false;
        }
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(tag)) {
            clause = f.getClause(tag);
            if (tag != null) {
                clause.setValue(value);
            } else {
                clause = new Clause(tag, value);
                f.addClause(clause);
            }
        } else {
            clause = new Clause(tag, value);
            f.addClause(clause);
        }
        OWLAPIOwl2Obo.addQualifiers(clause, annotations);
        return true;
    }

    protected boolean trObjectProperty(@Nullable OWLObjectProperty prop, String tag, @Nullable Boolean value, @Nonnull Set<OWLAnnotation> annotations) {
        if (prop == null || value == null) {
            return false;
        }
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        Clause clause = new Clause(tag);
        clause.addValue(value);
        f.addClause(clause);
        OWLAPIOwl2Obo.addQualifiers(clause, annotations);
        return true;
    }

    protected void trNaryPropertyAxiom(@Nonnull OWLNaryPropertyAxiom<OWLObjectPropertyExpression> ax, String tag) {
        Set set = ax.getProperties();
        if (set.size() > 1) {
            boolean first = true;
            OWLObjectProperty prop = null;
            String disjointFrom = null;
            for (OWLObjectPropertyExpression ex : set) {
                if (ex.isBottomEntity() || ex.isTopEntity()) {
                    this.error(tag + " using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
                    return;
                }
                if (first) {
                    first = false;
                    if (!(ex instanceof OWLObjectProperty)) continue;
                    prop = (OWLObjectProperty)ex;
                    continue;
                }
                disjointFrom = this.getIdentifier((OWLObject)ex);
            }
            if (this.trObjectProperty(prop, tag, disjointFrom, (Set<OWLAnnotation>)ax.getAnnotations())) {
                return;
            }
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLSubPropertyChainOfAxiom ax) {
        Clause clause;
        OWLObjectPropertyExpression pEx = ax.getSuperProperty();
        if (pEx.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLObjectProperty p = pEx.asOWLObjectProperty();
        if (p.isBottomEntity() || p.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
            return;
        }
        List list = ax.getPropertyChain();
        if (list.size() != 2) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLObjectPropertyExpression exp1 = (OWLObjectPropertyExpression)list.get(0);
        OWLObjectPropertyExpression exp2 = (OWLObjectPropertyExpression)list.get(1);
        if (exp1.isBottomEntity() || exp1.isTopEntity() || exp2.isBottomEntity() || exp2.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
            return;
        }
        String rel1 = this.getIdentifier((OWLObject)exp1);
        String rel2 = this.getIdentifier((OWLObject)exp2);
        if (rel1 == null || rel2 == null) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        HashSet<OWLAnnotation> unprocessedAnnotations = new HashSet<OWLAnnotation>(ax.getAnnotations());
        Frame f = this.getTypedefFrame((OWLEntity)p);
        if (rel1.equals(f.getId())) {
            clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER, rel2);
        } else {
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                if (!"http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain".equals(ann.getProperty().getIRI().toString())) continue;
                tag = OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN;
                unprocessedAnnotations.remove(ann);
                break;
            }
            clause = new Clause(tag);
            clause.addValue(rel1);
            clause.addValue(rel2);
        }
        f.addClause(clause);
        OWLAPIOwl2Obo.addQualifiers(clause, unprocessedAnnotations);
    }

    protected void tr(@Nonnull OWLEquivalentObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
    }

    protected void tr(@Nonnull OWLTransitiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLDisjointObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
    }

    protected void tr(@Nonnull OWLReflexiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLInverseFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLInverseObjectPropertiesAxiom ax) {
        OWLObjectPropertyExpression prop1 = ax.getFirstProperty();
        OWLObjectPropertyExpression prop2 = ax.getSecondProperty();
        if (prop1 instanceof OWLObjectProperty && prop2 instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop1, OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag(), this.getIdentifier((OWLObject)prop2), (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLObjectPropertyDomainAxiom ax) {
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        OWLClassExpression domain = ax.getDomain();
        if (domain.isBottomEntity() || domain.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("domains using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax, false);
            return;
        }
        String range = this.getIdentifier((OWLObject)domain);
        if (range != null) {
            if (this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag(), range, (Set<OWLAnnotation>)ax.getAnnotations())) {
                return;
            }
            this.error("trObjectProperty failed for " + prop, (OWLAxiom)ax, true);
        } else {
            this.error("no range translatable for " + ax, false);
        }
    }

    protected void tr(@Nonnull OWLAsymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLSymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(@Nonnull OWLObjectPropertyRangeAxiom ax) {
        OWLClassExpression owlRange = (OWLClassExpression)ax.getRange();
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        if (owlRange.isBottomEntity() || owlRange.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("ranges using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax, false);
            return;
        }
        String range = this.getIdentifier((OWLObject)owlRange);
        if (range != null && this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag(), range, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax, false);
    }

    protected void tr(@Nonnull OWLSubObjectPropertyOfAxiom ax) {
        OWLObjectPropertyExpression sup = (OWLObjectPropertyExpression)ax.getSuperProperty();
        OWLObjectPropertyExpression sub = (OWLObjectPropertyExpression)ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sup.isTopEntity()) {
            this.error("SubProperties using Top or Bottom entites are not supported in OBO.", false);
            return;
        }
        if (sub instanceof OWLObjectProperty && sup instanceof OWLObjectProperty) {
            String supId = this.getIdentifier((OWLObject)sup);
            if (supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)((OWLObjectProperty)sub));
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            OWLAPIOwl2Obo.addQualifiers(clause, ax.getAnnotations());
        } else {
            this.error((OWLAxiom)ax, true);
        }
    }

    protected void tr(@Nonnull OWLSubAnnotationPropertyOfAxiom ax) {
        OWLAnnotationProperty sup = ax.getSuperProperty();
        OWLAnnotationProperty sub = ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sup.isTopEntity()) {
            this.error("SubAnnotationProperties using Top or Bottom entites are not supported in OBO.", false);
            return;
        }
        String tagObject = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)sup);
        if (OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag().equals(tagObject)) {
            String name = "";
            String scope = null;
            for (OWLAnnotationAssertionAxiom axiom : this.getOWLOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)sub.getIRI())) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getProperty());
                if (OBOFormatConstants.OboFormatTag.TAG_NAME.getTag().equals(tg)) {
                    name = ((OWLLiteral)axiom.getValue()).getLiteral();
                    continue;
                }
                if (!OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag().equals(tg)) continue;
                scope = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getValue());
            }
            Frame hf = this.getObodoc().getHeaderFrame();
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(name);
            if (scope != null) {
                clause.addValue(scope);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, ax.getAnnotations());
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.error("duplicate clause: {} in header", (Object)clause);
            }
            return;
        }
        if (OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag().equals(tagObject)) {
            String comment = "";
            for (OWLAnnotationAssertionAxiom axiom : this.getOWLOntology().getAnnotationAssertionAxioms((OWLAnnotationSubject)sub.getIRI())) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getProperty());
                if (!OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tg)) continue;
                comment = ((OWLLiteral)axiom.getValue()).getLiteral();
                break;
            }
            Frame hf = this.getObodoc().getHeaderFrame();
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(comment);
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.error("duplicate clause: {} in header", (Object)clause);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, ax.getAnnotations());
            return;
        }
        if (sub instanceof OWLObjectProperty && sup instanceof OWLObjectProperty) {
            String supId = this.getIdentifier((OWLObject)sup);
            if (supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)sub);
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            OWLAPIOwl2Obo.addQualifiers(clause, ax.getAnnotations());
        } else {
            this.error((OWLAxiom)ax, true);
        }
    }

    protected void tr(@Nonnull OWLAnnotationAssertionAxiom ax, @Nonnull Frame frame) {
        boolean success = this.tr(ax.getProperty(), ax.getValue(), ax.getAnnotations(), frame);
        if (!success) {
            this.untranslatableAxioms.add((OWLAxiom)ax);
        }
    }

    protected boolean tr(OWLAnnotationProperty prop, @Nonnull OWLAnnotationValue annVal, @Nonnull Set<OWLAnnotation> qualifiers, @Nonnull Frame frame) {
        String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
        OBOFormatConstants.OboFormatTag tag = null;
        if (tagString != null) {
            tag = OBOFormatConstants.getTag(tagString);
        }
        if (tag == null) {
            String propId;
            if (annVal instanceof IRI && Frame.FrameType.TERM.equals((Object)frame.getType()) && this.isMetadataTag(prop) && (propId = this.getIdentifier((OWLObject)prop)) != null) {
                Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP);
                clause.addValue(propId);
                clause.addValue(OWLAPIOwl2Obo.getIdentifier((IRI)annVal));
                OWLAPIOwl2Obo.addQualifiers(clause, qualifiers);
                frame.addClause(clause);
                return true;
            }
            return this.trGenericPropertyValue(prop, annVal, qualifiers, frame);
        }
        Object value = this.getValue(annVal, tagString);
        String valueString = value.toString().trim();
        if (!valueString.isEmpty()) {
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ID) {
                if (!frame.getId().equals(value)) {
                    this.warn("Conflicting id definitions: 1) " + frame.getId() + "  2)" + value);
                    return false;
                }
                return true;
            }
            Clause clause = new Clause(tag);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                try {
                    clause.addValue(OBOFormatConstants.headerDateFormat().parseObject(valueString));
                }
                catch (ParseException e) {
                    this.error("Could not parse date string: " + valueString, true);
                    return false;
                }
            } else {
                clause.addValue(value);
            }
            HashSet<OWLAnnotation> unprocessedQualifiers = new HashSet<OWLAnnotation>(qualifiers);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
                for (OWLAnnotation aan : qualifiers) {
                    String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
                    if (!"xref".equals(propId)) continue;
                    OWLAnnotationValue v = aan.getValue();
                    String xrefValue = v instanceof IRI ? v.toString() : ((OWLLiteral)v).getLiteral();
                    Xref xref = new Xref(xrefValue);
                    clause.addXref(xref);
                    unprocessedQualifiers.remove(aan);
                }
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
                Xref xref = new Xref(valueString);
                for (OWLAnnotation annotation : qualifiers) {
                    OWLAnnotationValue owlAnnotationValue;
                    if (!this.fac.getRDFSLabel().equals(annotation.getProperty()) || !((owlAnnotationValue = annotation.getValue()) instanceof OWLLiteral)) continue;
                    unprocessedQualifiers.remove(annotation);
                    String xrefAnnotation = ((OWLLiteral)owlAnnotationValue).getLiteral();
                    if ((xrefAnnotation = xrefAnnotation.trim()).isEmpty()) continue;
                    xref.setAnnotation(xrefAnnotation);
                }
                clause.setValue(xref);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EXACT || tag == OBOFormatConstants.OboFormatTag.TAG_NARROW || tag == OBOFormatConstants.OboFormatTag.TAG_BROAD || tag == OBOFormatConstants.OboFormatTag.TAG_RELATED) {
                this.handleSynonym(qualifiers, tag.getTag(), clause, unprocessedQualifiers);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
                String synonymType = null;
                this.handleSynonym(qualifiers, synonymType, clause, unprocessedQualifiers);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, unprocessedQualifiers);
            boolean redundant = false;
            for (Clause frameClause : frame.getClauses()) {
                if (!clause.equals(frameClause)) continue;
                redundant = this.handleDuplicateClause(frame, frameClause);
            }
            if (!redundant) {
                frame.addClause(clause);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isMetadataTag(OWLAnnotationProperty p) {
        IRI metadataTagIRI = IRI.create((String)("http://www.geneontology.org/formats/oboInOwl#" + OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag()));
        Set axioms = this.owlOntology.getAnnotationAssertionAxioms((OWLAnnotationSubject)p.getIRI());
        for (OWLAnnotationAssertionAxiom ax : axioms) {
            if (!metadataTagIRI.equals((Object)ax.getProperty().getIRI())) continue;
            return true;
        }
        return false;
    }

    protected void handleSynonym(@Nonnull Set<OWLAnnotation> qualifiers, @Nullable String scope, @Nonnull Clause clause, @Nonnull Set<OWLAnnotation> unprocessedQualifiers) {
        clause.setTag(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag());
        String type = null;
        clause.setXrefs(new ArrayList<Xref>());
        for (OWLAnnotation aan : qualifiers) {
            String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
            if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(propId)) {
                OWLAnnotationValue v = aan.getValue();
                String xrefValue = v instanceof IRI ? v.toString() : ((OWLLiteral)v).getLiteral();
                Xref xref = new Xref(xrefValue);
                clause.addXref(xref);
                unprocessedQualifiers.remove(aan);
                continue;
            }
            if (!OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag().equals(propId)) continue;
            type = this.getIdentifier((OWLObject)aan.getValue());
            unprocessedQualifiers.remove(aan);
        }
        if (scope != null) {
            clause.addValue(scope);
            if (type != null) {
                clause.addValue(type);
            }
        }
    }

    protected boolean handleDuplicateClause(@Nonnull Frame frame, Clause clause) {
        LOG.error("Duplicate clause '{}' generated in frame: {}", (Object)clause, (Object)frame.getId());
        return true;
    }

    protected boolean trGenericPropertyValue(OWLAnnotationProperty prop, OWLAnnotationValue annVal, @Nonnull Set<OWLAnnotation> qualifiers, @Nonnull Frame frame) {
        Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        String propId = this.getIdentifier((OWLObject)prop);
        OWLAPIOwl2Obo.addQualifiers(clause, qualifiers);
        if (!propId.equals("shorthand")) {
            clause.addValue(propId);
            if (annVal instanceof OWLLiteral) {
                OWLLiteral owlLiteral = (OWLLiteral)annVal;
                clause.addValue(owlLiteral.getLiteral());
                OWLDatatype datatype = owlLiteral.getDatatype();
                IRI dataTypeIri = datatype.getIRI();
                if (!OWL2Datatype.isBuiltIn((IRI)dataTypeIri)) {
                    this.error("Untranslatable axiom due to unknown data type: " + annVal, true);
                    return false;
                }
                if (Namespaces.XSD.inNamespace(dataTypeIri)) {
                    clause.addValue(dataTypeIri.prefixedBy("xsd:"));
                } else if (dataTypeIri.isPlainLiteral()) {
                    clause.addValue("xsd:string");
                } else {
                    clause.addValue(dataTypeIri.toString());
                }
            } else if (annVal instanceof IRI) {
                clause.addValue(OWLAPIOwl2Obo.getIdentifier((IRI)annVal));
            }
            frame.addClause(clause);
        }
        return true;
    }

    @Nullable
    protected Object getValue(@Nonnull OWLAnnotationValue annVal, String tag) {
        Object value = annVal.toString();
        if (annVal instanceof OWLLiteral) {
            OWLLiteral l = (OWLLiteral)annVal;
            value = l.isBoolean() ? Boolean.valueOf(l.parseBoolean()) : l.getLiteral();
        } else if (annVal instanceof IRI) {
            value = OWLAPIOwl2Obo.getIdentifier((IRI)annVal);
        }
        if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(tag)) {
            String s = value.toString();
            Matcher matcher = this.absoulteURLPattern.matcher(s);
            while (matcher.find()) {
                String m = matcher.group();
                m = m.replace("<", "");
                m = m.replace(">", "");
                int i = m.lastIndexOf(47);
                m = m.substring(i + 1);
                s = s.replace(matcher.group(), m);
            }
            value = s;
        }
        return value;
    }

    protected static void addQualifiers(@Nonnull Clause c, @Nonnull Set<OWLAnnotation> qualifiers) {
        for (OWLAnnotation ann : qualifiers) {
            String prop = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)ann.getProperty());
            if (prop == null) {
                prop = ann.getProperty().getIRI().toString();
            }
            if (SKIPPED_QUALIFIERS.contains(prop)) continue;
            String value = ann.getValue().toString();
            if (ann.getValue() instanceof OWLLiteral) {
                value = ((OWLLiteral)ann.getValue()).getLiteral();
            } else if (ann.getValue() instanceof IRI) {
                value = OWLAPIOwl2Obo.getIdentifier((IRI)ann.getValue());
            }
            assert (value != null);
            QualifierValue qv = new QualifierValue(prop, value);
            c.addQualifierValue(qv);
        }
    }

    public static String getOntologyId(OWLOntology ontology) {
        if (!ontology.getOntologyID().getOntologyIRI().isPresent()) {
            return "";
        }
        return OWLAPIOwl2Obo.getOntologyId((IRI)ontology.getOntologyID().getOntologyIRI().get());
    }

    public static String getOntologyId(@Nonnull IRI iriObj) {
        String id;
        String iri = iriObj.toString();
        if (iri.startsWith("http://purl.obolibrary.org/obo/")) {
            id = iri.replace("http://purl.obolibrary.org/obo/", "");
            if (id.endsWith(".owl")) {
                id = id.replaceFirst(".owl$", "");
            }
        } else {
            id = iri;
        }
        return id;
    }

    @Nullable
    public static String getDataVersion(@Nonnull OWLOntology ontology) {
        String oid = OWLAPIOwl2Obo.getOntologyId(ontology);
        if (ontology.getOntologyID().getVersionIRI().isPresent()) {
            String vs = ((IRI)ontology.getOntologyID().getVersionIRI().get()).toString().replace("http://purl.obolibrary.org/obo/", "");
            vs = vs.replaceFirst(oid + '/', "");
            vs = vs.replace('/' + oid + ".owl", "");
            return vs;
        }
        return null;
    }

    protected void tr(@Nonnull OWLOntology ontology) {
        Frame f = new Frame(Frame.FrameType.HEADER);
        this.getObodoc().setHeaderFrame(f);
        for (IRI iri : ontology.getDirectImportsDocuments()) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IMPORT.getTag());
            c.setValue(iri.toString());
            f.addClause(c);
        }
        String id = OWLAPIOwl2Obo.getOntologyId(ontology);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY.getTag());
        c.setValue(id);
        f.addClause(c);
        String vid = OWLAPIOwl2Obo.getDataVersion(ontology);
        if (vid != null) {
            Clause c2 = new Clause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION.getTag());
            c2.setValue(vid);
            f.addClause(c2);
        }
        for (OWLAnnotation ann : ontology.getAnnotations()) {
            OWLAnnotationProperty property = ann.getProperty();
            String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)property);
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tagString)) {
                property = this.fac.getOWLAnnotationProperty(OWLAPIObo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
            }
            this.tr(property, ann.getValue(), ann.getAnnotations(), f);
        }
    }

    protected void tr(@Nonnull OWLEquivalentClassesAxiom ax) {
        ArrayList<Clause> equivalenceAxiomClauses;
        boolean isUntranslateable;
        Frame f;
        block27: {
            block29: {
                List list2;
                String cls2;
                OWLClassExpression ce2;
                block28: {
                    block26: {
                        Set expressions = ax.getClassExpressions();
                        if (expressions.size() != 2) {
                            this.error((OWLAxiom)ax, false);
                            return;
                        }
                        Iterator it = expressions.iterator();
                        OWLClassExpression ce1 = (OWLClassExpression)it.next();
                        ce2 = (OWLClassExpression)it.next();
                        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
                            this.error("Equivalent classes axioms using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
                            return;
                        }
                        if (!(ce1 instanceof OWLClass)) {
                            if (ce2 instanceof OWLClass) {
                                OWLClassExpression temp = ce2;
                                ce2 = ce1;
                                ce1 = temp;
                            } else {
                                this.error("GCI axioms are not expressible in OBO.", (OWLAxiom)ax, false);
                                return;
                            }
                        }
                        if ((f = this.getTermFrame(ce1.asOWLClass())) == null) {
                            this.error((OWLAxiom)ax, false);
                            return;
                        }
                        isUntranslateable = false;
                        equivalenceAxiomClauses = new ArrayList<Clause>();
                        cls2 = this.getIdentifier((OWLObject)ce2);
                        if (cls2 == null) break block26;
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
                        c.setValue(cls2);
                        f.addClause(c);
                        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
                        break block27;
                    }
                    if (!(ce2 instanceof OWLObjectUnionOf)) break block28;
                    list2 = ((OWLObjectUnionOf)ce2).getOperandsAsList();
                    for (OWLClassExpression oce : list2) {
                        String id = this.getIdentifier((OWLObject)oce);
                        if (id == null) {
                            isUntranslateable = true;
                            this.error((OWLAxiom)ax, true);
                            return;
                        }
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
                        c.setValue(id);
                        equivalenceAxiomClauses.add(c);
                        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
                    }
                    break block27;
                }
                if (!(ce2 instanceof OWLObjectIntersectionOf)) break block29;
                list2 = ((OWLObjectIntersectionOf)ce2).getOperandsAsList();
                for (OWLClassExpression ce : list2) {
                    Boolean allOnly;
                    Boolean allSome;
                    int max;
                    int min;
                    int exact;
                    String r;
                    block31: {
                        Set operands;
                        block35: {
                            OWLClassExpression filler;
                            OWLObjectAllValuesFrom all;
                            block36: {
                                block34: {
                                    OWLObjectExactCardinality card;
                                    block33: {
                                        block32: {
                                            block30: {
                                                r = null;
                                                cls2 = this.getIdentifier((OWLObject)ce);
                                                exact = -1;
                                                min = -1;
                                                max = -1;
                                                allSome = null;
                                                allOnly = null;
                                                if (!(ce instanceof OWLObjectSomeValuesFrom)) break block30;
                                                OWLObjectSomeValuesFrom ristriction = (OWLObjectSomeValuesFrom)ce;
                                                r = this.getIdentifier((OWLObject)ristriction.getProperty());
                                                cls2 = this.getIdentifier((OWLObject)ristriction.getFiller());
                                                break block31;
                                            }
                                            if (!(ce instanceof OWLObjectExactCardinality)) break block32;
                                            card = (OWLObjectExactCardinality)ce;
                                            r = this.getIdentifier((OWLObject)card.getProperty());
                                            cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                            exact = card.getCardinality();
                                            break block31;
                                        }
                                        if (!(ce instanceof OWLObjectMinCardinality)) break block33;
                                        card = (OWLObjectMinCardinality)ce;
                                        r = this.getIdentifier((OWLObject)card.getProperty());
                                        cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                        min = card.getCardinality();
                                        break block31;
                                    }
                                    if (!(ce instanceof OWLObjectMaxCardinality)) break block34;
                                    card = (OWLObjectMaxCardinality)ce;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    max = card.getCardinality();
                                    break block31;
                                }
                                if (!(ce instanceof OWLObjectAllValuesFrom)) break block35;
                                all = (OWLObjectAllValuesFrom)ce;
                                filler = (OWLClassExpression)all.getFiller();
                                if (!(filler instanceof OWLClass)) break block36;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier((OWLObject)filler);
                                allOnly = Boolean.TRUE;
                                break block31;
                            }
                            if (!(filler instanceof OWLObjectComplementOf)) break block31;
                            OWLObjectComplementOf restriction = (OWLObjectComplementOf)filler;
                            r = this.getIdentifier((OWLObject)all.getProperty());
                            cls2 = this.getIdentifier((OWLObject)restriction.getOperand());
                            exact = 0;
                            break block31;
                        }
                        if (ce instanceof OWLObjectIntersectionOf && (operands = ((OWLObjectIntersectionOf)ce).getOperands()).size() == 2) {
                            for (OWLClassExpression operand : operands) {
                                OWLObjectAllValuesFrom all;
                                OWLObjectMinCardinality card;
                                if (operand instanceof OWLObjectMinCardinality) {
                                    card = (OWLObjectMinCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    min = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectMaxCardinality) {
                                    card = (OWLObjectMaxCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    max = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectAllValuesFrom) {
                                    all = (OWLObjectAllValuesFrom)operand;
                                    r = this.getIdentifier((OWLObject)all.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)all.getFiller());
                                    allOnly = Boolean.TRUE;
                                    continue;
                                }
                                if (!(operand instanceof OWLObjectSomeValuesFrom)) continue;
                                all = (OWLObjectSomeValuesFrom)operand;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier((OWLObject)all.getFiller());
                                allSome = Boolean.TRUE;
                            }
                        }
                    }
                    if (cls2 != null) {
                        String string;
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
                        if (r != null) {
                            c.addValue(r);
                        }
                        c.addValue(cls2);
                        equivalenceAxiomClauses.add(c);
                        if (exact > -1) {
                            c.addQualifierValue(new QualifierValue("cardinality", Integer.toString(exact)));
                        }
                        if (min > -1) {
                            c.addQualifierValue(new QualifierValue(MIN_CARDINALITY, Integer.toString(min)));
                        }
                        if (max > -1) {
                            c.addQualifierValue(new QualifierValue(MAX_CARDINALITY, Integer.toString(max)));
                        }
                        if (allSome != null) {
                            string = allSome.toString();
                            assert (string != null);
                            c.addQualifierValue(new QualifierValue("all_some", string));
                        }
                        if (allOnly != null) {
                            string = allOnly.toString();
                            assert (string != null);
                            c.addQualifierValue(new QualifierValue("all_only", string));
                        }
                        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
                        continue;
                    }
                    if (!f.getClauses(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF).isEmpty()) {
                        this.error("The axiom is not translated (maximimum one IntersectionOf EquivalenceAxiom)", (OWLAxiom)ax, false);
                        continue;
                    }
                    isUntranslateable = true;
                    this.error((OWLAxiom)ax, false);
                }
                break block27;
            }
            isUntranslateable = true;
            this.error((OWLAxiom)ax, false);
        }
        if (!isUntranslateable) {
            for (Clause c : equivalenceAxiomClauses) {
                f.addClause(c);
            }
        }
    }

    protected void tr(@Nonnull OWLDisjointClassesAxiom ax) {
        String cls2;
        Set set = ax.getClassExpressions();
        if (set.size() != 2) {
            this.error("Expected two classes in a disjoin classes axiom.", (OWLAxiom)ax, false);
        }
        Iterator it = set.iterator();
        OWLClassExpression ce1 = (OWLClassExpression)it.next();
        OWLClassExpression ce2 = (OWLClassExpression)it.next();
        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
            this.error("Disjoint classes axiom using Top or Bottom entities are not supported.", (OWLAxiom)ax, false);
        }
        if ((cls2 = this.getIdentifier((OWLObject)ce2)) == null) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        if (ce1.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLClass cls1 = ce1.asOWLClass();
        Frame f = this.getTermFrame(cls1);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        c.setValue(cls2);
        f.addClause(c);
        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
    }

    protected void tr(@Nonnull OWLDeclarationAxiom axiom) {
        OWLEntity entity = axiom.getEntity();
        if (entity.isBottomEntity() || entity.isTopEntity()) {
            return;
        }
        Set set = this.owlOntology.getAnnotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI());
        if (set.isEmpty()) {
            return;
        }
        boolean isClass = entity.isOWLClass();
        boolean isObjectProperty = entity.isOWLObjectProperty();
        Optional<OboAltIdCheckResult> altIdOptional = OWLAPIOwl2Obo.checkForOboAltId(set);
        if (altIdOptional.isPresent()) {
            String currentId = OWLAPIOwl2Obo.getIdentifier(entity.getIRI());
            this.addAltId(altIdOptional.get().replacedBy, currentId, isClass, isObjectProperty);
            this.untranslatableAxioms.addAll(altIdOptional.get().unrelated);
            return;
        }
        Frame f = null;
        if (isClass) {
            f = this.getTermFrame(entity.asOWLClass());
        } else if (isObjectProperty) {
            f = this.getTypedefFrame((OWLEntity)entity.asOWLObjectProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            for (OWLAxiom a : set) {
                OWLAnnotationAssertionAxiom ax = (OWLAnnotationAssertionAxiom)a;
                OWLAnnotationProperty prop = ax.getProperty();
                String tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
                if (!OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag().equals(tag)) continue;
                f = this.getTypedefFrame(entity);
                break;
            }
        }
        if (f != null) {
            for (OWLAxiom a : set) {
                assert (a != null);
                this.tr((OWLAnnotationAssertionAxiom)a, f);
            }
            this.add(f);
        }
    }

    private void addAltId(@Nonnull String replacedBy, @Nonnull String altId, boolean isClass, boolean isProperty) {
        Frame replacedByFrame = null;
        if (isClass) {
            replacedByFrame = this.getTermFrame(replacedBy);
        } else if (isProperty) {
            replacedByFrame = this.getTypedefFrame(replacedBy);
        }
        if (replacedByFrame != null) {
            boolean addClause = true;
            Collection<Clause> existing = replacedByFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_ALT_ID);
            for (Clause clause : existing) {
                if (!altId.equals(clause.getValue(String.class))) continue;
                addClause = false;
            }
            if (addClause) {
                replacedByFrame.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ALT_ID, altId));
            }
        }
    }

    @Nonnull
    private static Optional<OboAltIdCheckResult> checkForOboAltId(Set<OWLAnnotationAssertionAxiom> annotations) {
        String replacedBy = null;
        boolean isMerged = false;
        boolean isDeprecated = false;
        HashSet<OWLAnnotationAssertionAxiom> unrelatedAxioms = new HashSet<OWLAnnotationAssertionAxiom>();
        for (OWLAnnotationAssertionAxiom axiom : annotations) {
            OWLAnnotationValue value;
            OWLAnnotationProperty prop = axiom.getProperty();
            if (prop.isDeprecated()) {
                isDeprecated = true;
                continue;
            }
            if (Obo2OWLConstants.IRI_IAO_0000231.equals((Object)prop.getIRI())) {
                value = axiom.getValue();
                if (value.asIRI().isPresent()) {
                    isMerged = Obo2OWLConstants.IRI_IAO_0000227.equals(value.asIRI().get());
                    continue;
                }
                unrelatedAxioms.add(axiom);
                continue;
            }
            if (Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0100001.iri.equals((Object)prop.getIRI())) {
                value = axiom.getValue();
                if (value.asLiteral().isPresent()) {
                    replacedBy = ((OWLLiteral)value.asLiteral().get()).getLiteral();
                    continue;
                }
                if (value.asIRI().isPresent()) {
                    replacedBy = OWLAPIOwl2Obo.getIdentifier((IRI)value.asIRI().get());
                    continue;
                }
                unrelatedAxioms.add(axiom);
                continue;
            }
            unrelatedAxioms.add(axiom);
        }
        Optional<OboAltIdCheckResult> result = replacedBy != null && isMerged && isDeprecated ? Optional.of(new OboAltIdCheckResult(replacedBy, unrelatedAxioms)) : Optional.empty();
        return result;
    }

    @Nullable
    public String getIdentifier(OWLObject obj) {
        try {
            return OWLAPIOwl2Obo.getIdentifierFromObject(obj, this.getOWLOntology());
        }
        catch (UntranslatableAxiomException e) {
            this.error(e.getMessage(), true);
            return null;
        }
    }

    public boolean isMuteUntranslatableAxioms() {
        return this.muteUntranslatableAxioms;
    }

    public void setMuteUntranslatableAxioms(boolean muteUntranslatableAxioms) {
        this.muteUntranslatableAxioms = muteUntranslatableAxioms;
    }

    @Nonnull
    public static String getIdentifierFromObject(@Nonnull OWLObject obj, @Nonnull OWLOntology ont, @Nonnull String defaultValue) {
        String id = defaultValue;
        try {
            id = OWLAPIOwl2Obo.getIdentifierFromObject(obj, ont);
            if (id == null) {
                id = defaultValue;
            }
        }
        catch (UntranslatableAxiomException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return id;
    }

    @Nullable
    public static String getIdentifierFromObject(OWLObject obj, @Nonnull OWLOntology ont) throws UntranslatableAxiomException {
        if (obj instanceof OWLObjectProperty || obj instanceof OWLAnnotationProperty) {
            OWLEntity entity = (OWLEntity)obj;
            Set axioms = ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI());
            for (OWLAnnotationAssertionAxiom ax : axioms) {
                String propId = OWLAPIOwl2Obo.getIdentifierFromObject((OWLObject)ax.getProperty().getIRI(), ont);
                if (!propId.equals("shorthand")) continue;
                OWLAnnotationValue value = ax.getValue();
                if (value instanceof OWLLiteral) {
                    return ((OWLLiteral)value).getLiteral();
                }
                throw new UntranslatableAxiomException("Untranslatable axiom, expected literal value, but was: " + value + " in axiom: " + ax);
            }
        }
        if (obj instanceof OWLEntity) {
            return OWLAPIOwl2Obo.getIdentifier(((OWLEntity)obj).getIRI());
        }
        if (obj instanceof IRI) {
            return OWLAPIOwl2Obo.getIdentifier((IRI)obj);
        }
        return null;
    }

    @Nullable
    public static String getIdentifier(@Nullable IRI iriId) {
        if (iriId == null) {
            return null;
        }
        String iri = iriId.toString();
        int indexSlash = iri.lastIndexOf(47);
        String id = null;
        id = indexSlash > -1 ? iri.substring(indexSlash + 1) : iri;
        String[] s = id.split("#_");
        if (s.length > 1) {
            return s[0] + ':' + s[1];
        }
        s = id.split("#");
        if (s.length > 1) {
            String prefix = "";
            if ("owl".equals(s[0]) || "rdf".equals(s[0]) || "rdfs".equals(s[0])) {
                prefix = s[0] + ':';
            }
            return prefix + s[1];
        }
        s = id.split("_");
        if (s.length == 2 && !id.contains("#") && !s[1].contains("_")) {
            try {
                String localId = URLDecoder.decode(s[1], "UTF-8");
                return s[0] + ':' + localId;
            }
            catch (UnsupportedEncodingException e) {
                throw new OWLRuntimeException("UTF-8 not supported, JRE corrupted?", (Throwable)e);
            }
        }
        if (s.length > 2 && !id.contains("#") && s[s.length - 1].replaceAll("[0-9]", "").isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    if (i == s.length - 1) {
                        sb.append(':');
                    } else {
                        sb.append('_');
                    }
                }
                sb.append(s[i]);
            }
            return sb.toString();
        }
        return iri;
    }

    @Nullable
    public static String owlObjectToTag(OWLObject obj) {
        IRI iriObj = null;
        if (obj instanceof OWLNamedObject) {
            iriObj = ((OWLNamedObject)obj).getIRI();
        } else if (obj instanceof IRI) {
            iriObj = (IRI)obj;
        }
        if (iriObj == null) {
            return null;
        }
        String iri = iriObj.toString();
        String tag = ANNOTATIONPROPERTYMAP.get(iri);
        if (tag == null) {
            String prefix;
            if (iri.startsWith("http://purl.obolibrary.org/obo/IAO_")) {
                String legacyId = iri.replace("http://purl.obolibrary.org/obo/", "");
                if (legacyId.equals("IAO_xref")) {
                    return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
                }
                if (legacyId.equals("IAO_id")) {
                    return OBOFormatConstants.OboFormatTag.TAG_ID.getTag();
                }
                if (legacyId.equals("IAO_namespace")) {
                    return OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag();
                }
            }
            if (iri.startsWith(prefix = "http://www.geneontology.org/formats/oboInOwl#")) {
                tag = iri.substring(prefix.length());
            }
        }
        return tag;
    }

    protected Frame getTermFrame(@Nonnull OWLClass entity) {
        String id = OWLAPIOwl2Obo.getIdentifier(entity.getIRI());
        return this.getTermFrame(id);
    }

    private Frame getTermFrame(@Nonnull String id) {
        Frame f = this.getObodoc().getTermFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TERM);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected Frame getTypedefFrame(@Nonnull OWLEntity entity) {
        String id = this.getIdentifier((OWLObject)entity);
        return this.getTypedefFrame(id);
    }

    private Frame getTypedefFrame(@Nonnull String id) {
        Frame f = this.getObodoc().getTypedefFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TYPEDEF);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected void tr(@Nonnull OWLClassAssertionAxiom ax) {
        OWLClassExpression cls = ax.getClassExpression();
        if (!(cls instanceof OWLClass)) {
            return;
        }
        String clsIRI = ((OWLClass)cls).getIRI().toString();
        IRI labelPropertyIRI = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        if (IRI_CLASS_SYNONYMTYPEDEF.equals(clsIRI)) {
            Frame f = this.getObodoc().getHeaderFrame();
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag());
            OWLNamedIndividual indv = (OWLNamedIndividual)ax.getIndividual();
            String indvId = this.getIdentifier((OWLObject)indv);
            indvId = indvId.replaceFirst(".*:", "");
            c.addValue(indvId);
            c.addValue(indvId);
            String nameValue = "";
            String scopeValue = null;
            for (OWLAnnotation ann : EntitySearcher.getAnnotationObjects((OWLEntity)indv, (OWLOntology)this.getOWLOntology(), null)) {
                String value = ((OWLLiteral)ann.getValue()).getLiteral();
                if (ann.getProperty().getIRI().equals((Object)labelPropertyIRI)) {
                    nameValue = '\"' + value + '\"';
                    continue;
                }
                scopeValue = value;
            }
            c.addValue(nameValue);
            if (scopeValue != null) {
                c.addValue(scopeValue);
            }
            f.addClause(c);
        } else if (IRI_CLASS_SUBSETDEF.equals(clsIRI)) {
            Frame f = this.getObodoc().getHeaderFrame();
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag());
            OWLNamedIndividual indv = (OWLNamedIndividual)ax.getIndividual();
            String indvId = this.getIdentifier((OWLObject)indv);
            indvId = indvId.replaceFirst(".*:", "");
            c.addValue(indvId);
            String nameValue = "";
            for (OWLAnnotation ann : EntitySearcher.getAnnotationObjects((OWLEntity)indv, (OWLOntology)this.getOWLOntology(), null)) {
                String value = ((OWLLiteral)ann.getValue()).getLiteral();
                if (!ann.getProperty().getIRI().equals((Object)labelPropertyIRI)) continue;
                nameValue = '\"' + value + '\"';
            }
            c.addValue(nameValue);
            f.addClause(c);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void tr(@Nonnull OWLSubClassOfAxiom ax) {
        String fillerId;
        OWLClassExpression filler;
        void var2_4;
        Clause c;
        Set xs;
        OWLClassExpression oWLClassExpression = ax.getSubClass();
        OWLClassExpression sup = ax.getSuperClass();
        if (oWLClassExpression.isOWLNothing() || oWLClassExpression.isTopEntity() || sup.isTopEntity() || sup.isOWLNothing()) {
            this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
            return;
        }
        HashSet<QualifierValue> qvs = new HashSet<QualifierValue>();
        if (oWLClassExpression instanceof OWLObjectIntersectionOf && (xs = ((OWLObjectIntersectionOf)oWLClassExpression).getOperands()).size() == 2) {
            c = null;
            OWLObjectSomeValuesFrom r = null;
            OWLObjectProperty p = null;
            OWLClass filler2 = null;
            for (OWLClassExpression x : xs) {
                if (x instanceof OWLClass) {
                    c = (OWLClass)x;
                }
                if (!(x instanceof OWLObjectSomeValuesFrom) || !((r = (OWLObjectSomeValuesFrom)x).getProperty() instanceof OWLObjectProperty) || !(r.getFiller() instanceof OWLClass)) continue;
                p = (OWLObjectProperty)r.getProperty();
                filler2 = (OWLClass)r.getFiller();
            }
            if (c != null && p != null && filler2 != null) {
                Clause clause = c;
                qvs.add(new QualifierValue("gci_relation", this.getIdentifier((OWLObject)p)));
                qvs.add(new QualifierValue("gci_filler", this.getIdentifier((OWLObject)filler2)));
            }
        }
        if (!(var2_4 instanceof OWLClass)) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        Frame f = this.getTermFrame((OWLClass)var2_4);
        if (sup instanceof OWLClass) {
            c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
            c.setValue(this.getIdentifier((OWLObject)sup));
            c.setQualifierValues(qvs);
            f.addClause(c);
            OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
            return;
        }
        if (sup instanceof OWLObjectCardinalityRestriction) {
            OWLObjectCardinalityRestriction cardinality = (OWLObjectCardinalityRestriction)sup;
            filler = (OWLClassExpression)cardinality.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            f.addClause(this.createRelationshipClauseWithCardinality(cardinality, fillerId, qvs, ax));
            return;
        }
        if (sup instanceof OWLQuantifiedObjectRestriction) {
            OWLQuantifiedObjectRestriction r = (OWLQuantifiedObjectRestriction)sup;
            filler = (OWLClassExpression)r.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            if (r instanceof OWLObjectAllValuesFrom) {
                qvs.add(new QualifierValue("all_only", "true"));
            }
            f.addClause(this.createRelationshipClauseWithRestrictions(r, fillerId, qvs, ax));
            return;
        }
        if (!(sup instanceof OWLObjectIntersectionOf)) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        OWLObjectIntersectionOf i = (OWLObjectIntersectionOf)sup;
        List<Clause> clauses = new ArrayList<Clause>();
        for (OWLClassExpression operand : i.getOperands()) {
            String fillerId2;
            OWLClassExpression filler3;
            OWLObjectCardinalityRestriction restriction;
            if (operand instanceof OWLObjectCardinalityRestriction) {
                restriction = (OWLObjectCardinalityRestriction)operand;
                filler3 = (OWLClassExpression)restriction.getFiller();
                if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                    this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                    return;
                }
                fillerId2 = this.getIdentifier((OWLObject)filler3);
                if (fillerId2 == null) {
                    this.error((OWLAxiom)ax, true);
                    return;
                }
                clauses.add(this.createRelationshipClauseWithCardinality(restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
                continue;
            }
            if (!(operand instanceof OWLQuantifiedObjectRestriction)) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            restriction = (OWLQuantifiedObjectRestriction)operand;
            filler3 = (OWLClassExpression)restriction.getFiller();
            if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId2 = this.getIdentifier((OWLObject)filler3);
            if (fillerId2 == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            clauses.add(this.createRelationshipClauseWithRestrictions((OWLQuantifiedObjectRestriction)restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
        }
        if (clauses.isEmpty()) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        clauses = OWLAPIOwl2Obo.normalizeRelationshipClauses(clauses);
        Iterator<Object> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            f.addClause(clause);
        }
    }

    @Nonnull
    protected Clause createRelationshipClauseWithRestrictions(@Nonnull OWLQuantifiedObjectRestriction r, String fillerId, @Nonnull Set<QualifierValue> qvs, @Nonnull OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)r.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
        return c;
    }

    @Nonnull
    protected Clause createRelationshipClauseWithCardinality(@Nonnull OWLObjectCardinalityRestriction restriction, String fillerId, @Nonnull Set<QualifierValue> qvs, @Nonnull OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)restriction.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        String q = "cardinality";
        if (restriction instanceof OWLObjectMinCardinality) {
            q = MIN_CARDINALITY;
        } else if (restriction instanceof OWLObjectMaxCardinality) {
            q = MAX_CARDINALITY;
        }
        c.addQualifierValue(new QualifierValue(q, Integer.toString(restriction.getCardinality())));
        OWLAPIOwl2Obo.addQualifiers(c, ax.getAnnotations());
        return c;
    }

    @Nonnull
    public static List<Clause> normalizeRelationshipClauses(@Nonnull List<Clause> clauses) {
        ArrayList<Clause> normalized = new ArrayList<Clause>();
        while (!clauses.isEmpty()) {
            Clause target = clauses.remove(0);
            assert (target != null);
            List<Clause> similar = OWLAPIOwl2Obo.findSimilarClauses(clauses, target);
            normalized.add(target);
            OWLAPIOwl2Obo.mergeSimilarIntoTarget(target, similar);
        }
        return normalized;
    }

    @Nonnull
    static List<Clause> findSimilarClauses(@Nonnull List<Clause> clauses, @Nonnull Clause target) {
        String targetTag = target.getTag();
        Object targetValue = target.getValue();
        Object targetValue2 = target.getValue2();
        ArrayList<Clause> similar = new ArrayList<Clause>();
        Iterator<Clause> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            Clause current = iterator.next();
            Object currentValue = current.getValue();
            Object currentValue2 = current.getValue2();
            if (!targetTag.equals(current.getTag()) || !targetValue.equals(currentValue) || !Objects.equals(targetValue2, currentValue2)) continue;
            similar.add(current);
            iterator.remove();
        }
        return similar;
    }

    static void mergeSimilarIntoTarget(@Nonnull Clause target, @Nonnull List<Clause> similar) {
        if (similar.isEmpty()) {
            return;
        }
        Collection<QualifierValue> targetQVs = target.getQualifierValues();
        for (Clause current : similar) {
            Collection<QualifierValue> newQVs = current.getQualifierValues();
            for (QualifierValue newQV : newQVs) {
                String newQualifier = newQV.getQualifier();
                if (MIN_CARDINALITY.equals(newQualifier) || MAX_CARDINALITY.equals(newQualifier)) {
                    QualifierValue match = OWLAPIOwl2Obo.findMatchingQualifierValue(newQV, targetQVs);
                    if (match != null) {
                        OWLAPIOwl2Obo.mergeQualifierValues(match, newQV);
                        continue;
                    }
                    target.addQualifierValue(newQV);
                    continue;
                }
                target.addQualifierValue(newQV);
            }
        }
    }

    @Nullable
    static QualifierValue findMatchingQualifierValue(@Nonnull QualifierValue query, @Nonnull Collection<QualifierValue> list) {
        String queryQualifier = query.getQualifier();
        for (QualifierValue qv : list) {
            if (!queryQualifier.equals(qv.getQualifier())) continue;
            return qv;
        }
        return null;
    }

    static void mergeQualifierValues(@Nonnull QualifierValue target, @Nonnull QualifierValue newQV) {
        if (!target.getValue().equals(newQV.getValue())) {
            if (MIN_CARDINALITY.equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue().toString());
                int newValue = Integer.parseInt(newQV.getValue().toString());
                int mergedValue = Math.min(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            } else if (MAX_CARDINALITY.equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue().toString());
                int newValue = Integer.parseInt(newQV.getValue().toString());
                int mergedValue = Math.max(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            }
        }
    }

    protected void error(String message, OWLAxiom ax, boolean shouldLogComplaint) {
        this.untranslatableAxioms.add(ax);
        this.error(message + ax, shouldLogComplaint);
    }

    protected void error(OWLAxiom ax, boolean shouldLogComplaint) {
        this.untranslatableAxioms.add(ax);
        this.error("the axiom is not translated : " + ax, shouldLogComplaint);
    }

    protected void error(String message, boolean shouldLogComplaint) {
        if (this.strictConversion) {
            throw new OWLRuntimeException("The conversion is halted: " + message);
        }
        if (!this.muteUntranslatableAxioms && shouldLogComplaint) {
            LOG.error("MASKING ERROR \u00ab{}\u00bb", (Object)message, (Object)new Exception());
        }
    }

    protected void warn(String message) {
        if (this.strictConversion) {
            throw new OWLRuntimeException("The conversion is halted: " + message);
        }
        LOG.warn("MASKING ERROR \u00ab{}\u00bb", (Object)message);
    }

    public static class UntranslatableAxiomException
    extends Exception {
        private static final long serialVersionUID = 40000L;

        public UntranslatableAxiomException(String message, Throwable cause) {
            super(message, cause);
        }

        public UntranslatableAxiomException(String message) {
            super(message);
        }
    }

    private static class OboAltIdCheckResult {
        final String replacedBy;
        final Set<OWLAnnotationAssertionAxiom> unrelated;

        OboAltIdCheckResult(@Nonnull String replacedBy, @Nonnull Set<OWLAnnotationAssertionAxiom> unrelated) {
            this.replacedBy = replacedBy;
            this.unrelated = unrelated;
        }
    }
}

