/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.LabelFunctionalDocumentFormat;
import org.semanticweb.owlapi.functional.renderer.FunctionalSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.StringComparator;

public class LabelFunctionalSyntaxStorer
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;

    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalDocumentFormat;
    }

    protected void storeOntology(@Nonnull OWLOntology ontology, @Nonnull Writer writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            FunctionalSyntaxObjectRenderer renderer = new FunctionalSyntaxObjectRenderer(ontology, writer);
            renderer.setPrefixManager((PrefixManager)new LabelPrefixManager(ontology));
            ontology.accept((OWLObjectVisitor)renderer);
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }

    static class LabelPrefixManager
    implements PrefixManager {
        private static final long serialVersionUID = 40000L;
        @Nonnull
        private final OWLOntology ontology;
        @Nonnull
        private final PrefixManager delegate;

        LabelPrefixManager(@Nonnull OWLOntology ontology) {
            this.ontology = ontology;
            OWLDocumentFormat ontologyFormat = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
            this.delegate = ontologyFormat instanceof PrefixManager ? (PrefixManager)ontologyFormat : new DefaultPrefixManager();
        }

        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri)) {
                OWLAnnotationValue value;
                if (!annotation.getProperty().isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return String.valueOf('<') + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRI(iri);
        }

        public String getDefaultPrefix() {
            return this.delegate.getDefaultPrefix();
        }

        public boolean containsPrefixMapping(String prefixName) {
            return this.delegate.containsPrefixMapping(prefixName);
        }

        public String getPrefix(String prefixName) {
            return this.delegate.getPrefix(prefixName);
        }

        public Map<String, String> getPrefixName2PrefixMap() {
            return this.delegate.getPrefixName2PrefixMap();
        }

        public IRI getIRI(String prefixIRI) {
            return this.delegate.getIRI(prefixIRI);
        }

        public Set<String> getPrefixNames() {
            return this.delegate.getPrefixNames();
        }

        public StringComparator getPrefixComparator() {
            return this.delegate.getPrefixComparator();
        }

        public void setPrefixComparator(StringComparator comparator) {
            this.delegate.setPrefixComparator(comparator);
        }

        public void setDefaultPrefix(String defaultPrefix) {
        }

        public void setPrefix(String prefixName, String prefix) {
        }

        public void copyPrefixesFrom(PrefixManager from) {
        }

        public void copyPrefixesFrom(Map<String, String> from) {
        }

        public void unregisterNamespace(String namespace) {
        }

        public void clear() {
        }
    }
}

