/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManchesterSyntaxTool {
    private static final Logger LOG = LoggerFactory.getLogger(ManchesterSyntaxTool.class);
    @Nonnull
    protected final IRIShortFormProvider iriShortFormProvider = new SimpleIRIShortFormProvider();
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final AdvancedEntityChecker entityChecker;
    @Nonnull
    private final ShortFormProvider shortFormProvider = new ShortFormProvider(){

        public void dispose() {
        }

        public String getShortForm(@Nonnull OWLEntity entity) {
            return ManchesterSyntaxTool.this.iriShortFormProvider.getShortForm(entity.getIRI());
        }
    };
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public ManchesterSyntaxTool(@Nonnull OWLOntology inputOntology) {
        this(inputOntology, null);
    }

    public ManchesterSyntaxTool(@Nonnull OWLOntology inputOntology, @Nullable Collection<OWLOntology> auxiliaryOntologies) {
        OWLOntologyManager manager = inputOntology.getOWLOntologyManager();
        this.dataFactory = manager.getOWLDataFactory();
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>(inputOntology.getImportsClosure());
        if (auxiliaryOntologies != null && !auxiliaryOntologies.isEmpty()) {
            for (OWLOntology auxOnt : auxiliaryOntologies) {
                ontologies.addAll(auxOnt.getImportsClosure());
            }
        }
        ShortFormEntityChecker defaultInstance = new ShortFormEntityChecker((BidirectionalShortFormProvider)new BidirectionalShortFormProviderAdapter(manager, ontologies, this.shortFormProvider));
        this.entityChecker = new AdvancedEntityChecker((OWLEntityChecker)defaultInstance, ontologies, inputOntology.getOWLOntologyManager());
    }

    public Set<OntologyAxiomPair> parseManchesterExpressionFrames(@Nonnull String expression) {
        ManchesterOWLSyntaxParser parser = this.createParser(expression);
        return parser.parseFrames();
    }

    public OWLClassExpression parseManchesterExpression(@Nonnull String expression) {
        ManchesterOWLSyntaxParser parser = this.createParser(expression);
        return parser.parseClassExpression();
    }

    @Nonnull
    private ManchesterOWLSyntaxParser createParser(@Nonnull String expression) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl((Provider)new OWLAPIConfigProvider(), this.dataFactory);
        parser.setStringToParse(expression);
        parser.setOWLEntityChecker((OWLEntityChecker)this.entityChecker);
        LOG.info("parsing: {}", (Object)expression);
        return parser;
    }

    public String getId(@Nonnull IRI iri) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        return this.iriShortFormProvider.getShortForm(iri);
    }

    public String getId(@Nonnull OWLEntity entity) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        return this.shortFormProvider.getShortForm(entity);
    }

    public void dispose() {
        if (!this.disposed.getAndSet(true)) {
            this.shortFormProvider.dispose();
        }
    }

    static class AdvancedEntityChecker
    implements OWLEntityChecker {
        private final OWLEntityChecker defaultInstance;
        private final Set<OWLOntology> ontologies;
        private final OWLOntologyManager manager;

        AdvancedEntityChecker(OWLEntityChecker defaultInstance, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
            this.defaultInstance = defaultInstance;
            this.ontologies = ontologies;
            this.manager = manager;
        }

        @Nullable
        public OWLClass getOWLClass(@Nonnull String name) {
            IRI iri;
            OWLClass owlClass = this.defaultInstance.getOWLClass(name);
            if (owlClass == null && (iri = this.getIRI(name)) != null) {
                owlClass = this.getOWLClass(iri);
            }
            return owlClass;
        }

        @Nullable
        public OWLObjectProperty getOWLObjectProperty(@Nonnull String name) {
            IRI iri;
            OWLObjectProperty owlObjectProperty = this.defaultInstance.getOWLObjectProperty(name);
            if (owlObjectProperty == null && (iri = this.getIRI(name)) != null) {
                owlObjectProperty = this.getOWLObjectProperty(iri);
            }
            return owlObjectProperty;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            return this.defaultInstance.getOWLDataProperty(name);
        }

        @Nullable
        public OWLNamedIndividual getOWLIndividual(@Nonnull String name) {
            IRI iri;
            OWLNamedIndividual owlIndividual = this.defaultInstance.getOWLIndividual(name);
            if (owlIndividual == null && (iri = this.getIRI(name)) != null) {
                owlIndividual = this.getOWLIndividual(iri);
            }
            return owlIndividual;
        }

        public OWLDatatype getOWLDatatype(String name) {
            return this.defaultInstance.getOWLDatatype(name);
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            return this.defaultInstance.getOWLAnnotationProperty(name);
        }

        @Nullable
        IRI getIRI(@Nonnull String name) {
            if (AdvancedEntityChecker.isQuoted(name)) {
                return this.getIRIByLabel(name.substring(1, name.length() - 1));
            }
            if (name.length() > 2 && name.charAt(0) == '<' && name.charAt(name.length() - 1) == '>') {
                return IRI.create((String)name.substring(1, name.length() - 1));
            }
            return this.getIRIByIdentifier(name);
        }

        private static boolean isQuoted(@Nonnull String s) {
            int length = s.length();
            if (length >= 2) {
                return s.charAt(0) == '\'' && s.charAt(length - 1) == '\'';
            }
            return false;
        }

        @Nullable
        IRI getIRIByIdentifier(@Nonnull String id) {
            OWLAPIObo2Owl b = new OWLAPIObo2Owl(this.manager);
            b.setObodoc(new OBODoc());
            return b.oboIdToIRI(id);
        }

        @Nullable
        IRI getIRIByLabel(@Nonnull String label) {
            for (OWLOntology o : this.ontologies) {
                Set aas = o.getAxioms(AxiomType.ANNOTATION_ASSERTION);
                for (OWLAnnotationAssertionAxiom aa : aas) {
                    OWLAnnotationSubject obj;
                    OWLAnnotationProperty property;
                    OWLAnnotationValue v = aa.getValue();
                    if (!this.isMatchingLabel(label, v, property = aa.getProperty()) || !((obj = aa.getSubject()) instanceof IRI)) continue;
                    return (IRI)obj;
                }
            }
            return null;
        }

        protected boolean isMatchingLabel(String label, OWLAnnotationValue v, OWLAnnotationProperty property) {
            return property.isLabel() && v instanceof OWLLiteral && label.equals(((OWLLiteral)v).getLiteral());
        }

        @Nullable
        OWLClass getOWLClass(@Nonnull IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLClass c;
                if (!o.getDeclarationAxioms((OWLEntity)(c = o.getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri))).isEmpty()) {
                    return c;
                }
                if (!o.getOWLOntologyManager().getOWLDataFactory().getOWLNothing().equals(c)) continue;
                return c;
            }
            return null;
        }

        @Nullable
        OWLNamedIndividual getOWLIndividual(@Nonnull IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLNamedIndividual c = o.getOWLOntologyManager().getOWLDataFactory().getOWLNamedIndividual(iri);
                for (OWLDeclarationAxiom da : o.getDeclarationAxioms((OWLEntity)c)) {
                    if (!(da.getEntity() instanceof OWLNamedIndividual)) continue;
                    return (OWLNamedIndividual)da.getEntity();
                }
            }
            return null;
        }

        @Nullable
        OWLObjectProperty getOWLObjectProperty(@Nonnull IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLObjectProperty p;
                if (o.getDeclarationAxioms((OWLEntity)(p = o.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(iri))).isEmpty()) continue;
                return p;
            }
            return null;
        }
    }
}

