/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.obolibrary.oboformat.diff.Diff;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class OBODocDiffer {
    public static List<Diff> getDiffs(OBODoc doc1, OBODoc doc2) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        diffs.addAll(OBODocDiffer.getDiffs("Header", doc1.getHeaderFrame(), doc2.getHeaderFrame()));
        diffs.addAll(OBODocDiffer.getDiffs("Term", doc1.getTermFrames(), doc2.getTermFrames()));
        diffs.addAll(OBODocDiffer.getDiffs("Typedef", doc1.getTypedefFrames(), doc2.getTypedefFrames()));
        diffs.addAll(OBODocDiffer.getDiffs("Instance", doc1.getInstanceFrames(), doc2.getInstanceFrames()));
        return diffs;
    }

    private static List<Diff> getDiffsAsym(String ftype, Collection<Frame> fl1, Collection<Frame> fl2, int n, boolean isCheckFrame) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        HashMap<String, Frame> fm2 = new HashMap<String, Frame>();
        for (Frame f : fl2) {
            fm2.put(f.getId(), f);
        }
        for (Frame f1 : fl1) {
            if (fm2.containsKey(f1.getId())) {
                Frame f2 = (Frame)fm2.get(f1.getId());
                if (!isCheckFrame) continue;
                diffs.addAll(OBODocDiffer.getDiffs(ftype, f1, f2));
                continue;
            }
            diffs.add(new Diff(ftype, "cannot find frame", f1, n));
        }
        return diffs;
    }

    private static List<Diff> getDiffs(String ftype, Collection<Frame> fl1, Collection<Frame> fl2) {
        List<Diff> diffs = OBODocDiffer.getDiffsAsym(ftype, fl1, fl2, 1, true);
        diffs.addAll(OBODocDiffer.getDiffsAsym(ftype, fl1, fl2, 2, false));
        return diffs;
    }

    private static List<Diff> getDiffsAsym(String ftype, Frame f1, Frame f2, int n) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        for (Clause c : f1.getClauses()) {
            boolean isMatched = false;
            for (Clause c2 : f2.getClauses()) {
                if (!c.getTag().equals(c2.getTag()) || !c.equals(c2)) continue;
                isMatched = true;
                if (!OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(c.getTag())) break;
                String a1 = c.getValue(Xref.class).getAnnotation();
                String a2 = c2.getValue(Xref.class).getAnnotation();
                isMatched = a1 == null && a2 == null || a1 != null && a1.equals(a2);
                break;
            }
            if (isMatched) continue;
            diffs.add(new Diff(ftype, "cannot_match_clause", f1, f2, c, n));
        }
        return diffs;
    }

    private static List<Diff> getDiffs(String ftype, Frame f1, Frame f2) {
        List<Diff> diffs = OBODocDiffer.getDiffsAsym(ftype, f1, f2, 1);
        diffs.addAll(OBODocDiffer.getDiffsAsym(ftype, f2, f1, 2));
        return diffs;
    }
}

