/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.OWLAPIOwl2Obo;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;

public final class OboInOwlCardinalityTools {
    protected static final Logger LOGGER = Logger.getLogger(OboInOwlCardinalityTools.class.getName());
    public static final AnnotationCardinalityConfictHandler DEFAULT_HANDLER = new AnnotationCardinalityConfictHandler(){

        @Override
        public List<OWLAnnotationAssertionAxiom> handleConflict(OWLEntity entity, OWLAnnotationProperty property, Collection<OWLAnnotationAssertionAxiom> axioms) throws AnnotationCardinalityException {
            if (axioms.size() > 1) {
                String tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)property);
                if (tag == null) {
                    tag = property.getIRI().toString();
                }
                LOGGER.log(Level.INFO, "Fixing multiple {} tags for entity: {}" + tag + entity.getIRI());
                return OboInOwlCardinalityTools.listOfFirst(axioms);
            }
            throw new AnnotationCardinalityException("Could not resolve conflict for property: " + property);
        }

        @Override
        public List<OWLAnnotation> handleConflict(OWLAnnotationProperty property, Collection<OWLAnnotation> ontologyAnnotations) throws AnnotationCardinalityException {
            if (ontologyAnnotations.size() > 1) {
                String tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)property);
                if (tag == null) {
                    tag = property.getIRI().toString();
                }
                LOGGER.log(Level.INFO, "Fixing multiple ontolgy annotations with, tag: {}", tag);
                return OboInOwlCardinalityTools.listOfFirst(ontologyAnnotations);
            }
            throw new AnnotationCardinalityException("Could not resolve conflict for property: " + property);
        }
    };

    private OboInOwlCardinalityTools() {
    }

    public static void checkAnnotationCardinality(OWLOntology ontology, AnnotationCardinalityReporter reporter, AnnotationCardinalityConfictHandler handler) throws AnnotationCardinalityException {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        Set<OWLAnnotationProperty> headerProperties = OboInOwlCardinalityTools.getProperties(factory, OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION, OBOFormatConstants.OboFormatTag.TAG_DATE, OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_SAVED_BY, OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY);
        OboInOwlCardinalityTools.checkOntologyAnnotations(headerProperties, ontology, reporter, handler, manager);
        Set<OWLAnnotationProperty> properties = OboInOwlCardinalityTools.getProperties(factory, OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS, OBOFormatConstants.OboFormatTag.TAG_NAME, OBOFormatConstants.OboFormatTag.TAG_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_DEF, OBOFormatConstants.OboFormatTag.TAG_COMMENT, OBOFormatConstants.OboFormatTag.TAG_DOMAIN, OBOFormatConstants.OboFormatTag.TAG_RANGE, OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE, OBOFormatConstants.OboFormatTag.TAG_CREATED_BY, OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE);
        for (OWLClass owlClass : ontology.getClassesInSignature(true)) {
            assert (owlClass != null);
            OboInOwlCardinalityTools.checkOwlEntity((OWLEntity)owlClass, properties, ontology, reporter, handler, manager);
        }
        for (OWLObjectProperty owlProperty : ontology.getObjectPropertiesInSignature(true)) {
            assert (owlProperty != null);
            OboInOwlCardinalityTools.checkOwlEntity((OWLEntity)owlProperty, properties, ontology, reporter, handler, manager);
        }
    }

    private static Set<OWLAnnotationProperty> getProperties(OWLDataFactory factory, OBOFormatConstants.OboFormatTag ... tags) {
        HashSet<OWLAnnotationProperty> set = new HashSet<OWLAnnotationProperty>();
        for (OBOFormatConstants.OboFormatTag tag : tags) {
            IRI iri = OWLAPIObo2Owl.trTagToIRI(tag.getTag());
            OWLAnnotationProperty property = factory.getOWLAnnotationProperty(iri);
            set.add(property);
        }
        return set;
    }

    private static void checkOntologyAnnotations(Set<OWLAnnotationProperty> properties, OWLOntology ontology, AnnotationCardinalityReporter reporter, AnnotationCardinalityConfictHandler handler, OWLOntologyManager manager) throws AnnotationCardinalityException {
        Set annotations = ontology.getAnnotations();
        HashMap<OWLAnnotationProperty, Set<OWLAnnotation>> groupedAnnotations = new HashMap<OWLAnnotationProperty, Set<OWLAnnotation>>();
        for (OWLAnnotation annotation : annotations) {
            OWLAnnotationProperty current = annotation.getProperty();
            if (!properties.contains(current)) continue;
            HashSet<OWLAnnotation> set = (HashSet<OWLAnnotation>)groupedAnnotations.get(current);
            if (set == null) {
                groupedAnnotations.put(current, Collections.singleton(annotation));
                continue;
            }
            if (set.size() == 1) {
                set = new HashSet<OWLAnnotation>(set);
                set.add(annotation);
                groupedAnnotations.put(current, set);
                continue;
            }
            set.add(annotation);
        }
        for (OWLAnnotationProperty property : groupedAnnotations.keySet()) {
            assert (property != null);
            Set group = (Set)groupedAnnotations.get(property);
            if (group.size() <= 1) continue;
            if (reporter != null) {
                reporter.reportConflict(property, group);
            }
            if (handler == null) continue;
            List<OWLAnnotation> changed = handler.handleConflict(property, group);
            for (OWLAnnotation annotation : group) {
                assert (annotation != null);
                manager.applyChange((OWLOntologyChange)new RemoveOntologyAnnotation(ontology, annotation));
            }
            for (OWLAnnotation annotation : changed) {
                assert (annotation != null);
                manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(ontology, annotation));
            }
        }
    }

    private static void checkOwlEntity(OWLEntity owlClass, Set<OWLAnnotationProperty> properties, OWLOntology ontology, AnnotationCardinalityReporter reporter, AnnotationCardinalityConfictHandler handler, OWLOntologyManager manager) throws AnnotationCardinalityException {
        Set axioms = ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)owlClass.getIRI());
        HashMap<OWLAnnotationProperty, Set<OWLAnnotationAssertionAxiom>> groupedAxioms = new HashMap<OWLAnnotationProperty, Set<OWLAnnotationAssertionAxiom>>();
        for (OWLAnnotationAssertionAxiom axiom : axioms) {
            OWLAnnotationProperty current = axiom.getProperty();
            if (!properties.contains(current)) continue;
            HashSet<OWLAnnotationAssertionAxiom> set = (HashSet<OWLAnnotationAssertionAxiom>)groupedAxioms.get(current);
            if (set == null) {
                groupedAxioms.put(current, Collections.singleton(axiom));
                continue;
            }
            if (set.size() == 1) {
                set = new HashSet<OWLAnnotationAssertionAxiom>(set);
                set.add(axiom);
                groupedAxioms.put(current, set);
                continue;
            }
            set.add(axiom);
        }
        for (OWLAnnotationProperty property : groupedAxioms.keySet()) {
            assert (property != null);
            Set group = (Set)groupedAxioms.get(property);
            if (group.size() <= 1) continue;
            if (reporter != null) {
                reporter.reportConflict(owlClass, property, group);
            }
            if (handler == null) continue;
            List<OWLAnnotationAssertionAxiom> changed = handler.handleConflict(owlClass, property, group);
            for (OWLAnnotationAssertionAxiom axiom : group) {
                assert (axiom != null);
                manager.removeAxiom(ontology, (OWLAxiom)axiom);
            }
            for (OWLAnnotationAssertionAxiom axiom : changed) {
                assert (axiom != null);
                manager.addAxiom(ontology, (OWLAxiom)axiom);
            }
        }
    }

    public static void checkAnnotationCardinality(OWLOntology ontology) throws AnnotationCardinalityException {
        OboInOwlCardinalityTools.checkAnnotationCardinality(ontology, null, DEFAULT_HANDLER);
    }

    public static void checkAnnotationCardinality(OWLOntology ontology, AnnotationCardinalityReporter reporter) {
        try {
            OboInOwlCardinalityTools.checkAnnotationCardinality(ontology, reporter, null);
        }
        catch (AnnotationCardinalityException e) {
            LOGGER.log(Level.SEVERE, "Cardinality exception during report: This isn't supposed to happen.", e);
        }
    }

    static <T> List<T> listOfFirst(Collection<T> t) {
        return Collections.singletonList(t.iterator().next());
    }

    public static class AnnotationCardinalityException
    extends Exception {
        private static final long serialVersionUID = 40000L;

        public AnnotationCardinalityException(String message, Throwable cause) {
            super(message, cause);
        }

        public AnnotationCardinalityException(String message) {
            super(message);
        }
    }

    public static interface AnnotationCardinalityReporter {
        public void reportConflict(OWLEntity var1, OWLAnnotationProperty var2, Collection<OWLAnnotationAssertionAxiom> var3);

        public void reportConflict(OWLAnnotationProperty var1, Collection<OWLAnnotation> var2);
    }

    public static interface AnnotationCardinalityConfictHandler {
        public List<OWLAnnotationAssertionAxiom> handleConflict(OWLEntity var1, OWLAnnotationProperty var2, Collection<OWLAnnotationAssertionAxiom> var3) throws AnnotationCardinalityException;

        public List<OWLAnnotation> handleConflict(OWLAnnotationProperty var1, Collection<OWLAnnotation> var2) throws AnnotationCardinalityException;
    }
}

