/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class MacroExpansionVisitor {
    protected static final Logger LOG = Logger.getLogger(MacroExpansionVisitor.class.getName());
    private final OWLOntology inputOntology;
    private final OWLOntologyManager manager;
    private final Visitor visitor;
    protected ManchesterSyntaxTool manchesterSyntaxTool;
    protected boolean shouldTransferAnnotations = false;
    private final boolean shouldAddExpansionMarker;
    protected Set<OWLAnnotation> extraAnnotations;

    public MacroExpansionVisitor(OWLOntology ontology) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, false, false);
    }

    public MacroExpansionVisitor(OWLOntology ontology, boolean shouldAddExpansionMarker) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, false, shouldAddExpansionMarker);
    }

    public MacroExpansionVisitor(OWLOntology ontology, boolean shouldTransferAnnotations, boolean shouldAddExpansionMarker) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, shouldTransferAnnotations, shouldAddExpansionMarker);
    }

    public MacroExpansionVisitor(OWLOntology inputOntology, Set<OWLAnnotation> extraAnnotations, boolean shouldTransferAnnotations, boolean shouldAddExpansionMarker) {
        this.inputOntology = inputOntology;
        this.extraAnnotations = extraAnnotations;
        this.shouldTransferAnnotations = shouldTransferAnnotations;
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
        this.visitor = new Visitor(inputOntology, shouldAddExpansionMarker);
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.manager = inputOntology.getOWLOntologyManager();
    }

    public MacroExpansions getMacroExpansions() {
        return new MacroExpansions();
    }

    public OWLOntology expandAll() {
        MacroExpansions macroExpansions = new MacroExpansions();
        Set<OWLAxiom> newAxioms = macroExpansions.getNewAxioms();
        Set<OWLAxiom> rmAxioms = macroExpansions.getRmAxioms();
        this.manager.addAxioms(this.inputOntology, newAxioms);
        this.manager.removeAxioms(this.inputOntology, rmAxioms);
        return this.inputOntology;
    }

    public boolean shouldTransferAnnotations() {
        return this.shouldTransferAnnotations;
    }

    public void setShouldTransferAnnotations(boolean shouldTransferAnnotations) {
        this.shouldTransferAnnotations = shouldTransferAnnotations;
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class Visitor
    extends AbstractMacroExpansionVisitor {
        Visitor(OWLOntology inputOntology, boolean shouldAddExpansionMarker) {
            super(inputOntology, shouldAddExpansionMarker);
        }

        @Override
        protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
            return this.expandObject(filler, p);
        }

        @Override
        protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
            OWLClassExpression result = this.expandObject(filler, p);
            if (result != null) {
                result = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), result);
            }
            return result;
        }

        OWLClassExpression expandObject(Object filler, OWLObjectPropertyExpression p) {
            OWLClassExpression result = null;
            IRI iri = ((OWLObjectProperty)p).getIRI();
            IRI templateVal = null;
            if (this.expandExpressionMap.containsKey(iri)) {
                OWLIndividual ind;
                Set inds;
                if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1 && (ind = (OWLIndividual)inds.iterator().next()) instanceof OWLNamedIndividual) {
                    templateVal = ((OWLNamedObject)ind).getIRI();
                }
                if (filler instanceof OWLNamedObject) {
                    templateVal = ((OWLNamedObject)filler).getIRI();
                }
                if (templateVal != null) {
                    String tStr = (String)this.expandExpressionMap.get(iri);
                    String exStr = tStr.replaceAll("\\?Y", MacroExpansionVisitor.this.manchesterSyntaxTool.getId(templateVal));
                    try {
                        result = MacroExpansionVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                    }
                    catch (ParserException e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            return result;
        }
    }

    private class MacroExpansions {
        private Set<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        private Set<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();

        public MacroExpansions() {
            OWLAxiom newAxiom;
            for (OWLSubClassOfAxiom axiom : MacroExpansionVisitor.this.inputOntology.getAxioms(AxiomType.SUBCLASS_OF)) {
                newAxiom = MacroExpansionVisitor.this.visitor.visit(axiom);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            }
            for (OWLSubClassOfAxiom axiom : MacroExpansionVisitor.this.inputOntology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                newAxiom = MacroExpansionVisitor.this.visitor.visit((OWLEquivalentClassesAxiom)axiom);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            }
            for (OWLSubClassOfAxiom axiom : MacroExpansionVisitor.this.inputOntology.getAxioms(AxiomType.CLASS_ASSERTION)) {
                newAxiom = MacroExpansionVisitor.this.visitor.visit((OWLClassAssertionAxiom)axiom);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            }
            for (OWLSubClassOfAxiom axiom : MacroExpansionVisitor.this.inputOntology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                if (!this.expand((OWLAnnotationAssertionAxiom)axiom)) continue;
                this.rmAxioms.add((OWLAxiom)axiom);
            }
        }

        private void replaceIfDifferent(OWLAxiom ax, OWLAxiom exAx) {
            if (!ax.equals(exAx)) {
                this.newAxioms.add(exAx);
                this.rmAxioms.add(ax);
            }
        }

        public Set<OWLAxiom> getNewAxioms() {
            return this.newAxioms;
        }

        public Set<OWLAxiom> getRmAxioms() {
            return this.rmAxioms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean expand(OWLAnnotationAssertionAxiom axiom) {
            boolean expandedSomething;
            block10: {
                OWLAnnotationProperty prop = axiom.getProperty();
                String expandTo = (String)((MacroExpansionVisitor)MacroExpansionVisitor.this).visitor.expandAssertionToMap.get(prop.getIRI());
                HashSet<OWLDeclarationAxiom> declarations = new HashSet<OWLDeclarationAxiom>();
                expandedSomething = false;
                try {
                    if (expandTo == null) break block10;
                    HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(MacroExpansionVisitor.this.extraAnnotations);
                    if (MacroExpansionVisitor.this.shouldAddExpansionMarker) {
                        annotations.add(MacroExpansionVisitor.this.visitor.getExpansionMarkerAnnotation());
                    }
                    if (MacroExpansionVisitor.this.shouldTransferAnnotations()) {
                        annotations.addAll(axiom.getAnnotations());
                    }
                    IRI axValIRI = (IRI)axiom.getValue();
                    OWLDataFactory dataFactory = ((MacroExpansionVisitor)MacroExpansionVisitor.this).visitor.dataFactory;
                    OWLClass axValClass = dataFactory.getOWLClass(axValIRI);
                    if (MacroExpansionVisitor.this.inputOntology.getDeclarationAxioms((OWLEntity)axValClass).isEmpty()) {
                        OWLDeclarationAxiom declarationAxiom = dataFactory.getOWLDeclarationAxiom((OWLEntity)axValClass, annotations);
                        declarations.add(declarationAxiom);
                        this.newAxioms.add((OWLAxiom)declarationAxiom);
                        MacroExpansionVisitor.this.manager.addAxiom(MacroExpansionVisitor.this.inputOntology, (OWLAxiom)declarationAxiom);
                        MacroExpansionVisitor.this.manchesterSyntaxTool = new ManchesterSyntaxTool(MacroExpansionVisitor.this.inputOntology);
                    }
                    LOG.log(Level.INFO, "Template to Expand {}", expandTo);
                    expandTo = expandTo.replaceAll("\\?X", MacroExpansionVisitor.this.manchesterSyntaxTool.getId((IRI)axiom.getSubject()));
                    expandTo = expandTo.replaceAll("\\?Y", MacroExpansionVisitor.this.manchesterSyntaxTool.getId(axValIRI));
                    LOG.log(Level.INFO, "Expanding {}", expandTo);
                    try {
                        Set<OntologyAxiomPair> setAxp = MacroExpansionVisitor.this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                        for (OntologyAxiomPair axp : setAxp) {
                            OWLAxiom expandedAxiom = axp.getAxiom();
                            if (MacroExpansionVisitor.this.shouldTransferAnnotations()) {
                                expandedAxiom = expandedAxiom.getAnnotatedAxiom(annotations);
                            }
                            this.newAxioms.add(expandedAxiom);
                            expandedSomething = true;
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                finally {
                    MacroExpansionVisitor.this.manager.removeAxioms(MacroExpansionVisitor.this.inputOntology, declarations);
                }
            }
            return expandedSomething;
        }
    }
}

