/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public abstract class AbstractMacroExpansionVisitor
implements OWLClassExpressionVisitorEx<OWLClassExpression>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    static final Logger LOG = Logger.getLogger(AbstractMacroExpansionVisitor.class.getName());
    public static final Set<OWLAnnotation> EMPTY_ANNOTATIONS = Collections.emptySet();
    final OWLDataFactory dataFactory;
    final Map<IRI, String> expandAssertionToMap;
    final Map<IRI, String> expandExpressionMap;
    protected final OWLAnnotationProperty OIO_ISEXPANSION;
    protected final OWLAnnotation expansionMarkerAnnotation;
    private boolean shouldAddExpansionMarker = false;

    public OWLAnnotationProperty getOIO_ISEXPANSION() {
        return this.OIO_ISEXPANSION;
    }

    public OWLAnnotation getExpansionMarkerAnnotation() {
        return this.expansionMarkerAnnotation;
    }

    protected AbstractMacroExpansionVisitor(OWLOntology ontology, boolean shouldAddExpansionMarker) {
        this(ontology);
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
    }

    protected AbstractMacroExpansionVisitor(OWLOntology inputOntology) {
        String str;
        OWLAnnotationValue v;
        this.dataFactory = inputOntology.getOWLOntologyManager().getOWLDataFactory();
        this.expandExpressionMap = new HashMap<IRI, String>();
        this.expandAssertionToMap = new HashMap<IRI, String>();
        OWLAnnotationProperty expandExpressionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000424.getIRI());
        OWLAnnotationProperty expandAssertionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000425.getIRI());
        this.OIO_ISEXPANSION = this.dataFactory.getOWLAnnotationProperty(IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#", (String)"is_expansion"));
        this.expansionMarkerAnnotation = this.dataFactory.getOWLAnnotation(this.OIO_ISEXPANSION, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(true));
        for (OWLObjectProperty p : inputOntology.getObjectPropertiesInSignature()) {
            for (OWLOntology o : inputOntology.getImportsClosure()) {
                for (OWLAnnotation a : p.getAnnotations(o, expandExpressionAP)) {
                    v = a.getValue();
                    if (!(v instanceof OWLLiteral)) continue;
                    str = ((OWLLiteral)v).getLiteral();
                    LOG.log(Level.INFO, "mapping {} to {}" + p + str);
                    this.expandExpressionMap.put(p.getIRI(), str);
                }
            }
        }
        for (OWLObjectProperty p : inputOntology.getAnnotationPropertiesInSignature()) {
            for (OWLOntology o : inputOntology.getImportsClosure()) {
                for (OWLAnnotation a : p.getAnnotations(o, expandAssertionAP)) {
                    v = a.getValue();
                    if (!(v instanceof OWLLiteral)) continue;
                    str = ((OWLLiteral)v).getLiteral();
                    LOG.log(Level.INFO, "assertion mapping {} to {}" + p + str);
                    this.expandAssertionToMap.put(p.getIRI(), str);
                }
            }
        }
    }

    public OWLClassExpression visit(OWLObjectIntersectionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLClassExpression visit(OWLObjectUnionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLClassExpression visit(OWLObjectComplementOf ce) {
        return this.dataFactory.getOWLObjectComplementOf((OWLClassExpression)ce.getOperand().accept((OWLClassExpressionVisitorEx)this));
    }

    public OWLClassExpression visit(OWLObjectSomeValuesFrom ce) {
        OWLClassExpression filler = (OWLClassExpression)ce.getFiller();
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)ce.getProperty();
        OWLClassExpression result = null;
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjSomeVal(filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), (OWLClassExpression)filler.accept((OWLClassExpressionVisitorEx)this));
        }
        return result;
    }

    protected abstract OWLClassExpression expandOWLObjSomeVal(OWLClassExpression var1, OWLObjectPropertyExpression var2);

    public OWLClassExpression visit(OWLObjectHasValue ce) {
        OWLClassExpression result = null;
        OWLIndividual filler = (OWLIndividual)ce.getFiller();
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)ce.getProperty();
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjHasVal(ce, filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)ce.getProperty(), filler);
        }
        return result;
    }

    protected abstract OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue var1, OWLIndividual var2, OWLObjectPropertyExpression var3);

    public OWLClassExpression visit(OWLObjectAllValuesFrom ce) {
        return (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(OWLObjectMinCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMinCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)ce.getProperty(), filler);
    }

    public OWLClassExpression visit(OWLObjectExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(OWLObjectMaxCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)ce.getProperty(), filler);
    }

    public OWLClassExpression visit(OWLDataSomeValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
    }

    public OWLClassExpression visit(OWLDataAllValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
    }

    public OWLClassExpression visit(OWLDataHasValue ce) {
        return (OWLClassExpression)ce.asSomeValuesFrom().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(OWLDataExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(OWLDataMaxCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
    }

    public OWLClassExpression visit(OWLDataMinCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
    }

    public OWLDataRange visit(OWLDataOneOf node) {
        HashSet<OWLDataOneOf> oneOfs = new HashSet<OWLDataOneOf>();
        for (OWLLiteral lit : node.getValues()) {
            oneOfs.add(this.dataFactory.getOWLDataOneOf(new OWLLiteral[]{lit}));
        }
        return (OWLDataRange)this.dataFactory.getOWLDataUnionOf(oneOfs).accept((OWLDataVisitorEx)this);
    }

    public OWLDataRange visit(OWLDataIntersectionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataIntersectionOf(ops);
    }

    public OWLDataRange visit(OWLDataUnionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataUnionOf(ops);
    }

    public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression newSubclass = (OWLClassExpression)subClass.accept((OWLClassExpressionVisitorEx)this);
        OWLClassExpression superClass = axiom.getSuperClass();
        OWLClassExpression newSuperclass = (OWLClassExpression)superClass.accept((OWLClassExpressionVisitorEx)this);
        if (subClass.equals(newSubclass) && superClass.equals(newSuperclass)) {
            return axiom;
        }
        return this.dataFactory.getOWLSubClassOfAxiom(newSubclass, newSuperclass, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public Set<OWLAnnotation> getAnnotationsWithOptionalExpansionMarker(OWLAxiom axiom) {
        if (this.shouldAddExpansionMarker) {
            HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(axiom.getAnnotations());
            annotations.add(this.expansionMarkerAnnotation);
            return annotations;
        }
        return axiom.getAnnotations();
    }

    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            OWLClassExpression newOp = (OWLClassExpression)op.accept((OWLClassExpressionVisitorEx)this);
            ops.add(newOp);
            if (op.equals(newOp)) continue;
            sawChange = true;
        }
        if (sawChange) {
            return this.dataFactory.getOWLDisjointClassesAxiom(ops, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        HashSet<OWLClassExpression> newOps = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            OWLClassExpression newOp = (OWLClassExpression)op.accept((OWLClassExpressionVisitorEx)this);
            newOps.add(newOp);
            if (op.equals(newOp)) continue;
            sawChange = true;
        }
        if (!sawChange) {
            return axiom;
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), newOps, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression newRange;
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        if (range.equals(newRange = (OWLClassExpression)range.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        OWLDataRange newRange;
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        if (range.equals(newRange = (OWLDataRange)range.accept((OWLDataVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        OWLClassExpression newClassExpression;
        OWLClassExpression classExpression = axiom.getClassExpression();
        if (classExpression.isAnonymous() && !classExpression.equals(newClassExpression = (OWLClassExpression)classExpression.accept((OWLClassExpressionVisitorEx)this))) {
            return this.dataFactory.getOWLClassAssertionAxiom(newClassExpression, axiom.getIndividual(), this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> newExpressions = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression expression : axiom.getClassExpressions()) {
            OWLClassExpression newExpression = (OWLClassExpression)expression.accept((OWLClassExpressionVisitorEx)this);
            newExpressions.add(newExpression);
            if (expression.equals(newExpression)) continue;
            sawChange = true;
        }
        if (sawChange) {
            return this.dataFactory.getOWLEquivalentClassesAxiom(newExpressions, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLClassExpression visit(OWLClass ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectHasSelf ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectOneOf ce) {
        return ce;
    }

    public OWLDataRange visit(OWLDatatype node) {
        return node;
    }

    public OWLDataRange visit(OWLDataComplementOf node) {
        return node;
    }

    public OWLAxiom visit(OWLHasKeyAxiom axiom) {
        return axiom;
    }

    public OWLDataRange visit(OWLDatatypeRestriction node) {
        return node;
    }

    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }

    public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return axiom;
    }

    public OWLDataRange visit(OWLLiteral node) {
        return null;
    }

    public OWLDataRange visit(OWLFacetRestriction node) {
        return null;
    }
}

