/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.FrameStructureException;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class Frame {
    protected Collection<Clause> clauses;
    protected String id;
    protected FrameType type;

    public Frame() {
        this.init();
    }

    public Frame(FrameType type) {
        this.init();
        this.type = type;
    }

    protected void init() {
        this.clauses = new ArrayList<Clause>();
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<Clause> getClauses() {
        return this.clauses;
    }

    public Collection<Clause> getClauses(String tag) {
        ArrayList<Clause> cls = new ArrayList<Clause>();
        for (Clause cl : this.clauses) {
            if (!cl.getTag().equals(tag)) continue;
            cls.add(cl);
        }
        return cls;
    }

    public Collection<Clause> getClauses(OBOFormatConstants.OboFormatTag tag) {
        return this.getClauses(tag.getTag());
    }

    public Clause getClause(String tag) {
        for (Clause cl : this.clauses) {
            if (!cl.getTag().equals(tag)) continue;
            return cl;
        }
        return null;
    }

    public Clause getClause(OBOFormatConstants.OboFormatTag tag) {
        return this.getClause(tag.getTag());
    }

    public void setClauses(Collection<Clause> clauses) {
        this.clauses = clauses;
    }

    public void addClause(Clause cl) {
        this.clauses.add(cl);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Frame(");
        sb.append(this.id);
        sb.append(' ');
        for (Clause cl : this.clauses) {
            sb.append(cl.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public Object getTagValue(String tag) {
        if (this.getClause(tag) == null) {
            return null;
        }
        return this.getClause(tag).getValue();
    }

    public Object getTagValue(OBOFormatConstants.OboFormatTag tag) {
        return this.getTagValue(tag.getTag());
    }

    public <T> T getTagValue(String tag, Class<T> cls) {
        if (this.getClause(tag) == null) {
            return null;
        }
        Object value = this.getClause(tag).getValue();
        if (value != null && value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    public <T> T getTagValue(OBOFormatConstants.OboFormatTag tag, Class<T> cls) {
        return this.getTagValue(tag.getTag(), cls);
    }

    public Collection<Object> getTagValues(OBOFormatConstants.OboFormatTag tag) {
        return this.getTagValues(tag.getTag());
    }

    public Collection<Object> getTagValues(String tag) {
        Vector<Object> vals = new Vector<Object>();
        for (Clause c : this.getClauses(tag)) {
            vals.add(c.getValue());
        }
        return vals;
    }

    public <T> Collection<T> getTagValues(OBOFormatConstants.OboFormatTag tag, Class<T> cls) {
        return this.getTagValues(tag.getTag(), cls);
    }

    public <T> Collection<T> getTagValues(String tag, Class<T> cls) {
        Vector<T> vals = new Vector<T>();
        for (Clause c : this.getClauses(tag)) {
            vals.add(c.getValue(cls));
        }
        return vals;
    }

    public Collection<Xref> getTagXrefs(String tag) {
        Vector<Xref> xrefs = new Vector<Xref>();
        for (Object ob : this.getClause(tag).getValues()) {
            if (!(ob instanceof Xref)) continue;
            xrefs.add((Xref)ob);
        }
        return xrefs;
    }

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        for (Clause cl : this.getClauses()) {
            tags.add(cl.getTag());
        }
        return tags;
    }

    public void merge(Frame extFrame) throws FrameMergeException {
        if (this == extFrame) {
            return;
        }
        if (!extFrame.getId().equals(this.getId())) {
            throw new FrameMergeException("ids do not match");
        }
        if (!extFrame.getType().equals((Object)this.getType())) {
            throw new FrameMergeException("frame types do not match");
        }
        for (Clause c : extFrame.getClauses()) {
            this.addClause(c);
        }
    }

    public void check() throws FrameStructureException {
        Collection<Clause> iClauses;
        if (FrameType.HEADER.equals((Object)this.type)) {
            this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION, OBOFormatConstants.OboFormatTag.TAG_DATE, OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_SAVED_BY, OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY);
        }
        if (FrameType.TYPEDEF.equals((Object)this.type)) {
            this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_DOMAIN, OBOFormatConstants.OboFormatTag.TAG_RANGE, OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG, OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG);
        }
        if (!FrameType.HEADER.equals((Object)this.getType())) {
            if (this.getClauses(OBOFormatConstants.OboFormatTag.TAG_ID).size() != 1) {
                throw new FrameStructureException(this, "cardinality of id field must be 1");
            }
            if (this.getClause(OBOFormatConstants.OboFormatTag.TAG_ID).getValue() == null) {
                throw new FrameStructureException(this, "id field must not be null");
            }
            if (this.getId() == null) {
                throw new FrameStructureException(this, "id field must be set");
            }
        }
        if ((iClauses = this.getClauses(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF)).size() == 1) {
            throw new FrameStructureException(this, "single intersection_of tags are not allowed");
        }
        this.checkMaxOneCardinality(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS, OBOFormatConstants.OboFormatTag.TAG_NAME, OBOFormatConstants.OboFormatTag.TAG_DEF, OBOFormatConstants.OboFormatTag.TAG_COMMENT, OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE, OBOFormatConstants.OboFormatTag.TAG_CREATED_BY, OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE);
    }

    private void checkMaxOneCardinality(OBOFormatConstants.OboFormatTag ... tags) throws FrameStructureException {
        for (OBOFormatConstants.OboFormatTag tag : tags) {
            if (this.getClauses(tag).size() <= 1) continue;
            throw new FrameStructureException(this, "multiple " + tag.getTag() + " tags not allowed.");
        }
    }

    public static enum FrameType {
        HEADER,
        TERM,
        TYPEDEF,
        INSTANCE,
        ANNOTATION;

    }
}

