/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.assertions;

import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.assertions.Assertion;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpression;
import org.coode.parsers.oppl.testcase.assertions.AssertionVisitor;
import org.coode.parsers.oppl.testcase.assertions.AssertionVisitorEx;

public class LessThanAssertion
implements Assertion {
    private final AssertionExpression<Integer> left;
    private final AssertionExpression<Integer> right;

    public LessThanAssertion(AssertionExpression<Integer> left, AssertionExpression<Integer> right) {
        this.left = (AssertionExpression)ArgCheck.checkNotNull(left, (String)"left");
        this.right = (AssertionExpression)ArgCheck.checkNotNull(right, (String)"right");
    }

    public AssertionExpression<Integer> getLeft() {
        return this.left;
    }

    public AssertionExpression<Integer> getRight() {
        return this.right;
    }

    @Override
    public void accept(AssertionVisitor visitor) {
        visitor.visitAssertLessThan(this);
    }

    @Override
    public <O> O accept(AssertionVisitorEx<O> visitor) {
        return visitor.visitAssertLessThan(this);
    }

    @Override
    public boolean holds(Set<? extends BindingNode> bindings, ConstraintSystem constraintSystem) {
        return this.getLeft().resolve(bindings, constraintSystem) < this.getRight().resolve(bindings, constraintSystem);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LessThanAssertion other = (LessThanAssertion)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public String toString() {
        return String.format("%s < %s", this.getLeft(), this.getRight());
    }
}

