/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.BidirectionalShortFormProviderAdapter;
import org.coode.parsers.DisposableOWLEntityChecker;
import org.coode.parsers.DisposableShortFormEntityChecker;
import org.coode.parsers.EntityFinder;
import org.coode.parsers.EntityFinderImpl;
import org.coode.parsers.OWLEntityRenderer;
import org.coode.parsers.OWLEntityRenderingCache;
import org.coode.parsers.OWLEntityRenderingCacheImpl;
import org.coode.parsers.Scope;
import org.coode.parsers.ShortFormEntityRenderer;
import org.coode.parsers.factory.SymbolTableFactory;
import org.coode.parsers.oppl.OPPLScope;
import org.coode.parsers.oppl.testcase.OPPLTestCaseSymbolTable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class AnnotationBasedSymbolTableFactory
implements SymbolTableFactory<OPPLTestCaseSymbolTable> {
    private final OWLOntologyManager manager;
    private final List<OWLAnnotationProperty> annotations = new ArrayList<OWLAnnotationProperty>();

    public AnnotationBasedSymbolTableFactory(OWLOntologyManager manager, List<? extends IRI> iris) {
        this.manager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)manager, (String)"manager");
        OWLDataFactory dataFactory = this.manager.getOWLDataFactory();
        for (IRI iri : (List)ArgCheck.checkNotNull(iris, (String)"iris")) {
            this.annotations.add(dataFactory.getOWLAnnotationProperty(iri));
        }
    }

    public OPPLTestCaseSymbolTable createSymbolTable() {
        AnnotationValueShortFormProvider baseShortFormProvider = new AnnotationValueShortFormProvider(this.annotations, Collections.emptyMap(), (OWLOntologySetProvider)this.manager);
        BidirectionalShortFormProviderAdapter shortFormProvider = new BidirectionalShortFormProviderAdapter(this.manager, (ShortFormProvider)baseShortFormProvider);
        DisposableShortFormEntityChecker entityChecker = new DisposableShortFormEntityChecker(shortFormProvider);
        ShortFormEntityRenderer entityRenderer = new ShortFormEntityRenderer((ShortFormProvider)baseShortFormProvider);
        EntityFinderImpl entityFinder = new EntityFinderImpl(this.manager, (OWLEntityRenderingCache)new OWLEntityRenderingCacheImpl(this.manager, (OWLEntityRenderer)entityRenderer), false);
        return new OPPLTestCaseSymbolTable((Scope)new OPPLScope((DisposableOWLEntityChecker)entityChecker, (EntityFinder)entityFinder, (OWLEntityRenderer)entityRenderer), this.manager.getOWLDataFactory());
    }
}

