/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.assertions;

import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpression;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitor;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;

public class CountAssertionExpression
implements AssertionExpression<Integer> {
    private final Variable<?> variable;
    private final RuntimeExceptionHandler handler;

    public CountAssertionExpression(Variable<?> variable, RuntimeExceptionHandler handler) {
        this.variable = (Variable)ArgCheck.checkNotNull(variable, (String)"variable");
        this.handler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)handler, (String)"handler");
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    @Override
    public void accept(AssertionExpressionVisitor assertionExpressionVisitor) {
        assertionExpressionVisitor.visitCountAssertionExpression(this);
    }

    @Override
    public <O> O accept(AssertionExpressionVisitorEx<O> assertionExpressionVisitor) {
        return assertionExpressionVisitor.visitCountAssertionExpression(this);
    }

    public String toString() {
        return String.format("count(%s)", this.getVariable().getName());
    }

    @Override
    public Integer resolve(Set<? extends BindingNode> bindings, ConstraintSystem constraintSystem) {
        HashSet<OWLObject> values = new HashSet<OWLObject>(bindings.size());
        for (BindingNode bindingNode : bindings) {
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(constraintSystem, bindingNode, this.getHandler());
            OWLObject value = bindingNode.getAssignmentValue(this.getVariable(), (ValueComputationParameters)parameters);
            if (value == null) continue;
            values.add(value);
        }
        return values.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountAssertionExpression other = (CountAssertionExpression)obj;
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }
}

