/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.assertions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.AbstractOPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.assertions.Assertion;
import org.coode.parsers.oppl.testcase.assertions.AssertionVisitor;
import org.coode.parsers.oppl.testcase.assertions.AssertionVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class AssertContains
implements Assertion {
    private final Variable<?> variable;
    private final ConstraintSystem constraintSystem;
    private final Set<OWLObject> values = new HashSet<OWLObject>();
    private final AbstractOPPLTestCaseFactory testCaseFactory;
    private final RuntimeExceptionHandler handler;

    public AssertContains(Variable<?> variable, Collection<? extends OWLObject> values, ConstraintSystem constraintSystem, AbstractOPPLTestCaseFactory testCaseFactory, RuntimeExceptionHandler handler) {
        this.variable = (Variable)ArgCheck.checkNotNull(variable, (String)"variable");
        this.values.addAll((Collection)ArgCheck.checkNotNull(values, (String)"values"));
        if (values.isEmpty()) {
            throw new IllegalArgumentException("The values cannot be empty");
        }
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.testCaseFactory = (AbstractOPPLTestCaseFactory)ArgCheck.checkNotNull((Object)testCaseFactory, (String)"testCaseFactory");
        this.handler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)handler, (String)"handler");
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    @Override
    public <O> O accept(AssertionVisitorEx<O> visitor) {
        return visitor.visitAssertContains(this);
    }

    @Override
    public void accept(AssertionVisitor visitor) {
        visitor.visitAssertContains(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.format("%s CONTAINS ", this.getVariable().getName()));
        boolean first = true;
        for (OWLObject v : this.getValues()) {
            String comma = first ? "" : ", ";
            first = false;
            ManchesterSyntaxRenderer renderer = this.getTestCaseFactory().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            v.accept((OWLObjectVisitor)renderer);
            b.append(String.format("%s%s", comma, renderer));
        }
        return b.toString();
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public AbstractOPPLTestCaseFactory getTestCaseFactory() {
        return this.testCaseFactory;
    }

    @Override
    public boolean holds(Set<? extends BindingNode> bindings, ConstraintSystem cs) {
        HashSet<OWLObject> containerValues = new HashSet<OWLObject>(bindings.size());
        for (BindingNode bindingNode : bindings) {
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(cs, bindingNode, this.getHandler());
            OWLObject value = bindingNode.getAssignmentValue(this.getVariable(), (ValueComputationParameters)parameters);
            if (value == null) continue;
            containerValues.add(value);
        }
        return containerValues.containsAll(this.getValues());
    }

    public Set<OWLObject> getValues() {
        return new HashSet<OWLObject>(this.values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssertContains other = (AssertContains)obj;
        if (this.values == null ? other.values != null : !this.values.equals(other.values)) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }
}

