/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase;

import java.util.Collections;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.OPPLTest;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public abstract class TestCaseRunner {
    private final OPPLTestCase opplTestCase;
    private final boolean ignoreConfigurationFailure;
    private final ExecutionMonitor executionMonitor;
    private final RuntimeExceptionHandler handler = new RuntimeExceptionHandler(){

        public void handlePatternSyntaxExcpetion(PatternSyntaxException e) {
            TestCaseRunner.this.fail(e);
        }

        public void handleOWLRuntimeException(OWLRuntimeException e) {
            TestCaseRunner.this.fail((Throwable)e);
        }

        public void handleException(RuntimeException e) {
            TestCaseRunner.this.fail(e);
        }
    };

    public TestCaseRunner(OPPLTestCase opplTestCase) {
        this(opplTestCase, ExecutionMonitor.NON_CANCELLABLE, false);
    }

    public TestCaseRunner(OPPLTestCase opplTestCase, ExecutionMonitor executionMonitor, boolean ignoreConfigurationFailure) {
        this.opplTestCase = (OPPLTestCase)ArgCheck.checkNotNull((Object)opplTestCase, (String)"opplTestCase");
        this.executionMonitor = (ExecutionMonitor)ArgCheck.checkNotNull((Object)executionMonitor, (String)"executionMonitor");
        this.ignoreConfigurationFailure = ignoreConfigurationFailure;
    }

    public OPPLTestCase getOPPLTestCase() {
        return this.opplTestCase;
    }

    public final void run() {
        boolean checkConfiguration = this.checkConfiguration();
        if (this.ignoresConfigurationFailure() || checkConfiguration) {
            Set<BindingNode> bindings = this.executeQuery();
            this.runTests(bindings);
        }
    }

    protected boolean checkConfiguration() {
        boolean check;
        OWLReasoner scriptReasoner = this.getOPPLTestCase().getOPPLScript().getConstraintSystem().getReasoner();
        boolean bl = check = !this.getOPPLTestCase().requiresInference() || scriptReasoner != null;
        if (!check) {
            this.configurationFailed("The Test case requires inference, but no reasoner is available to run query");
        }
        return check;
    }

    protected abstract void configurationFailed(String var1);

    protected final void runTests(Set<? extends BindingNode> bindings) {
        for (OPPLTest test : this.getOPPLTestCase().getTests()) {
            this.runTest(test, bindings);
        }
    }

    protected void runTest(OPPLTest test, Set<? extends BindingNode> bindings) {
        boolean success = test.getAssertion().holds(bindings, this.getOPPLTestCase().getOPPLScript().getConstraintSystem());
        if (success) {
            this.success(test);
        } else {
            this.fail(test);
        }
    }

    protected abstract void success(OPPLTest var1);

    protected abstract void fail(OPPLTest var1);

    protected Set<BindingNode> executeQuery() {
        OPPLScript opplScript = this.getOPPLTestCase().getOPPLScript();
        opplScript.getQuery().execute(this.getHandler(), this.getExecutionMonitor());
        Set leaves = opplScript.getConstraintSystem().getLeaves();
        if (leaves != null) {
            return leaves;
        }
        return Collections.emptySet();
    }

    protected abstract void fail(Throwable var1);

    public boolean ignoresConfigurationFailure() {
        return this.ignoreConfigurationFailure;
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }

    public ExecutionMonitor getExecutionMonitor() {
        return this.executionMonitor;
    }
}

