/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.OPPLTest;
import org.coode.parsers.oppl.testcase.OPPLTestCase;

public class OPPLTestCaseImpl
implements OPPLTestCase {
    private final String name;
    private final OPPLScript opplScript;
    private final boolean requiresInference;
    private final List<OPPLTest> tests = new ArrayList<OPPLTest>();

    public OPPLTestCaseImpl(String name, OPPLScript opplScript, List<? extends OPPLTest> tests, boolean requiresInference) {
        this.name = (String)ArgCheck.checkNotNull((Object)name, (String)"name");
        this.opplScript = (OPPLScript)ArgCheck.checkNotNull((Object)opplScript, (String)"opplScript");
        if (!opplScript.getActions().isEmpty()) {
            throw new IllegalArgumentException("No actions allowed in OPPL Test case scripts");
        }
        this.requiresInference = requiresInference;
        this.tests.addAll((Collection)ArgCheck.checkNotNull(tests, (String)"tests"));
        if (tests.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one test");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean requiresInference() {
        return this.requiresInference;
    }

    @Override
    public OPPLScript getOPPLScript() {
        return this.opplScript;
    }

    @Override
    public List<OPPLTest> getTests() {
        return new ArrayList<OPPLTest>(this.tests);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.format("%s; %s%s ", this.getName(), this.requiresInference() ? "INFERENCE; " : "", this.getOPPLScript()));
        for (OPPLTest t : this.getTests()) {
            b.append(String.format("%s ", t));
        }
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.opplScript == null ? 0 : this.opplScript.hashCode());
        result = 31 * result + (this.requiresInference ? 1231 : 1237);
        result = 31 * result + (this.tests == null ? 0 : this.tests.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPPLTestCaseImpl other = (OPPLTestCaseImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.opplScript == null ? other.opplScript != null : !this.opplScript.equals(other.opplScript)) {
            return false;
        }
        if (this.requiresInference != other.requiresInference) {
            return false;
        }
        return !(this.tests == null ? other.tests != null : !this.tests.equals(other.tests));
    }
}

