/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase;

import java.util.List;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLFactory;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.AbstractOPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.OPPLTest;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.OPPLTestCaseImpl;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OPPLTestCaseFactory
implements AbstractOPPLTestCaseFactory {
    private final OWLOntology ontology;
    private final OWLOntologyManager ontologyManager;
    private final OWLReasoner reasoner;

    public OPPLTestCaseFactory(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontologyManager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)ontologyManager, (String)"ontologyManager");
        this.ontology = (OWLOntology)ArgCheck.checkNotNull((Object)ontology, (String)"ontology");
        this.reasoner = reasoner;
    }

    @Override
    public OPPLTestCase buildOPPLTestCase(String name, OPPLScript opplContent, List<? extends OPPLTest> tests, boolean requiresInference) {
        return new OPPLTestCaseImpl(name, opplContent, tests, requiresInference);
    }

    @Override
    public OPPLAbstractFactory getOPPLFactory() {
        return new OPPLFactory(this.getOntologyManager(), this.getOntology(), this.getReasoner());
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }
}

