/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.assertions;

import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.AbstractOPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpression;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitor;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class OWLExpressionAssertionExpression
implements AssertionExpression<Set<OWLObject>> {
    private final OWLObject owlObject;
    private final AbstractOPPLTestCaseFactory testCaseFactory;
    private final ConstraintSystem constraintSystem;
    private final RuntimeExceptionHandler handler;

    public OWLExpressionAssertionExpression(OWLObject owlObject, ConstraintSystem constraintSystem, AbstractOPPLTestCaseFactory testCaseFactory, RuntimeExceptionHandler handler) {
        this.owlObject = (OWLObject)ArgCheck.checkNotNull((Object)owlObject, (String)"owlObject");
        this.testCaseFactory = (AbstractOPPLTestCaseFactory)ArgCheck.checkNotNull((Object)testCaseFactory, (String)"testCaseFactory");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.handler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)handler, (String)"handler");
    }

    @Override
    public void accept(AssertionExpressionVisitor assertionExpressionVisitor) {
        assertionExpressionVisitor.visitOWLExpressionAssertionExpression(this);
    }

    @Override
    public <O> O accept(AssertionExpressionVisitorEx<O> assertionExpressionVisitor) {
        return assertionExpressionVisitor.visitOWLExpressionAssertionExpression(this);
    }

    public OWLObject getOWLObject() {
        return this.owlObject;
    }

    public AbstractOPPLTestCaseFactory getTestCaseFactory() {
        return this.testCaseFactory;
    }

    public String toString() {
        ManchesterSyntaxRenderer renderer = this.getTestCaseFactory().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
        this.owlObject.accept((OWLObjectVisitor)renderer);
        return renderer.toString();
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    public Set<OWLObject> resolve(Set<? extends BindingNode> bindings, ConstraintSystem cs) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        for (BindingNode bindingNode : bindings) {
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(cs, bindingNode, this.handler);
            PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)parameters);
            toReturn.add((OWLObject)this.owlObject.accept((OWLObjectVisitorEx)instantiator));
        }
        return toReturn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.owlObject == null ? 0 : this.owlObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OWLExpressionAssertionExpression other = (OWLExpressionAssertionExpression)obj;
        return !(this.owlObject == null ? other.owlObject != null : !this.owlObject.equals(other.owlObject));
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }
}

