/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.assertions;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.AbstractOPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpression;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitor;
import org.coode.parsers.oppl.testcase.assertions.AssertionExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class BindingNodeCountAssertionExpression
implements AssertionExpression<Integer> {
    private final BindingNode bindingNode;
    private final AbstractOPPLTestCaseFactory testCaseFactory;
    private final ConstraintSystem constraintSystem;

    public BindingNodeCountAssertionExpression(BindingNode bindingNode, ConstraintSystem constraintSystem, AbstractOPPLTestCaseFactory testCaseFactory) {
        this.bindingNode = (BindingNode)ArgCheck.checkNotNull((Object)bindingNode, (String)"bindingNode");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.testCaseFactory = (AbstractOPPLTestCaseFactory)ArgCheck.checkNotNull((Object)testCaseFactory, (String)"testCaseFactory");
    }

    @Override
    public void accept(AssertionExpressionVisitor assertionExpressionVisitor) {
        assertionExpressionVisitor.visitBindingNodeCountAssertionExpression(this);
    }

    @Override
    public <O> O accept(AssertionExpressionVisitorEx<O> assertionExpressionVisitor) {
        return assertionExpressionVisitor.visitBindingNodeCountAssertionExpression(this);
    }

    @Override
    public Integer resolve(Set<? extends BindingNode> bindings, ConstraintSystem cs) {
        int count = 0;
        Collection assignments = this.getBindingNode().getAssignments();
        for (BindingNode bindingNode : bindings) {
            if (!bindingNode.getAssignments().containsAll(assignments)) continue;
            ++count;
        }
        return count;
    }

    public BindingNode getBindingNode() {
        return this.bindingNode;
    }

    public AbstractOPPLTestCaseFactory getTestCaseFactory() {
        return this.testCaseFactory;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("count(");
        boolean first = true;
        TreeSet<Assignment> sortedAssignment = new TreeSet<Assignment>(new Comparator<Assignment>(){

            @Override
            public int compare(Assignment o1, Assignment o2) {
                return o1.getAssignedVariable().getName().compareTo(o2.getAssignedVariable().getName());
            }
        });
        sortedAssignment.addAll(this.getBindingNode().getAssignments());
        for (Assignment a : sortedAssignment) {
            String comma = first ? "" : ", ";
            ManchesterSyntaxRenderer renderer = this.getTestCaseFactory().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            a.getAssignment().accept((OWLObjectVisitor)renderer);
            b.append(String.format("%s%s = %s", comma, a.getAssignedVariable().getName(), renderer));
            first = false;
        }
        b.append(")");
        return b.toString();
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bindingNode == null ? 0 : this.bindingNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindingNodeCountAssertionExpression other = (BindingNodeCountAssertionExpression)obj;
        return !(this.bindingNode == null ? other.bindingNode != null : !this.bindingNode.equals((Object)other.bindingNode));
    }
}

