/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase;

import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.factory.SymbolTableFactory;
import org.coode.parsers.oppl.testcase.AbstractOPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.OPPLTestCaseFactory;
import org.coode.parsers.oppl.testcase.OPPLTestCaseParser;
import org.coode.parsers.oppl.testcase.OPPLTestCaseSymbolTable;
import org.coode.parsers.oppl.testcase.SimpleSymbolTableFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ParserFactory
implements OPPLTestCaseParser.AbstractParserFactory {
    private final OWLOntologyManager ontologyManager;
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;

    public ParserFactory(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontologyManager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)ontologyManager, (String)"ontologyManager");
        this.ontology = (OWLOntology)ArgCheck.checkNotNull((Object)ontology, (String)"ontology");
        this.reasoner = reasoner;
    }

    public ParserFactory(OWLOntology ontology, OWLOntologyManager ontologyManager) {
        this(ontology, ontologyManager, null);
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    @Override
    public OPPLTestCaseParser build(ErrorListener errorListener) {
        SimpleSymbolTableFactory symbolTableFactory = new SimpleSymbolTableFactory(this.getOntologyManager());
        return this.build(errorListener, symbolTableFactory);
    }

    public OPPLTestCaseParser build(ErrorListener errorListener, SymbolTableFactory<OPPLTestCaseSymbolTable> symbolTableFactory) {
        return new OPPLTestCaseParser(this.getOPPLTestCaseFactory(), errorListener, symbolTableFactory);
    }

    @Override
    public AbstractOPPLTestCaseFactory getOPPLTestCaseFactory() {
        return new OPPLTestCaseFactory(this.getOntology(), this.getOntologyManager(), this.getReasoner());
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }
}

