/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui.utils;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.util.VerifyingOptionPane;

public class JOptionPaneEx {
    public static int showValidatingConfirmDialog(Component parent, String title, JComponent component, VerifiedInputEditor verifiedInputEditor, int messageType, int optionType, JComponent defaultFocusedComponent) {
        final VerifyingOptionPane optionPane = new VerifyingOptionPane(component, messageType, optionType){
            private static final long serialVersionUID = 20100L;

            public void selectInitialValue() {
            }
        };
        InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean verified) {
                optionPane.setOKEnabled(verified);
            }
        };
        verifiedInputEditor.addStatusChangedListener(verificationListener);
        JDialog dlg = JOptionPaneEx.createDialog(parent, title, (JOptionPane)optionPane, defaultFocusedComponent);
        dlg.setModal(true);
        dlg.setVisible(true);
        return JOptionPaneEx.getReturnValue((JOptionPane)optionPane);
    }

    private static JDialog createDialog(Component parent, String title, JOptionPane optionPane, final JComponent defaultFocusedComponent) {
        JDialog dlg = optionPane.createDialog(parent, title);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (defaultFocusedComponent != null) {
                    defaultFocusedComponent.requestFocusInWindow();
                }
            }
        });
        dlg.setLocationRelativeTo(parent);
        dlg.setResizable(true);
        dlg.pack();
        return dlg;
    }

    private static int getReturnValue(JOptionPane optionPane) {
        Object value = optionPane.getValue();
        if (value != null && optionPane.getOptions() != null) {
            value = Arrays.binarySearch(optionPane.getOptions(), value);
        }
        return value != null ? (Integer)value : -1;
    }
}

