/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.Variable;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.coode.parsers.ui.ExpressionChecker;
import org.coode.parsers.ui.ExpressionEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLAnnotationPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLProperty;

public abstract class VariableValueEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    protected final OWLEditorKit owlEditorKit;
    private final List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private final String title;
    private Set<OWLObject> variableValues = null;

    protected VariableValueEditor(String title, OWLEditorKit owlEditorKit) {
        this.title = title;
        this.owlEditorKit = owlEditorKit;
    }

    public OWLEditorKit getOwlEditorKit() {
        return this.owlEditorKit;
    }

    public List<InputVerificationStatusChangedListener> getListeners() {
        return this.listeners;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<OWLObject> getVariableValues() {
        return this.variableValues;
    }

    protected final void setVariableValues(Set<? extends OWLObject> variableValues) {
        if (this.variableValues == null) {
            this.variableValues = new HashSet<OWLObject>(variableValues.size());
        }
        this.variableValues.clear();
        this.variableValues.addAll(variableValues);
        this.notifyListeners();
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (InputVerificationStatusChangedListener listener : this.getListeners()) {
            this.notifyListener(listener);
        }
    }

    protected void notifyListener(InputVerificationStatusChangedListener listener) {
        listener.verifiedStatusChanged(this.getVariableValues() != null && this.getVariableValues().size() > 0);
    }

    public static VariableValueEditor getVariableValueEditor(final OWLEditorKit owlEditorKit, final Variable<?> variable) {
        return (VariableValueEditor)variable.getType().accept((VariableTypeVisitorEx)new VariableTypeVisitorEx<VariableValueEditor>(){

            public VariableValueEditor visitCLASSVariableType(CLASSVariableType classVariableType) {
                return new ClassVariableValueEditor(owlEditorKit, variable);
            }

            public VariableValueEditor visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
                return new PropertyVariableValueEditor(owlEditorKit, variable, false);
            }

            public VariableValueEditor visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
                return new PropertyVariableValueEditor(owlEditorKit, variable, true);
            }

            public VariableValueEditor visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
                return new IndividualVariableValueEditor(owlEditorKit, variable);
            }

            public VariableValueEditor visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
                return new ConstantVariableValueEditor(owlEditorKit, variable);
            }

            public VariableValueEditor visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                return new AnnotationPropertyVariableValueEditor(owlEditorKit, variable);
            }
        });
    }

    public abstract void dispose();

    private static class ConstantVariableValueEditor
    extends VariableValueEditor
    implements org.coode.parsers.ui.InputVerificationStatusChangedListener {
        private static final long serialVersionUID = 20100L;
        private ExpressionEditor<OWLLiteral> owlConstantEditor;

        ConstantVariableValueEditor(OWLEditorKit owlEditorKit, Variable<?> variable) {
            super(variable.getName(), owlEditorKit);
            this.setLayout(new BorderLayout());
            this.owlConstantEditor = new ExpressionEditor(this.getOwlEditorKit().getOWLModelManager().getOWLOntologyManager(), (ExpressionChecker)new OPPLExpressionChecker<OWLLiteral>(this.getOwlEditorKit()){

                @Override
                protected OWLLiteral parse(String _text) {
                    String text = _text;
                    if (!text.contains("^")) {
                        text = "\"" + text + "\"";
                    } else if (!text.startsWith("\"")) {
                        text = text.replaceAll("(.*)\\^", "\"$1\"^");
                    }
                    OPPLParser opplParser = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).build(this.getListener());
                    OWLLiteral constant = opplParser.parsePlainConstant(text);
                    return constant;
                }
            });
            this.owlConstantEditor.addStatusChangedListener((org.coode.parsers.ui.InputVerificationStatusChangedListener)this);
            JPanel owlConstantEditorBorder = new JPanel(new BorderLayout());
            owlConstantEditorBorder.setBorder(ComponentFactory.createTitledBorder((String)"Value: "));
            owlConstantEditorBorder.add(ComponentFactory.createScrollPane(this.owlConstantEditor));
            this.add(owlConstantEditorBorder);
        }

        public void verifiedStatusChanged(boolean newState) {
            if (newState) {
                OWLLiteral owlConstant = (OWLLiteral)this.owlConstantEditor.createObject();
                this.setVariableValues(Collections.singleton(owlConstant));
            }
        }

        @Override
        public void dispose() {
            this.owlConstantEditor.removeStatusChangedListener((org.coode.parsers.ui.InputVerificationStatusChangedListener)this);
        }
    }

    private static class IndividualVariableValueEditor
    extends VariableValueEditor
    implements ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final OWLIndividualSelectorPanel individualSelectorPanel;

        IndividualVariableValueEditor(OWLEditorKit owlEditorKit, Variable<?> variable) {
            super(variable.getName(), owlEditorKit);
            this.setLayout(new BorderLayout());
            this.individualSelectorPanel = new OWLIndividualSelectorPanel(this.getOwlEditorKit());
            this.individualSelectorPanel.addSelectionListener((ChangeListener)this);
            JPanel individualSelectorPanelBorder = new JPanel(new BorderLayout());
            individualSelectorPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Values: "));
            individualSelectorPanelBorder.add(ComponentFactory.createScrollPane((JComponent)this.individualSelectorPanel));
            this.add(individualSelectorPanelBorder);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Set selectedObjects = this.individualSelectorPanel.getSelectedObjects();
            if (selectedObjects != null) {
                this.setVariableValues(selectedObjects);
            }
            this.notifyListeners();
        }

        @Override
        public void dispose() {
            this.individualSelectorPanel.dispose();
        }
    }

    private static class AnnotationPropertyVariableValueEditor
    extends VariableValueEditor
    implements ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final AbstractHierarchySelectorPanel<OWLAnnotationProperty> propertySelector;

        AnnotationPropertyVariableValueEditor(OWLEditorKit owlEditorKit, Variable<?> variable) {
            super(variable.getName(), owlEditorKit);
            this.setLayout(new BorderLayout());
            this.propertySelector = new OWLAnnotationPropertySelectorPanel(this.getOwlEditorKit(), true);
            this.propertySelector.addSelectionListener((ChangeListener)this);
            JPanel propertySelectorPanelBorder = new JPanel(new BorderLayout());
            propertySelectorPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Values: "));
            propertySelectorPanelBorder.add(ComponentFactory.createScrollPane(this.propertySelector));
            this.add(propertySelectorPanelBorder);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Set selectedObjects = this.propertySelector.getSelectedObjects();
            if (selectedObjects != null) {
                this.setVariableValues(selectedObjects);
            }
            this.notifyListeners();
        }

        @Override
        public void dispose() {
            this.propertySelector.dispose();
        }
    }

    private static class PropertyVariableValueEditor
    extends VariableValueEditor
    implements ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final AbstractHierarchySelectorPanel<? extends OWLProperty<?, ?>> propertySelector;

        PropertyVariableValueEditor(OWLEditorKit owlEditorKit, Variable<?> variable, boolean isDataProperty) {
            super(variable.getName(), owlEditorKit);
            this.setLayout(new BorderLayout());
            this.propertySelector = isDataProperty ? new OWLDataPropertySelectorPanel(this.getOwlEditorKit()) : new OWLObjectPropertySelectorPanel(this.getOwlEditorKit());
            this.propertySelector.addSelectionListener((ChangeListener)this);
            JPanel propertySelectorPanelBorder = new JPanel(new BorderLayout());
            propertySelectorPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Values: "));
            propertySelectorPanelBorder.add(ComponentFactory.createScrollPane(this.propertySelector));
            this.add(propertySelectorPanelBorder);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Set selectedObjects = this.propertySelector.getSelectedObjects();
            if (selectedObjects != null) {
                this.setVariableValues(selectedObjects);
            }
            this.notifyListeners();
        }

        @Override
        public void dispose() {
            this.propertySelector.dispose();
        }
    }

    private static class ClassVariableValueEditor
    extends VariableValueEditor
    implements ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final OWLClassSelectorPanel classSelectorPanel;

        ClassVariableValueEditor(OWLEditorKit owlEditorKit, Variable<?> variable) {
            super(variable.getName(), owlEditorKit);
            this.setLayout(new BorderLayout());
            this.classSelectorPanel = new OWLClassSelectorPanel(this.getOwlEditorKit());
            this.classSelectorPanel.addSelectionListener((ChangeListener)this);
            JPanel classSelectorPanelBorder = new JPanel(new BorderLayout());
            classSelectorPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Values: "));
            classSelectorPanelBorder.add(ComponentFactory.createScrollPane((JComponent)this.classSelectorPanel));
            this.add(classSelectorPanelBorder);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Set selectedObjects = this.classSelectorPanel.getSelectedObjects();
            if (selectedObjects != null) {
                this.setVariableValues(selectedObjects);
            }
            this.notifyListeners();
        }

        @Override
        public void dispose() {
            this.classSelectorPanel.dispose();
        }
    }
}

