/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.parsers.oppl.patterns.ui.autocompletionmatcher.ProtegeOPPLPatternsAutoCompletionMatcher;
import org.coode.parsers.ui.AutoCompleter;
import org.coode.parsers.ui.ExpressionChecker;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.coode.parsers.ui.autocompletionmatcher.AutoCompletionMatcher;
import org.coode.patterns.HasPatternModel;
import org.coode.patterns.OPPLPatternParser;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternModelChangeListener;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class TypeInPatternBuilder
implements VerifiedInputEditor,
org.coode.parsers.ui.InputVerificationStatusChangedListener,
PatternModelChangeListener,
HasPatternModel,
Serializable {
    private static final long serialVersionUID = 20100L;
    private final Set<org.coode.parsers.ui.InputVerificationStatusChangedListener> listeners = new HashSet<org.coode.parsers.ui.InputVerificationStatusChangedListener>();
    private final OWLEditorKit owlEditorKit;
    protected PatternModel patternModel = null;
    private final JPanel mainPanel = new JPanel();
    protected ExpressionEditor<PatternModel> patternModelEditor;
    protected IRI iri;
    protected org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor<String> patternNameTextField;
    private final ProtegeOPPLPatternsAutoCompletionMatcher autoCompletionMatcher;
    private final OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            TypeInPatternBuilder.this.patternModelEditor.setText(TypeInPatternBuilder.this.patternModelEditor.getText());
        }
    };
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            TypeInPatternBuilder.this.patternModelEditor.setText(TypeInPatternBuilder.this.patternModelEditor.getText());
        }
    };

    public TypeInPatternBuilder(OWLEditorKit owlEditorKit) {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setName("Pattern Text Editor");
        this.owlEditorKit = owlEditorKit;
        this.getOWLEditorKit().getOWLModelManager().addListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().addOntologyChangeListener(this.ontologyChangeListener);
        this.patternNameTextField = new org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor(owlEditorKit, (OWLExpressionChecker)new OWLExpressionChecker<String>(){
            private String lastName;

            public void check(String text) throws OWLExpressionParserException {
                if (!text.matches("\\w+")) {
                    throw new OWLExpressionParserException((Throwable)new Exception("Invalid pattern name " + text));
                }
                this.lastName = text;
            }

            public String createObject(String text) throws OWLExpressionParserException {
                this.check(text);
                return this.lastName;
            }
        });
        JPanel patternNamePanel = new JPanel(new BorderLayout());
        patternNamePanel.add((Component)this.patternNameTextField);
        this.patternNameTextField.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateIRI() {
                TypeInPatternBuilder.this.iri = null;
                String localName = TypeInPatternBuilder.this.patternNameTextField.getText();
                if (localName.length() != 0) {
                    try {
                        TypeInPatternBuilder.this.iri = IRI.create((String)("http://www.co-ode.org/patterns#" + localName));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        TypeInPatternBuilder.this.handleChange();
                    }
                }
            }

            public void verifiedStatusChanged(boolean newState) {
                this.updateIRI();
            }
        });
        patternNamePanel.setBorder(ComponentFactory.createTitledBorder((String)"Pattern name"));
        this.mainPanel.add((Component)patternNamePanel, "North");
        OPPLExpressionChecker<PatternModel> expressionChecker = new OPPLExpressionChecker<PatternModel>(this.getOWLEditorKit()){

            @Override
            protected PatternModel parse(String text) {
                OPPLPatternParser parser = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).build(this.getListener());
                return parser.parse(text);
            }
        };
        this.patternModelEditor = new ExpressionEditor(this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager(), (ExpressionChecker)expressionChecker);
        this.autoCompletionMatcher = new ProtegeOPPLPatternsAutoCompletionMatcher(this.getOWLEditorKit());
        new AutoCompleter(this.patternModelEditor, (AutoCompletionMatcher)this.autoCompletionMatcher);
        this.removeKeyListeners();
        this.patternModelEditor.setPreferredSize(new Dimension(50, 200));
        JScrollPane opplStatementEditorPane = ComponentFactory.createScrollPane(this.patternModelEditor);
        JPanel opplStatementEditorPanel = new JPanel(new BorderLayout());
        opplStatementEditorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Pattern statement"));
        this.patternModelEditor.addStatusChangedListener((org.coode.parsers.ui.InputVerificationStatusChangedListener)this);
        opplStatementEditorPanel.add(opplStatementEditorPane);
        this.mainPanel.add((Component)opplStatementEditorPanel, "Center");
        if (this.patternModel != null) {
            this.patternModel.addChangeListener((PatternModelChangeListener)this);
        }
    }

    public void addStatusChangedListener(org.coode.parsers.ui.InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListener(this.check(), listener);
    }

    public void removeStatusChangedListener(org.coode.parsers.ui.InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public PatternModel getPatternModel() {
        return this.patternModel;
    }

    public void verifiedStatusChanged(boolean newState) {
        this.patternModel = null;
        if (newState) {
            this.patternModel = (PatternModel)this.patternModelEditor.createObject();
        }
        this.handleChange();
    }

    public void handleChange() {
        if (this.patternModel != null) {
            this.patternModel.setIRI(this.iri);
        }
        boolean newState = this.check();
        for (org.coode.parsers.ui.InputVerificationStatusChangedListener listener : this.listeners) {
            this.notifyListener(newState, listener);
        }
    }

    private void notifyListener(boolean newState, org.coode.parsers.ui.InputVerificationStatusChangedListener listener) {
        listener.verifiedStatusChanged(newState);
    }

    private boolean check() {
        return this.patternModel != null && this.patternModel.isValid() && this.patternModel.getIRI() != null;
    }

    public void clear() {
        this.patternModelEditor.setText("");
        this.patternNameTextField.setText("");
    }

    public void dispose() {
        if (this.patternModel != null) {
            this.patternModel.removeChangeListener((PatternModelChangeListener)this);
        }
        this.patternModelEditor.removeStatusChangedListener((org.coode.parsers.ui.InputVerificationStatusChangedListener)this);
        this.autoCompletionMatcher.dispose();
        this.getOWLEditorKit().getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().removeOntologyChangeListener(this.ontologyChangeListener);
    }

    public PatternModel getEditedObject() {
        return this.patternModel;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public void setPatternModel(PatternModel patternModel) {
        this.patternModelEditor.setText(patternModel == null ? "" : patternModel.render(new ShortFormProvider(){

            public String getShortForm(OWLEntity entity) {
                return TypeInPatternBuilder.this.getOWLEditorKit().getOWLModelManager().getRendering((OWLObject)entity);
            }

            public void dispose() {
            }
        }));
        this.patternNameTextField.setText(patternModel == null ? "" : patternModel.getPatternLocalName());
    }

    private void removeKeyListeners() {
        KeyListener[] keyListeners;
        for (KeyListener keyListener : keyListeners = this.patternNameTextField.getKeyListeners()) {
            this.patternNameTextField.removeKeyListener(keyListener);
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }
}

