/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.util.Iterator;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternReferenceNotFoundException;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.coode.patterns.utils.Utils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.OWLOntology;

public class PatternReferenceExpressionChecker
implements OWLExpressionChecker<InstantiatedPatternModel> {
    private final OWLEditorKit owlEditorKit;
    private InstantiatedPatternModel instantiatedPatternModel = null;
    private final RuntimeExceptionHandler handler;

    public PatternReferenceExpressionChecker(OWLEditorKit owlEditorKit, RuntimeExceptionHandler handler) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.handler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)handler, (String)"handler");
    }

    public void check(String text) throws OWLExpressionParserException {
        Iterator it = this.owlEditorKit.getModelManager().getOntologies().iterator();
        this.instantiatedPatternModel = null;
        boolean found = false;
        PatternModel patternModel = null;
        AbstractPatternModelFactory patternFactory = ProtegeParserFactory.getInstance(this.owlEditorKit).getPatternFactory();
        while (!found && it.hasNext()) {
            OWLOntology ontology = (OWLOntology)it.next();
            patternModel = Utils.find((String)text, (OWLOntology)ontology, (AbstractPatternModelFactory)patternFactory);
            found = patternModel != null;
        }
        if (!found) {
            throw new OWLExpressionParserException((Throwable)new PatternReferenceNotFoundException("Invalid pattern name: " + text));
        }
        this.instantiatedPatternModel = patternFactory.createInstantiatedPatternModel(patternModel, this.getHandler());
    }

    public InstantiatedPatternModel createObject(String text) throws OWLExpressionParserException {
        this.check(text);
        return this.instantiatedPatternModel;
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }
}

