/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.PatternModel;
import org.coode.patterns.protege.ui.PatternOWLSubClassAxiomFrameSectionRow;
import org.coode.patterns.utils.Utils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.OWLSubClassAxiomFrameSection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class PatternOWLSubCLassAxiomFrameSection
extends OWLSubClassAxiomFrameSection {
    private final AbstractPatternModelFactory factory;

    public PatternOWLSubCLassAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<OWLClass> frame, AbstractPatternModelFactory f) {
        super(editorKit, frame);
        this.factory = f;
    }

    protected Set<OWLSubClassOfAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        HashSet<OWLSubClassOfAxiom> toReturn = new HashSet<OWLSubClassOfAxiom>();
        if (!descr.isAnonymous()) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(this.getRootObject().asOWLClass())) {
                Set annotationAxioms = ax.getAnnotations();
                boolean isPatternGenerated = Utils.isPatternGenerated((Collection)annotationAxioms);
                if (!isPatternGenerated) continue;
                toReturn.add(ax);
            }
        }
        return toReturn;
    }

    protected void addAxiom(OWLSubClassOfAxiom ax, OWLOntology ontology) {
        PatternModel generatingPatternModel;
        Set annotationAxioms = ax.getAnnotations();
        boolean isPatternGenerated = Utils.isPatternGenerated((Collection)annotationAxioms);
        if (isPatternGenerated && (generatingPatternModel = Utils.getGeneratingPatternModel((Collection)annotationAxioms, (OWLOntologyManager)this.getOWLEditorKit().getModelManager().getOWLOntologyManager(), (AbstractPatternModelFactory)this.factory)) != null) {
            this.addRow((OWLFrameSectionRow)new PatternOWLSubClassAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, this.getRootObject().asOWLClass(), ax, generatingPatternModel));
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        if (Utils.isPatternGenerated((Collection)axiom.getAnnotations())) {
            this.reset();
        }
    }

    protected void refillInferred() {
    }

    public boolean canAdd() {
        return false;
    }
}

