/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.PatternModel;
import org.coode.patterns.protege.ui.PatternOWLEquivalentClassesAxiomFrameSectionRow;
import org.coode.patterns.utils.Utils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.OWLEquivalentClassesAxiomFrameSection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class PatternOWLEquivalentClassesAxiomFrameSection
extends OWLEquivalentClassesAxiomFrameSection {
    private final AbstractPatternModelFactory factory;

    public PatternOWLEquivalentClassesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<OWLClass> frame, AbstractPatternModelFactory f) {
        super(editorKit, frame);
        this.factory = f;
    }

    public boolean canAdd() {
        return false;
    }

    protected Set<OWLEquivalentClassesAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        HashSet<OWLEquivalentClassesAxiom> toReturn = new HashSet<OWLEquivalentClassesAxiom>();
        if (!descr.isAnonymous()) {
            for (OWLEquivalentClassesAxiom ax : ont.getEquivalentClassesAxioms(this.getRootObject().asOWLClass())) {
                Set annotationAxioms = ax.getAnnotations();
                boolean isPatternGenerated = Utils.isPatternGenerated((Collection)annotationAxioms);
                if (!isPatternGenerated) continue;
                toReturn.add(ax);
            }
        }
        return toReturn;
    }

    protected void addAxiom(OWLEquivalentClassesAxiom ax, OWLOntology ontology) {
        PatternModel generatingPatternModel;
        Set annotationAxioms = ax.getAnnotations();
        boolean isPatternGenerated = Utils.isPatternGenerated((Collection)annotationAxioms);
        if (isPatternGenerated && (generatingPatternModel = Utils.getGeneratingPatternModel((Collection)annotationAxioms, (OWLOntologyManager)this.getOWLEditorKit().getModelManager().getOWLOntologyManager(), (AbstractPatternModelFactory)this.factory)) != null) {
            this.addRow((OWLFrameSectionRow)new PatternOWLEquivalentClassesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, this.getRootObject().asOWLClass(), ax, generatingPatternModel));
        }
    }

    protected void refillInferred() {
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (Utils.isPatternGenerated((Collection)axiom.getAnnotations())) {
            this.reset();
        }
    }
}

