/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.border.Border;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.patterns.HasPatternModel;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.NonClassPatternExecutor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.protege.PatternAnnotationContainer;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.coode.patterns.protege.ui.InstantiatePatternButton;
import org.coode.patterns.protege.ui.PatternBorder;
import org.coode.patterns.protege.ui.PatternEditor;
import org.coode.patterns.protege.ui.PatternInstantiationEditor;
import org.coode.patterns.protege.ui.utils.JOptionPaneEx;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.AnnotationContainer;
import org.protege.editor.owl.ui.list.AbstractAnnotationsList;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class PatternModelList
extends AbstractAnnotationsList<PatternAnnotationContainer> {
    private static final long serialVersionUID = 20100L;
    private final MListSectionHeader header = new MListSectionHeader(){

        public String getName() {
            return "Patterns";
        }

        public boolean canAdd() {
            return true;
        }
    };
    private final OWLEditorKit owlEditorKit;
    private PatternEditor patternEditor;
    private final RuntimeExceptionHandler runtimeExceptionHandler;

    public PatternModelList(OWLEditorKit eKit) {
        super(eKit);
        this.owlEditorKit = eKit;
        this.patternEditor = this.createPatternEditor();
        this.runtimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)this.getOWLEditorKit().getOWLWorkspace());
    }

    private PatternEditor createPatternEditor() {
        return new PatternEditor(this.getOWLEditorKit(), ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getPatternFactory());
    }

    protected List<OWLOntologyChange> getAddChanges(OWLAnnotation annot) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new AddOntologyAnnotation(((PatternAnnotationContainer)this.getRoot()).getOntology(), annot));
        return changes;
    }

    protected List<OWLOntologyChange> getReplaceChanges(OWLAnnotation oldAnnotation, OWLAnnotation newAnnotation) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(((PatternAnnotationContainer)this.getRoot()).getOntology(), oldAnnotation));
        changes.add((OWLOntologyChange)new AddOntologyAnnotation(((PatternAnnotationContainer)this.getRoot()).getOntology(), newAnnotation));
        return changes;
    }

    protected List<OWLOntologyChange> getDeleteChanges(OWLAnnotation annot) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(((PatternAnnotationContainer)this.getRoot()).getOntology(), annot));
        return changes;
    }

    protected Border createListItemBorder(JList l, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Border border;
        Border toReturn = border = super.createListItemBorder(l, value, index, isSelected, cellHasFocus);
        if (value instanceof PatternListItem) {
            PatternModel patternModel = ((PatternListItem)((Object)value)).getPatternModel();
            PatternBorder patternBorder = new PatternBorder(patternModel);
            toReturn = BorderFactory.createCompoundBorder(border, patternBorder);
        }
        return toReturn;
    }

    protected void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof AddOntologyAnnotation) && !(oWLOntologyChange instanceof RemoveOntologyAnnotation) || !oWLOntologyChange.getOntology().equals(((PatternAnnotationContainer)this.getRoot()).getOntology())) continue;
            this.refresh();
            return;
        }
    }

    protected PatternEditor getEditor() {
        return this.patternEditor == null ? this.createPatternEditor() : this.patternEditor;
    }

    protected void handleAdd() {
        this.getEditor().setEditedObject(null);
        int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)this.getOWLEditorKit().getWorkspace(), "Pattern Editor", this.getEditor().getEditorComponent(), this.getEditor(), -1, 2, this.getComponentPopupMenu());
        if (ret == 0) {
            PatternModel patternModel = this.getEditor().getEditedObject();
            OWLDataFactory dataFactory = this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().getOWLDataFactory();
            OWLLiteral literal = dataFactory.getOWLLiteral(patternModel.render((ShortFormProvider)new SimpleShortFormProvider()));
            IRI annotationIRI = patternModel.getIRI();
            OWLAnnotation annotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)literal);
            this.getOWLEditorKit().getModelManager().applyChanges(this.getAddChanges(annotation));
        }
    }

    public void setRootObject(PatternAnnotationContainer root) {
        super.setRootObject((AnnotationContainer)root);
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.header);
        if (root != null) {
            for (OWLAnnotation annot : root.getAnnotations()) {
                data.add((Object)new PatternListItem(annot, root.getPatternModel(annot)));
            }
        }
        this.setListData(data.toArray());
        this.revalidate();
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        InstantiateActionListener actionListener;
        InstantiatePatternButton instantiateButton;
        PatternModel patternModel;
        List listItemButtons = super.getListItemButtons(item);
        if (item instanceof PatternListItem && !(patternModel = ((PatternListItem)item).getPatternModel()).isClassPattern() && !listItemButtons.contains((Object)(instantiateButton = new InstantiatePatternButton(actionListener = new InstantiateActionListener(patternModel))))) {
            listItemButtons.add(instantiateButton);
        }
        return listItemButtons;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    protected void showInstantiationEditorDialog(final PatternModel patternModel) {
        final PatternInstantiationEditor editor = new PatternInstantiationEditor(this.getOWLEditorKit(), patternModel.getPatternModelFactory());
        final JComponent editorComponent = editor.getEditorComponent();
        final VerifyingOptionPane optionPane = new VerifyingOptionPane(editor.getEditorComponent());
        final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean verified) {
                optionPane.setOKEnabled(verified);
            }
        };
        InstantiatedPatternModel instantiatedPatternModel = patternModel.getPatternModelFactory().createInstantiatedPatternModel(patternModel, this.getRuntimeExceptionHandler());
        editor.setInstantiatedPatternModel(instantiatedPatternModel);
        editor.addStatusChangedListener(verificationListener);
        JDialog dlg = optionPane.createDialog((Component)this.getOWLEditorKit().getWorkspace(), null);
        dlg.setModal(true);
        dlg.setTitle(patternModel.getName());
        dlg.setResizable(true);
        dlg.pack();
        dlg.setLocationRelativeTo((Component)this.getOWLEditorKit().getWorkspace());
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Object retVal = optionPane.getValue();
                editorComponent.setPreferredSize(editorComponent.getSize());
                if (retVal != null && retVal.equals(0)) {
                    PatternModelList.this.handleInstantiation(editor, patternModel);
                }
                editor.removeStatusChangedListener(verificationListener);
                editor.dispose();
            }
        });
        dlg.setVisible(true);
    }

    protected void handleInstantiation(PatternInstantiationEditor editor, PatternModel patternModel) {
        NonClassPatternExecutor patternExecutor = new NonClassPatternExecutor(editor.getEditedObject(), this.getOWLEditorKit().getModelManager().getActiveOntology(), this.getOWLEditorKit().getModelManager().getOWLOntologyManager(), patternModel.getIRI(), this.getRuntimeExceptionHandler());
        List changes = patternExecutor.visit((OPPLScript)patternModel);
        for (OWLAxiomChange change : changes) {
            try {
                this.getOWLEditorKit().getModelManager().getOWLOntologyManager().applyChange((OWLOntologyChange)change);
            }
            catch (OWLOntologyChangeException e) {
                e.printStackTrace();
            }
        }
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public void dispose() {
        super.dispose();
        if (this.patternEditor != null) {
            this.patternEditor.dispose();
            this.patternEditor = null;
        }
    }

    public final class PatternListItem
    extends AbstractAnnotationsList.AnnotationsListItem
    implements HasPatternModel {
        private final PatternModel patternModel;

        public PatternListItem(OWLAnnotation annot, PatternModel patternModel) {
            super((AbstractAnnotationsList)PatternModelList.this, annot);
            this.patternModel = (PatternModel)ArgCheck.checkNotNull((Object)patternModel, (String)"patternModel");
        }

        public PatternModel getPatternModel() {
            return this.patternModel;
        }

        public void handleEdit() {
            PatternModelList.this.getEditor().setEditedObject(this.patternModel);
            int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)PatternModelList.this.getOWLEditorKit().getWorkspace(), "Pattern Editor", PatternModelList.this.getEditor().getEditorComponent(), PatternModelList.this.getEditor(), -1, 2, PatternModelList.this.getComponentPopupMenu());
            if (ret == 0) {
                PatternModel pm = PatternModelList.this.getEditor().getEditedObject();
                OWLDataFactory dataFactory = PatternModelList.this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().getOWLDataFactory();
                OWLLiteral literal = dataFactory.getOWLLiteral(pm.render((ShortFormProvider)new SimpleShortFormProvider()));
                IRI annotationIRI = pm.getIRI();
                OWLAnnotation newAnnotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)literal);
                if (!newAnnotation.equals(this.getAnnotation())) {
                    List<OWLOntologyChange> changes = PatternModelList.this.getReplaceChanges(this.getAnnotation(), newAnnotation);
                    PatternModelList.this.getOWLEditorKit().getModelManager().applyChanges(changes);
                }
            }
        }
    }

    private final class InstantiateActionListener
    implements ActionListener {
        private final PatternModel patternModel;

        public InstantiateActionListener(PatternModel patternModel) {
            this.patternModel = patternModel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PatternModelList.this.showInstantiationEditorDialog(this.patternModel);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.patternModel == null ? 0 : this.patternModel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstantiateActionListener other = (InstantiateActionListener)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            return !(this.patternModel == null ? other.patternModel != null : !this.patternModel.equals((Object)other.patternModel));
        }

        private PatternModelList getOuterType() {
            return PatternModelList.this;
        }
    }
}

