/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.protege.ui.ActionList;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.NoDefaultFocusVerifyingOptionPane;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.protege.ui.VariableList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternModel;
import org.coode.patterns.locality.LocalityChecker;
import org.coode.patterns.protege.ui.LocalityCheckerActionListener;
import org.coode.patterns.protege.ui.VariableValueEditor;
import org.coode.patterns.protege.utils.OWLEntitySelector;
import org.coode.patterns.protege.utils.RenderableObjectCellRenderer;
import org.coode.patterns.protege.utils.VariableListModel;
import org.coode.patterns.utils.Utils;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class PatternInstantiationEditor
extends AbstractOWLObjectEditor<InstantiatedPatternModel>
implements VerifiedInputEditor,
ListDataListener,
ListSelectionListener {
    protected final OWLEditorKit owlEditorKit;
    private JPanel mainPane;
    private final ShowMessageRuntimeExceptionHandler showMessageRuntimeExceptionHandler;
    private final DefaultComboBoxModel<Object> patternListModel = new DefaultComboBoxModel();
    protected JComboBox patternList = new JComboBox<Object>(this.patternListModel);
    protected InstantiatedPatternModel instantiatedPatternModel;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private JPanel effectsBorder;
    private ActionList actionList;
    private JSplitPane instantiationPanel;
    protected OWLClass owlClass = null;
    private InstantiatedPatternModel instantantiatedPatternModel2CopyFrom = null;
    protected VariableList variableList;
    private VariableValuesMList valueList;
    private JScrollPane variablePane;
    private JScrollPane valuePane;
    private final JPanel problemPanel = new JPanel(new BorderLayout());
    private final DefaultListModel<Object> problemListModel = new DefaultListModel();
    private final JList<Object> problemList = new JList<Object>(this.problemListModel);
    private final AbstractPatternModelFactory factory;
    private final JButton localityCheckResultButton = new JButton();
    private final JButton localityCheckButton = new JButton("Check Locality");
    private final JButton localityCheckPreferenceButton = new JButton("Signature");
    protected LocalityCheckerActionListener localityChecker;
    protected final Set<OWLEntity> localityCheckerSignature = new HashSet<OWLEntity>();
    protected final VariableListModel<OWLEntity> localityCheckerSignatureModel = new VariableListModel<OWLEntity>(this.localityCheckerSignature, "Signature elements");
    private JPanel buttonPanel;
    private final JLabel reasonerWarning = new JLabel();

    public PatternInstantiationEditor(OWLEditorKit owlEditorKit, OWLClass owlClass, AbstractPatternModelFactory f) {
        this(owlEditorKit, f);
        this.owlClass = owlClass;
    }

    public PatternInstantiationEditor(OWLEditorKit owlEditorKit, AbstractPatternModelFactory f) {
        this.owlEditorKit = owlEditorKit;
        this.factory = f;
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.setFocusable(false);
        this.localityCheckerSignature.addAll(LocalityChecker.collectEntities((Set)this.owlEditorKit.getOWLModelManager().getOntologies()));
        this.localityCheckerSignatureModel.init();
        this.localityCheckResultButton.addActionListener(new LocalityResultActionListener());
        this.showMessageRuntimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)this.owlEditorKit.getOWLWorkspace());
        this.localityChecker = new LocalityCheckerActionListener(this.owlEditorKit, this.localityCheckerSignature, this.localityCheckResultButton, this.showMessageRuntimeExceptionHandler);
        this.localityCheckButton.addActionListener(this.localityChecker);
        this.localityCheckPreferenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MList list = new MList(){
                    private static final long serialVersionUID = 20100L;

                    protected List<MListButton> getButtons(Object value) {
                        return super.getButtons(value);
                    }

                    protected void handleAdd() {
                        OWLEntity toAdd;
                        OWLEntitySelector oes = new OWLEntitySelector(PatternInstantiationEditor.this.owlEditorKit);
                        int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)this.getParent(), (String)"Add an entity to the signature", (JComponent)oes, (int)-1, (int)2, (JComponent)oes);
                        if (ret == 0 && (toAdd = oes.getOWLClass()) != null) {
                            PatternInstantiationEditor.this.localityCheckerSignature.add(toAdd);
                        }
                        PatternInstantiationEditor.this.localityCheckerSignatureModel.init();
                    }

                    protected void handleDelete() {
                        PatternInstantiationEditor.this.localityCheckerSignature.remove(((VariableListModel.VariableListItem)this.getSelectedValue()).getItem());
                        PatternInstantiationEditor.this.localityCheckerSignatureModel.init();
                    }
                };
                list.setModel(PatternInstantiationEditor.this.localityCheckerSignatureModel);
                list.setCellRenderer((ListCellRenderer)((Object)new RenderableObjectCellRenderer(PatternInstantiationEditor.this.owlEditorKit)));
                JScrollPane pane = ComponentFactory.createScrollPane((JComponent)list);
                VerifyingOptionPane optionPane = new VerifyingOptionPane((JComponent)pane);
                JDialog dlg = optionPane.createDialog((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace(), null);
                dlg.setModal(false);
                dlg.setTitle("Current signature");
                dlg.setResizable(true);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace());
                dlg.setVisible(true);
            }
        });
        this.buttonPanel = new JPanel(new BorderLayout());
        this.buttonPanel.add((Component)this.localityCheckResultButton, "West");
        this.buttonPanel.add((Component)this.localityCheckButton, "Center");
        this.buttonPanel.add((Component)this.localityCheckPreferenceButton, "East");
        this.buttonPanel.add((Component)this.reasonerWarning, "South");
        this.checkReasoner();
        this.localityCheckerSignatureModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                PatternInstantiationEditor.this.handleChange();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                PatternInstantiationEditor.this.handleChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                PatternInstantiationEditor.this.handleChange();
            }
        });
        this.setup();
    }

    private void setup() {
        this.mainPane.setPreferredSize(new Dimension(500, 600));
        this.refillPatternList();
        this.patternList.setPreferredSize(new Dimension(50, 20));
        this.patternList.addActionListener(new PatternListActionListener(this));
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(ComponentFactory.createTitledBorder((String)"Pattern:"));
        namePanel.add((Component)ComponentFactory.createScrollPane((JComponent)this.patternList), "North");
        this.problemPanel.setBorder(ComponentFactory.createTitledBorder((String)"Problems"));
        this.problemPanel.add(ComponentFactory.createScrollPane(this.problemList));
        namePanel.add((Component)this.problemPanel, "South");
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.add(namePanel);
        this.instantiationPanel = new JSplitPane(1);
        this.instantiationPanel.setBorder(ComponentFactory.createTitledBorder((String)"Variables:"));
        this.instantiationPanel.setDividerLocation(0.5);
        this.variableList = new VariableList(this.owlEditorKit, (ConstraintSystem)this.factory.createConstraintSystem());
        this.valueList = new VariableValuesMList();
        this.variablePane = ComponentFactory.createScrollPane((JComponent)((Object)this.variableList));
        this.instantiationPanel.add((Component)this.variablePane, "left");
        this.valuePane = ComponentFactory.createScrollPane((JComponent)((Object)this.valueList));
        this.instantiationPanel.add((Component)this.valuePane, "right");
        this.effectsBorder = new JPanel(new BorderLayout());
        this.effectsBorder.setBorder(ComponentFactory.createTitledBorder((String)"Effects: "));
        this.actionList = new ActionList(this.owlEditorKit, (ConstraintSystem)(this.instantiatedPatternModel == null ? this.factory.createConstraintSystem() : this.instantiatedPatternModel.getConstraintSystem()), false);
        this.effectsBorder.add((Component)ComponentFactory.createScrollPane((JComponent)((Object)this.actionList)), "Center");
        this.mainPane.add((Component)editorPanel, "North");
        JSplitPane centerPane = new JSplitPane(0);
        centerPane.add((Component)this.instantiationPanel, "top");
        centerPane.add((Component)this.effectsBorder, "bottom");
        centerPane.setDividerLocation(0.5);
        this.mainPane.add((Component)centerPane, "Center");
        this.mainPane.add((Component)this.buttonPanel, "South");
        this.localityCheckButton.setEnabled(false);
    }

    private void refillPatternList() {
        this.patternListModel.removeAllElements();
        Set existingPatternNames = Utils.getExistingPatternNames((OWLOntologyManager)this.owlEditorKit.getModelManager().getOWLOntologyManager());
        this.patternList.setRenderer(new InstantiatedPatternCellRenderer());
        for (String string : existingPatternNames) {
            PatternModel patternModel = Utils.find((String)string, (OWLOntologyManager)this.owlEditorKit.getModelManager().getOWLOntologyManager(), (AbstractPatternModelFactory)this.factory);
            if (patternModel == null) continue;
            InstantiatedPatternModel toAdd = this.factory.createInstantiatedPatternModel(patternModel, (RuntimeExceptionHandler)this.showMessageRuntimeExceptionHandler);
            this.patternListModel.addElement(toAdd);
            this.patternList.setSelectedItem(null);
        }
    }

    public boolean setEditedObject(InstantiatedPatternModel editedObject) {
        this.setInstantiatedPatternModel(editedObject);
        return true;
    }

    public void dispose() {
        this.valueList.getModel().removeListDataListener(this);
        this.variableList.removeListSelectionListener(this);
    }

    public InstantiatedPatternModel getEditedObject() {
        return this.instantiatedPatternModel;
    }

    public JComponent getEditorComponent() {
        return this.mainPane;
    }

    private void notifyListener(boolean newState, InputVerificationStatusChangedListener listener) {
        listener.verifiedStatusChanged(newState);
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListener(this.check(), listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void refreshEffectsPanel() {
        this.actionList.getDefaultModel().clear();
        if (this.instantiatedPatternModel != null) {
            this.actionList.setConstraintSystem((ConstraintSystem)this.instantiatedPatternModel.getConstraintSystem());
            PatternModel instantiatedPattern = this.instantiatedPatternModel.getInstantiatedPattern();
            List actions = instantiatedPattern.getActions();
            HashSet<AddAxiom> changes = new HashSet<AddAxiom>(actions.size());
            Set bindingNodes = this.instantiatedPatternModel.extractBindingNodes();
            if (bindingNodes.isEmpty()) {
                BindingNode bindingNode = new BindingNode((Collection)instantiatedPattern.getInputVariables());
                SimpleValueComputationParameters simpleValueComputationParameters = new SimpleValueComputationParameters((ConstraintSystem)this.instantiatedPatternModel.getConstraintSystem(), bindingNode, (RuntimeExceptionHandler)this.showMessageRuntimeExceptionHandler);
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)simpleValueComputationParameters);
                for (OWLAxiomChange change : actions) {
                    OWLAxiom axiom = change.getAxiom();
                    OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instantiator);
                    AddAxiom newAxiomChange = change.isAddAxiom() ? new AddAxiom(change.getOntology(), instantiatedAxiom) : new RemoveAxiom(change.getOntology(), instantiatedAxiom);
                    changes.add(newAxiomChange);
                }
            } else {
                this.instantiatedPatternModel.getConstraintSystem().setLeaves((Collection)bindingNodes);
                for (BindingNode bindingNode : bindingNodes) {
                    SimpleValueComputationParameters parameters = new SimpleValueComputationParameters((ConstraintSystem)this.instantiatedPatternModel.getConstraintSystem(), bindingNode, (RuntimeExceptionHandler)this.showMessageRuntimeExceptionHandler);
                    PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)parameters);
                    for (OWLAxiomChange change : actions) {
                        OWLAxiom axiom = change.getAxiom();
                        OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instantiator);
                        AddAxiom newAxiomChange = change.isAddAxiom() ? new AddAxiom(change.getOntology(), instantiatedAxiom) : new RemoveAxiom(change.getOntology(), instantiatedAxiom);
                        changes.add(newAxiomChange);
                    }
                }
            }
            for (OWLAxiomChange oWLAxiomChange : changes) {
                this.actionList.getDefaultModel().addElement(new ActionListItem(oWLAxiomChange, false, false));
            }
        }
        this.handleChange();
        this.mainPane.revalidate();
    }

    protected void refreshInstantiationPanel() {
        DefaultListModel<Object> model = this.variableList.getDefaultModel();
        model.clear();
        this.valueList.getDefaultModel().clear();
        if (this.instantiatedPatternModel != null) {
            List inputVariables = this.instantiatedPatternModel.getInputVariables();
            for (InputVariable inputVariable : inputVariables) {
                model.addElement(new VariableListItem((Variable)inputVariable, (ConstraintSystem)this.instantiatedPatternModel.getConstraintSystem(), this.owlEditorKit, false, false){

                    @Override
                    public String getTooltip() {
                        return this.getVariable().toString();
                    }
                });
            }
            this.variableList.addListSelectionListener(this);
            if (this.instantantiatedPatternModel2CopyFrom != null) {
                for (InputVariable inputVariable : inputVariables) {
                    Set instantiations = this.instantantiatedPatternModel2CopyFrom.getInstantiations((Variable)inputVariable);
                    if (instantiations == null) continue;
                    for (OWLObject object : instantiations) {
                        this.instantiatedPatternModel.instantiate((Variable)inputVariable, object);
                    }
                }
                this.instantantiatedPatternModel2CopyFrom = null;
            }
        }
    }

    void checkReasoner() {
        if (this.owlEditorKit.getOWLModelManager().getReasoner() instanceof NoOpReasoner) {
            this.reasonerWarning.setText("Warning: no reasoner selected.");
        } else {
            this.reasonerWarning.setText("");
        }
    }

    public void handleChange() {
        this.checkReasoner();
        boolean newState = this.check();
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            this.notifyListener(newState, listener);
        }
        this.localityCheckButton.removeActionListener(this.localityChecker);
        this.localityChecker = new LocalityCheckerActionListener(this.owlEditorKit, this.localityCheckerSignature, this.localityCheckResultButton, this.showMessageRuntimeExceptionHandler);
        this.localityCheckButton.addActionListener(this.localityChecker);
        this.localityChecker.setInstantiatedPatternModel(this.instantiatedPatternModel);
        if (this.instantiatedPatternModel != null) {
            this.localityCheckButton.setEnabled(true);
        } else {
            this.localityCheckButton.setEnabled(false);
        }
        this.problemPanel.setVisible(!this.problemListModel.isEmpty());
    }

    private boolean check() {
        boolean valid = this.instantiatedPatternModel != null ? this.instantiatedPatternModel.isValid() : false;
        return valid;
    }

    public void setInstantiatedPatternModel(InstantiatedPatternModel patternModel) {
        this.mainPane.removeAll();
        this.setup();
        if (patternModel != null) {
            this.instantantiatedPatternModel2CopyFrom = patternModel;
            boolean found = false;
            for (int i = 0; i < this.patternListModel.getSize() && !found; ++i) {
                Object element = this.patternListModel.getElementAt(i);
                boolean bl = found = element instanceof InstantiatedPatternModel && patternModel.getName().equals(((InstantiatedPatternModel)element).getName());
                if (!found) continue;
                this.patternList.setSelectedItem(element);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshEffectsPanel();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.refreshEffectsPanel();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.refreshEffectsPanel();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selectedValue = this.variableList.getSelectedValue();
        this.valueList.getModel().removeListDataListener(this);
        this.instantiationPanel.remove(this.variablePane);
        this.instantiationPanel.remove(this.valuePane);
        if (selectedValue instanceof VariableListItem) {
            VariableListItem item = (VariableListItem)selectedValue;
            Variable<?> variable = item.getVariable();
            this.valueList = new VariableValuesMList(variable);
            this.valueList.getModel().addListDataListener(this);
            Set instantiations = this.instantiatedPatternModel.getInstantiations(variable);
            if (instantiations != null) {
                for (OWLObject object : instantiations) {
                    this.valueList.getDefaultModel().addElement(new VariableValueListItem((Variable)variable, object){

                        @Override
                        public String getTooltip() {
                            return this.getVariable().toString();
                        }
                    });
                }
            }
            this.valuePane = ComponentFactory.createScrollPane((JComponent)((Object)this.valueList));
        }
        this.instantiationPanel.add((Component)this.variablePane, "left");
        this.instantiationPanel.add((Component)this.valuePane, "right");
        this.mainPane.revalidate();
    }

    public String getEditorTypeName() {
        return "Instantiated Pattern Editor";
    }

    public boolean canEdit(Object object) {
        return true;
    }

    private final class LocalityResultActionListener
    implements ActionListener {
        LocalityResultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = new JTable(PatternInstantiationEditor.this.localityChecker.print());
            table.setGridColor(Color.black);
            table.setDefaultRenderer(String.class, new TableCellRenderer(){
                private final JLabel safeFalse;
                private final JLabel safeTrue;
                private final JCheckBox present;
                private final JCheckBox absent;
                {
                    this.safeFalse = new JLabel(PatternInstantiationEditor.this.localityChecker.generateIcon(Color.red));
                    this.safeTrue = new JLabel(PatternInstantiationEditor.this.localityChecker.generateIcon(Color.green));
                    this.present = new JCheckBox("", true);
                    this.absent = new JCheckBox("", false);
                }

                @Override
                public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value.equals(Boolean.toString(false))) {
                        return this.safeFalse;
                    }
                    if (value.equals(Boolean.toString(true))) {
                        return this.safeTrue;
                    }
                    if (value.equals("X")) {
                        return this.present;
                    }
                    return this.absent;
                }
            });
            JScrollPane report = ComponentFactory.createScrollPane((JComponent)table);
            VerifyingOptionPane optionPane = new VerifyingOptionPane((JComponent)report);
            JDialog dlg = optionPane.createDialog((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(false);
            dlg.setTitle("Safety analysis breakdown");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace());
            dlg.setVisible(true);
        }
    }

    private static final class InstantiatedPatternCellRenderer
    implements ListCellRenderer {
        private static final DefaultListCellRenderer DELEGATE = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component toReturn = DELEGATE.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof InstantiatedPatternModel) {
                InstantiatedPatternModel instantiatedPatternModel = (InstantiatedPatternModel)value;
                StringWriter writer = new StringWriter();
                writer.append(instantiatedPatternModel.getName());
                writer.append("(");
                List inputVariables = instantiatedPatternModel.getInputVariables();
                boolean first = true;
                for (Variable inputVariable : inputVariables) {
                    String comma = first ? "" : ", ";
                    first = first ? false : first;
                    writer.append(comma);
                    writer.append(inputVariable.getName());
                }
                writer.append(")");
                toReturn = DELEGATE.getListCellRendererComponent((JList<?>)list, writer.toString(), index, isSelected, cellHasFocus);
            }
            return toReturn;
        }
    }

    private class VariableValueListItem
    implements MListItem {
        private final Variable<?> variable;
        private final OWLObject value;

        public VariableValueListItem(Variable<?> variable, OWLObject value) {
            this.variable = variable;
            this.value = value;
        }

        public String getTooltip() {
            return PatternInstantiationEditor.this.owlEditorKit.getModelManager().getRendering(this.value);
        }

        public boolean handleDelete() {
            return true;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return true;
        }

        public boolean isEditable() {
            return false;
        }

        public Variable<?> getVariable() {
            return this.variable;
        }

        public OWLObject getValue() {
            return this.value;
        }
    }

    private class VariableValuesMList
    extends OPPLMList {
        private static final long serialVersionUID = 20100L;
        protected final Variable<?> variable;

        protected void handleAdd() {
            final VariableValueEditor variableValueEditor = VariableValueEditor.getVariableValueEditor(PatternInstantiationEditor.this.owlEditorKit, this.variable);
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(variableValueEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            variableValueEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle(variableValueEditor.getTitle());
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternInstantiationEditor.this.owlEditorKit.getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        Set<OWLObject> variableValues = variableValueEditor.getVariableValues();
                        for (OWLObject object : variableValues) {
                            PatternInstantiationEditor.this.instantiatedPatternModel.instantiate(VariableValuesMList.this.variable, object);
                            VariableValuesMList.this.getDefaultModel().addElement(new VariableValueListItem(VariableValuesMList.this.variable, object));
                        }
                    }
                    variableValueEditor.removeStatusChangedListener(verificationListener);
                    variableValueEditor.dispose();
                }
            });
            dlg.setVisible(true);
        }

        VariableValuesMList() {
            this.variable = null;
            DefaultListModel<3> model = new DefaultListModel<3>();
            super.setModel(model);
            model.addElement(new MListSectionHeader(){

                public boolean canAdd() {
                    return false;
                }

                public String getName() {
                    return "No pattern selected yet";
                }
            });
            this.setCellRenderer(new SpecializedListCellRenderer(PatternInstantiationEditor.this.owlEditorKit));
        }

        public VariableValuesMList(Variable<?> variable) {
            this.variable = variable;
            DefaultListModel<4> model = new DefaultListModel<4>();
            super.setModel(model);
            model.addElement(new MListSectionHeader(){

                public boolean canAdd() {
                    return true;
                }

                public String getName() {
                    return VariableValuesMList.this.variable.getName();
                }
            });
            this.setCellRenderer(new SpecializedListCellRenderer(PatternInstantiationEditor.this.owlEditorKit));
        }

        protected void handleDelete() {
            if (this.getSelectedValue() instanceof VariableValueListItem) {
                VariableValueListItem item = (VariableValueListItem)this.getSelectedValue();
                Variable<?> v = item.getVariable();
                OWLObject value = item.getValue();
                PatternInstantiationEditor.this.instantiatedPatternModel.removeInstantiation(v, value);
            }
            this.getDefaultModel().removeElement(this.getSelectedValue());
            super.handleDelete();
        }
    }

    static final class SpecializedListCellRenderer
    implements ListCellRenderer {
        private final OWLCellRenderer owlCellRenderer;

        public SpecializedListCellRenderer(OWLEditorKit kit) {
            this.owlCellRenderer = new OWLCellRenderer(kit);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VariableValueListItem) {
                return this.owlCellRenderer.getListCellRendererComponent(list, (Object)((VariableValueListItem)value).getValue(), index, isSelected, cellHasFocus);
            }
            return this.owlCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private final class PatternListActionListener
    implements ActionListener {
        final PatternInstantiationEditor pie;

        public PatternListActionListener(PatternInstantiationEditor _this) {
            this.pie = _this;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.pie.instantiatedPatternModel = null;
            Object selectedItem = this.pie.patternList.getSelectedItem();
            if (selectedItem instanceof InstantiatedPatternModel) {
                this.pie.instantiatedPatternModel = (InstantiatedPatternModel)selectedItem;
                if (this.pie.owlClass != null) {
                    this.pie.instantiatedPatternModel.instantiate(this.pie.instantiatedPatternModel.getConstraintSystem().getThisClassVariable(), (OWLObject)PatternInstantiationEditor.this.owlClass);
                }
                this.pie.refreshInstantiationPanel();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PatternListActionListener.this.pie.refreshEffectsPanel();
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PatternListActionListener.this.pie.handleChange();
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PatternListActionListener.this.pie.variableList.setSelectedIndex(0);
                    }
                });
                this.pie.handleChange();
            }
        }
    }
}

