/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.coode.oppl.utils.ArgCheck;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.PatternModel;
import org.coode.patterns.protege.ui.PatternBuilder;
import org.coode.patterns.protege.ui.TypeInPatternBuilder;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public class PatternEditor
extends AbstractOWLObjectEditor<PatternModel>
implements VerifiedInputEditor,
ChangeListener {
    protected final JTabbedPane mainPanel = new JTabbedPane();
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    protected final PatternBuilder patternBuilder;
    protected final TypeInPatternBuilder patternTextEditor;
    protected PatternModel patternModel = null;
    private final OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            PatternEditor.this.mainPanel.setSelectedComponent(PatternEditor.this.patternBuilder.getEditorComponent());
        }
    };
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            PatternEditor.this.mainPanel.setSelectedComponent(PatternEditor.this.patternBuilder.getEditorComponent());
        }
    };
    private final OWLEditorKit owlEditorKit;

    public PatternEditor(OWLEditorKit owlEditorKit, AbstractPatternModelFactory f) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.patternBuilder = new PatternBuilder(this.getOWLEditorKit(), (AbstractPatternModelFactory)ArgCheck.checkNotNull((Object)f, (String)"f"));
        this.patternTextEditor = new TypeInPatternBuilder(this.getOWLEditorKit());
        this.patternBuilder.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                PatternEditor.this.patternModel = null;
                if (newState) {
                    PatternEditor.this.patternModel = PatternEditor.this.patternBuilder.getEditedObject();
                }
                PatternEditor.this.handleChange();
            }
        });
        this.patternTextEditor.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                PatternEditor.this.patternModel = null;
                if (newState) {
                    PatternEditor.this.patternModel = PatternEditor.this.patternTextEditor.getEditedObject();
                }
                PatternEditor.this.handleChange();
            }
        });
        this.mainPanel.addChangeListener(this);
        this.getOWLEditorKit().getOWLModelManager().addListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().addOntologyChangeListener(this.ontologyChangeListener);
        this.initGUI();
        this.handleChange();
    }

    protected void handleChange() {
        boolean newState = this.patternModel != null;
        this.notifyListeners(newState);
    }

    private void notifyListeners(boolean newState) {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(newState);
        }
    }

    private void initGUI() {
        this.mainPanel.add(this.patternBuilder.getEditorComponent());
        this.mainPanel.add(this.patternTextEditor.getEditorComponent());
        this.mainPanel.setPreferredSize(new Dimension(600, 700));
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        ((InputVerificationStatusChangedListener)ArgCheck.checkNotNull((Object)listener, (String)"listener")).verifiedStatusChanged(this.patternModel != null);
        this.listeners.add(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
        this.patternBuilder.dispose();
        this.patternTextEditor.dispose();
        this.getOWLEditorKit().getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().removeOntologyChangeListener(this.ontologyChangeListener);
    }

    public PatternModel getEditedObject() {
        return this.patternModel;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.mainPanel.getSelectedComponent();
        if (this.patternModel != null) {
            if (selectedComponent.equals(this.patternBuilder.getEditorComponent())) {
                this.patternBuilder.setPatternModel(this.patternModel);
            }
            if (selectedComponent.equals(this.patternTextEditor.getEditorComponent())) {
                this.patternTextEditor.setPatternModel(this.patternModel);
            }
        }
    }

    public void setPatternModel(PatternModel patternModel) {
        this.patternTextEditor.setPatternModel(patternModel);
        this.patternBuilder.setPatternModel(patternModel);
    }

    public boolean canEdit(Object object) {
        return true;
    }

    public String getEditorTypeName() {
        return "Pattern model editor";
    }

    public boolean setEditedObject(PatternModel editedObject) {
        this.setPatternModel(editedObject);
        return true;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }
}

