/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.protege.ProtegeInstantiatedPatternModel;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.coode.patterns.protege.ui.PatternInstantiationEditor;
import org.coode.patterns.utils.Utils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class PatternClassFrameSectionRow
extends AbstractOWLFrameSectionRow<OWLClass, OWLAnnotationAssertionAxiom, InstantiatedPatternModel> {
    private final InstantiatedPatternModel patternModel;
    private final AbstractPatternModelFactory factory;

    protected PatternClassFrameSectionRow(OWLEditorKit owlEditorKit, OWLFrameSection<OWLClass, OWLAnnotationAssertionAxiom, InstantiatedPatternModel> section, OWLOntology ontology, OWLClass rootObject, OWLAnnotationAssertionAxiom axiom, AbstractPatternModelFactory f) {
        super(owlEditorKit, section, ontology, (Object)rootObject, (OWLAxiom)axiom);
        this.factory = f;
        PatternExtractor patternExtractor = this.factory.getPatternExtractor(ProtegeParserFactory.getDefaultErrorListener());
        OWLAnnotation annotation = axiom.getAnnotation();
        this.patternModel = (InstantiatedPatternModel)annotation.accept((OWLObjectVisitorEx)patternExtractor);
    }

    protected OWLAnnotationAssertionAxiom createAxiom(InstantiatedPatternModel editedObject) {
        OWLDataFactory dataFactory = this.getOWLDataFactory();
        OWLLiteral constant = dataFactory.getOWLLiteral(editedObject.toString());
        IRI annotationIRI = IRI.create((String)("http://www.co-ode.org/patterns#" + editedObject.getInstantiatedPatternLocalName() + "PatternInstantiation"));
        OWLAnnotation annotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)constant);
        return this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)((OWLClass)this.getRootObject()).getIRI(), annotation);
    }

    protected OWLObjectEditor<InstantiatedPatternModel> getObjectEditor() {
        PatternInstantiationEditor editor = new PatternInstantiationEditor(this.getOWLEditorKit(), (OWLClass)this.getRootObject(), this.factory);
        OWLAnnotationAssertionAxiom annotationAxiom = (OWLAnnotationAssertionAxiom)this.getManipulatableObjects().iterator().next();
        PatternExtractor patternExtractor = this.factory.getPatternExtractor(ProtegeParserFactory.getDefaultErrorListener());
        OWLAnnotation annotation = annotationAxiom.getAnnotation();
        editor.setInstantiatedPatternModel((ProtegeInstantiatedPatternModel)((Object)annotation.accept((OWLObjectVisitorEx)patternExtractor)));
        return editor;
    }

    public List<? extends OWLObject> getManipulatableObjects() {
        return new ArrayList<OWLAxiom>(Collections.singleton(this.axiom));
    }

    public List<? extends OWLOntologyChange> getDeletionChanges() {
        ArrayList<RemoveAxiom> deletionChanges = new ArrayList<RemoveAxiom>(super.getDeletionChanges());
        Set axioms = this.getOntology().getAxioms();
        for (OWLAxiom ax : axioms) {
            Set annotationAxioms = ax.getAnnotations();
            if (!Utils.isPatternGenerated((String)this.patternModel.getInstantiatedPatternLocalName(), (Collection)annotationAxioms)) continue;
            deletionChanges.add(new RemoveAxiom(this.getOntology(), ax));
        }
        return deletionChanges;
    }

    public void handleEditingFinished(Set<InstantiatedPatternModel> editedObjects) {
        Iterator<InstantiatedPatternModel> it = editedObjects.iterator();
        boolean found = false;
        InstantiatedPatternModel instantiatedPatternModel = null;
        while (!found && it.hasNext()) {
            instantiatedPatternModel = it.next();
            boolean bl = found = instantiatedPatternModel.hasScopedVariables() && this.getOWLEditorKit().getModelManager().getReasoner() instanceof NoOpReasoner;
            if (found) {
                JOptionPane.showMessageDialog((Component)this.getOWLEditorKit().getWorkspace(), "The pattern model " + instantiatedPatternModel.getName() + " has got scoped variables but you are curently using a NoOpReasoner, the pattern will not work properly unless you activate reasoning.", "No Reasoner", 0);
                continue;
            }
            super.handleEditingFinished(editedObjects);
        }
    }

    public InstantiatedPatternModel getPatternModel() {
        return this.patternModel;
    }
}

