/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Component;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternOPPLScript;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.coode.patterns.protege.ui.PatternClassFrameSectionRow;
import org.coode.patterns.protege.ui.PatternInstantiationEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class PatternClassFrameSection
extends AbstractOWLFrameSection<OWLClass, OWLAnnotationAssertionAxiom, InstantiatedPatternModel> {
    private static final String LABEL = "Patterns";
    private final AbstractPatternModelFactory factory;

    protected PatternClassFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLClass> frame, AbstractPatternModelFactory f) {
        super(editorKit, LABEL, frame);
        this.factory = f;
    }

    public boolean canAdd() {
        return true;
    }

    protected void clear() {
    }

    public Comparator<OWLFrameSectionRow<OWLClass, OWLAnnotationAssertionAxiom, InstantiatedPatternModel>> getRowComparator() {
        return null;
    }

    protected OWLAnnotationAssertionAxiom createAxiom(InstantiatedPatternModel instantiatedPattern) {
        OWLDataFactory dataFactory = this.getOWLDataFactory();
        OWLLiteral constant = dataFactory.getOWLLiteral(instantiatedPattern.toString());
        IRI annotationIRI = IRI.create((String)("http://www.co-ode.org/patterns#" + instantiatedPattern.getInstantiatedPatternLocalName() + "PatternInstantiation"));
        OWLAnnotation annotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)constant);
        OWLAnnotationAssertionAxiom axiom = this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)((OWLClass)this.getRootObject()).getIRI(), annotation);
        return axiom;
    }

    public OWLObjectEditor<InstantiatedPatternModel> getObjectEditor() {
        return new PatternInstantiationEditor(this.getOWLEditorKit(), (OWLClass)this.getRootObject(), this.factory);
    }

    protected void refill(OWLOntology ontology) {
        OWLClass rootObject = (OWLClass)this.getRootObject();
        Set annotationAxioms = rootObject.getAnnotationAssertionAxioms(ontology);
        PatternExtractor patternExtractor = this.factory.getPatternExtractor(ProtegeParserFactory.getDefaultErrorListener());
        for (OWLAnnotationAssertionAxiom annotationAxiom : annotationAxioms) {
            OWLAnnotation annotation = annotationAxiom.getAnnotation();
            PatternOPPLScript statementModel = (PatternOPPLScript)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            if (statementModel == null) continue;
            PatternClassFrameSectionRow row = new PatternClassFrameSectionRow(this.getOWLEditorKit(), (OWLFrameSection<OWLClass, OWLAnnotationAssertionAxiom, InstantiatedPatternModel>)this, ontology, (OWLClass)this.getRootObject(), annotationAxiom, this.factory);
            this.addRow((OWLFrameSectionRow)row);
        }
    }

    protected void refillInferred() throws OWLRuntimeException {
    }

    public void visit(OWLAnnotationAssertionAxiom annotationAxiom) {
        if (annotationAxiom.getSubject().equals(((OWLClass)this.getRootObject()).getIRI())) {
            PatternExtractor patternExtractor = this.factory.getPatternExtractor(ProtegeParserFactory.getDefaultErrorListener());
            OWLAnnotation annotation = annotationAxiom.getAnnotation();
            if (annotation.accept((OWLObjectVisitorEx)patternExtractor) != null) {
                this.reset();
            }
        }
    }

    public void handleEditingFinished(Set<InstantiatedPatternModel> editedObjects) {
        Iterator<InstantiatedPatternModel> it = editedObjects.iterator();
        boolean found = false;
        InstantiatedPatternModel instantiatedPatternModel = null;
        while (!found && it.hasNext()) {
            instantiatedPatternModel = it.next();
            boolean bl = found = instantiatedPatternModel.hasScopedVariables() && this.getOWLEditorKit().getModelManager().getReasoner() instanceof NoOpReasoner;
            if (found) {
                JOptionPane.showConfirmDialog((Component)this.getOWLEditorKit().getWorkspace(), "The pattern model " + instantiatedPatternModel.getName() + " has got scoped variables but you are curently using a NoOpReasoner, the pattern will not work properly unless you activate reasoning.", "No Reasoner", 0);
                continue;
            }
            super.handleEditingFinished(editedObjects);
        }
    }
}

