/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternOPPLScript;
import org.coode.patterns.protege.ProtegeParserFactory;
import org.coode.patterns.protege.ui.PatternClassFrameSectionRow;
import org.coode.patterns.protege.ui.PatternModelList;
import org.coode.patterns.protege.ui.PatternOWLEquivalentClassesAxiomFrameSectionRow;
import org.coode.patterns.protege.ui.PatternOWLSubClassAxiomFrameSectionRow;
import org.coode.patterns.utils.Utils;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class PatternCellRenderer
implements ListCellRenderer {
    private final OWLEditorKit owlEditorKit;
    private final OWLCellRenderer owlCellRenderer;

    public PatternCellRenderer(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.owlCellRenderer = new OWLCellRenderer(this.owlEditorKit);
        this.owlCellRenderer.setHighlightKeywords(true);
        this.owlCellRenderer.setWrap(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OWLSubClassOfAxiom annotationAxiom;
        Set annotations;
        JPanel toReturn = new JPanel(new FlowLayout());
        PatternExtractor patternExtractor = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getPatternFactory().getPatternExtractor(ProtegeParserFactory.getDefaultErrorListener());
        if (value instanceof PatternClassFrameSectionRow) {
            JLabel valueRendering = new JLabel();
            OWLAnnotationAssertionAxiom annotationAxAnnotation = (OWLAnnotationAssertionAxiom)((PatternClassFrameSectionRow)((Object)value)).getAxiom();
            OWLAnnotation annotation = annotationAxAnnotation.getAnnotation();
            PatternOPPLScript patternModel = (PatternOPPLScript)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            if (patternModel != null) {
                valueRendering.setText(patternModel.getRendering());
            } else {
                valueRendering.setText(value.toString());
            }
            toReturn.add(valueRendering);
        } else if (value instanceof PatternModelList.PatternListItem) {
            PatternModelList.PatternListItem row = (PatternModelList.PatternListItem)((Object)value);
            OWLAnnotation annotation = row.getAnnotation();
            PatternModel patternModel = (PatternModel)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            if (patternModel != null) {
                String rendering = patternModel.getRendering();
                if (rendering == null) {
                    StringBuilder b = new StringBuilder(patternModel.getName());
                    b.append("(");
                    List variableList = patternModel.getInputVariables();
                    for (int i = 0; i < variableList.size(); ++i) {
                        if (i > 0) {
                            b.append(" , ");
                        }
                        b.append(((InputVariable)variableList.get(i)).getName());
                    }
                    b.append(")");
                    rendering = b.toString();
                }
                toReturn.add(new JLabel(rendering));
            } else {
                toReturn.add(new JLabel(value.toString()));
            }
        } else if (value instanceof PatternOWLEquivalentClassesAxiomFrameSectionRow) {
            OWLEquivalentClassesAxiom annotationAxiom2 = (OWLEquivalentClassesAxiom)((PatternOWLEquivalentClassesAxiomFrameSectionRow)((Object)value)).getAxiom();
            Set annotations2 = annotationAxiom2.getAnnotations();
            if (Utils.isPatternGenerated((Collection)annotations2)) {
                HashSet descriptions = new HashSet(annotationAxiom2.getClassExpressions());
                descriptions.remove(((PatternOWLEquivalentClassesAxiomFrameSectionRow)((Object)value)).getRoot());
                return this.owlCellRenderer.getListCellRendererComponent(list, descriptions.iterator().next(), index, isSelected, cellHasFocus);
            }
        } else if (value instanceof PatternOWLSubClassAxiomFrameSectionRow && Utils.isPatternGenerated((Collection)(annotations = (annotationAxiom = (OWLSubClassOfAxiom)((PatternOWLSubClassAxiomFrameSectionRow)((Object)value)).getAxiom()).getAnnotations()))) {
            return this.owlCellRenderer.getListCellRendererComponent(list, (Object)annotationAxiom.getSuperClass(), index, isSelected, cellHasFocus);
        }
        return toReturn;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }
}

