/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.protege.ui.AbstractVariableEditor;
import org.coode.oppl.protege.ui.ActionList;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.ActionListModel;
import org.coode.oppl.protege.ui.GeneratedVariableEditor;
import org.coode.oppl.protege.ui.GeneratedVariableSectionHeader;
import org.coode.oppl.protege.ui.InputVariableSectionHeader;
import org.coode.oppl.protege.ui.NoDefaultFocusVerifyingOptionPane;
import org.coode.oppl.protege.ui.OWLAxiomChangeEditor;
import org.coode.oppl.protege.ui.RegExpVariableEditor;
import org.coode.oppl.protege.ui.VariableEditor;
import org.coode.oppl.protege.ui.VariableList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.protege.ui.message.Error;
import org.coode.oppl.protege.ui.message.MessageListCellRenderer;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.EmptyActionListException;
import org.coode.patterns.EmptyVariableListException;
import org.coode.patterns.HasPatternModel;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternModelChangeListener;
import org.coode.patterns.UnsuitableOPPLScriptException;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObject;

public class PatternBuilder
extends AbstractOWLObjectEditor<PatternModel>
implements VerifiedInputEditor,
PatternModelChangeListener,
HasPatternModel,
Serializable {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    protected final OWLEditorKit owlEditorKit;
    protected PatternModel patternModel = null;
    private final JPanel mainPanel = new JPanel();
    protected final PatternVariableList variableList;
    protected final ActionList actionList;
    protected final JTextField nameEditor = new JTextField();
    private final JTextField rendering = new JTextField();
    protected final JCheckBox allowReturnValueCheckBox;
    protected final DefaultComboBoxModel<Object> returnValueListModel = new DefaultComboBoxModel();
    protected final JComboBox<Object> returnValuesComboBox = new JComboBox<Object>(this.returnValueListModel);
    protected final PatternBuilderModel patternBuilderModel;
    private final JPanel errorPanel = new JPanel(new BorderLayout());
    protected final DefaultListModel<Object> errorListModel = new DefaultListModel();
    private final JList<Object> errorList = new JList<Object>(this.errorListModel);
    private final AbstractPatternModelFactory factory;
    private final JSplitPane patternBodyPanel;

    public PatternBuilder(OWLEditorKit owlEditorKit, AbstractPatternModelFactory f) {
        this.factory = f;
        this.patternBuilderModel = new PatternBuilderModel(this.factory);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setName("Pattern Builder");
        this.errorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Errors:"));
        this.errorPanel.add(ComponentFactory.createScrollPane(this.errorList));
        this.errorPanel.setPreferredSize(new Dimension(200, 75));
        this.errorList.setCellRenderer(new MessageListCellRenderer());
        JPanel builderPanel = new JPanel(new BorderLayout());
        this.owlEditorKit = owlEditorKit;
        this.nameEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PatternBuilder.this.patternBuilderModel.setName(PatternBuilder.this.nameEditor.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PatternBuilder.this.patternBuilderModel.setName(PatternBuilder.this.nameEditor.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PatternBuilder.this.patternBuilderModel.setName(PatternBuilder.this.nameEditor.getText());
            }
        });
        JPanel patternNamePanel = new JPanel(new BorderLayout());
        patternNamePanel.add(this.nameEditor);
        patternNamePanel.setBorder(ComponentFactory.createTitledBorder((String)"Pattern name"));
        builderPanel.add((Component)patternNamePanel, "North");
        this.removeKeyListeners();
        this.patternBodyPanel = new JSplitPane(0);
        this.variableList = new PatternVariableList(this.owlEditorKit);
        this.actionList = new PatternBuilderActionList();
        JScrollPane variablePane = ComponentFactory.createScrollPane((JComponent)((Object)this.variableList));
        this.patternBodyPanel.add((Component)variablePane, "top");
        this.patternBodyPanel.add((Component)ComponentFactory.createScrollPane((JComponent)((Object)this.actionList)), "bottom");
        builderPanel.add((Component)this.patternBodyPanel, "Center");
        this.patternBodyPanel.setResizeWeight(0.5);
        this.rendering.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PatternBuilder.this.renderingUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PatternBuilder.this.renderingUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PatternBuilder.this.renderingUpdate();
            }
        });
        JPanel renderingPanelBorder = new JPanel(new BorderLayout());
        renderingPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Rendering "));
        renderingPanelBorder.add(ComponentFactory.createScrollPane((JComponent)this.rendering));
        JPanel returnPanelBorder = new JPanel(new BorderLayout());
        returnPanelBorder.setBorder(ComponentFactory.createTitledBorder((String)"Return"));
        this.allowReturnValueCheckBox = new JCheckBox("Allow Return Value");
        this.allowReturnValueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternBuilder.this.returnValuesComboBox.setEnabled(PatternBuilder.this.allowReturnValueCheckBox.isSelected());
            }
        });
        this.returnValuesComboBox.setEnabled(false);
        this.returnValuesComboBox.setRenderer(this.variableList.getVariableListCellRenderer());
        this.returnValuesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = PatternBuilder.this.returnValuesComboBox.getSelectedItem();
                if (selectedItem instanceof VariableListItem) {
                    VariableListItem item = (VariableListItem)selectedItem;
                    Variable<?> variable = item.getVariable();
                    PatternBuilder.this.patternBuilderModel.setReturnVariable(variable);
                }
            }
        });
        returnPanelBorder.add((Component)this.allowReturnValueCheckBox, "North");
        returnPanelBorder.add(this.returnValuesComboBox, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)renderingPanelBorder, "North");
        southPanel.add((Component)returnPanelBorder, "Center");
        builderPanel.add((Component)southPanel, "South");
        builderPanel.revalidate();
        this.mainPanel.add((Component)this.errorPanel, "South");
        this.mainPanel.add((Component)builderPanel, "Center");
    }

    protected void renderingUpdate() {
        this.patternBuilderModel.setRendering(this.rendering.getText());
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListener(listener, this.patternBuilderModel.check());
    }

    private void updateGUI() {
        String name = this.patternBuilderModel.getName();
        if (!name.equals(this.nameEditor.getText())) {
            this.nameEditor.setText(name);
        }
        List<Variable<?>> variables = this.patternBuilderModel.getVariables();
        this.variableList.clear();
        for (Variable<?> variable : variables) {
            PatternBuilderVariableListItem variableListItem = new PatternBuilderVariableListItem(variable, this.patternBuilderModel.getConstraintSystem(), this.owlEditorKit, true, true);
            this.variableList.placeListItem(variableListItem);
        }
        this.actionList.clear();
        List<OWLAxiomChange> actions = this.patternBuilderModel.getActions();
        for (OWLAxiomChange axiomChange : actions) {
            PatternBuilderActionListItem actionItem = new PatternBuilderActionListItem(axiomChange, true, true);
            ((ActionListModel)this.actionList.getModel()).addElement(actionItem);
        }
        Variable<?> returnVariable = this.patternBuilderModel.getReturnVariable();
        this.returnValueListModel.removeAllElements();
        HashSet returnVariables = new HashSet(variables);
        returnVariables.add(this.patternBuilderModel.getConstraintSystem().getThisClassVariable());
        for (Variable<?> variable : returnVariables) {
            PatternBuilderVariableListItem item = new PatternBuilderVariableListItem(variable, this.patternBuilderModel.getConstraintSystem(), this.owlEditorKit, false, false);
            if (this.returnValueListModel.getIndexOf(item) == -1) {
                this.returnValueListModel.addElement(item);
            }
            if (!variable.equals(returnVariable)) continue;
            this.returnValuesComboBox.setSelectedItem(item);
        }
        if (!this.rendering.getText().equals(this.patternBuilderModel.getRendering())) {
            this.rendering.setText(this.patternBuilderModel.getRendering());
        }
        this.mainPanel.revalidate();
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public PatternModel getPatternModel() {
        return this.patternModel;
    }

    public void handleChange() {
        this.patternModel = null;
        this.errorListModel.clear();
        this.actionList.setConstraintSystem((ConstraintSystem)this.patternBuilderModel.getConstraintSystem());
        boolean newState = this.patternBuilderModel.check();
        if (newState) {
            List<Variable<?>> variables = this.patternBuilderModel.getVariables();
            List<OWLAxiomChange> actions = this.patternBuilderModel.getActions();
            try {
                this.patternModel = this.factory.createPatternModel(this.nameEditor.getText(), variables, actions, null, this.rendering.getText(), (ConstraintSystem)this.patternBuilderModel.getConstraintSystem());
                if (this.allowReturnValueCheckBox.isSelected()) {
                    this.patternModel.setReturnVariable(((VariableListItem)this.returnValuesComboBox.getSelectedItem()).getVariable());
                }
            }
            catch (EmptyVariableListException e) {
                this.patternModel = null;
                this.errorListModel.addElement(new Error("No variables"));
            }
            catch (EmptyActionListException e) {
                this.patternModel = null;
                this.errorListModel.addElement(new Error("No actions"));
            }
            catch (UnsuitableOPPLScriptException e) {
                this.patternModel = null;
                this.errorListModel.addElement(new Error("Failed " + e.getMessage()));
            }
        } else {
            this.patternModel = null;
        }
        this.errorPanel.setVisible(!this.errorListModel.isEmpty());
        this.updateGUI();
        this.notifyListeners(newState);
    }

    private void notifyListeners(boolean newState) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            this.notifyListener(listener, newState);
        }
    }

    private void notifyListener(InputVerificationStatusChangedListener listener, boolean newState) {
        listener.verifiedStatusChanged(newState);
    }

    public void dispose() {
    }

    public PatternModel getEditedObject() {
        return this.patternModel;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public void setPatternModel(PatternModel patternModel) {
        if (patternModel != null) {
            this.patternBuilderModel.importPatternModel(patternModel);
        }
    }

    public boolean canEdit(Object object) {
        return true;
    }

    public boolean setEditedObject(PatternModel editedObject) {
        this.setPatternModel(editedObject);
        return true;
    }

    public String getEditorTypeName() {
        return "Build Pattern Model";
    }

    private void removeKeyListeners() {
        KeyListener[] keyListeners;
        for (KeyListener keyListener : keyListeners = this.nameEditor.getKeyListeners()) {
            this.nameEditor.removeKeyListener(keyListener);
        }
    }

    public class PatternBuilderVariableListItem
    extends VariableListItem {
        public PatternBuilderVariableListItem(Variable<?> variable, PatternConstraintSystem constraintSystem, OWLEditorKit owlEditorKit, boolean isEditable, boolean isDeleatable) {
            super(variable, (ConstraintSystem)constraintSystem, owlEditorKit, isEditable, isDeleatable);
        }

        @Override
        public String getTooltip() {
            return this.getVariable().toString();
        }

        @Override
        public void handleEdit() {
            PatternConstraintSystem cs = PatternBuilder.this.patternBuilderModel.getConstraintSystem();
            final AbstractVariableEditor variableEditor = (AbstractVariableEditor)this.getVariable().accept(new VariableVisitorEx<AbstractVariableEditor<?>>((ConstraintSystem)cs){
                final /* synthetic */ ConstraintSystem val$cs;
                {
                    this.val$cs = constraintSystem;
                }

                public <P extends OWLObject> AbstractVariableEditor<?> visit(RegexpGeneratedVariable<P> regExpGenerated) {
                    RegExpVariableEditor regExpVariableEditor = new RegExpVariableEditor(PatternBuilder.this.owlEditorKit, this.val$cs);
                    regExpVariableEditor.setVariable(regExpGenerated);
                    return regExpVariableEditor;
                }

                public <P extends OWLObject> AbstractVariableEditor<?> visit(GeneratedVariable<P> v) {
                    GeneratedVariableEditor generatedVariableEditor = new GeneratedVariableEditor(PatternBuilder.this.owlEditorKit, this.val$cs);
                    generatedVariableEditor.setVariable(v);
                    return generatedVariableEditor;
                }

                public <P extends OWLObject> AbstractVariableEditor<?> visit(InputVariable<P> v) {
                    VariableEditor ve = new VariableEditor(PatternBuilder.this.owlEditorKit, this.val$cs);
                    ve.setVariable(v);
                    return ve;
                }
            });
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(variableEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            variableEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)PatternBuilder.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle(variableEditor.getEditorName());
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternBuilder.this.owlEditorKit.getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object selectedValue;
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0) && (selectedValue = PatternBuilder.this.variableList.getSelectedValue()) instanceof VariableListItem) {
                        VariableListItem item = (VariableListItem)selectedValue;
                        Variable<?> oldVariable = item.getVariable();
                        PatternBuilder.this.patternBuilderModel.replaceVariable(oldVariable, variableEditor.getVariable());
                    }
                    variableEditor.removeStatusChangedListener(verificationListener);
                    variableEditor.dispose();
                    PatternBuilder.this.handleChange();
                }
            });
            dlg.setVisible(true);
        }
    }

    private class PatternVariableList
    extends VariableList
    implements ListDataListener {
        private static final long serialVersionUID = 20100L;

        protected void handleAdd() {
            final AbstractVariableEditor variableEditor = this.getSelectedValue() instanceof InputVariableSectionHeader ? new VariableEditor(PatternBuilder.this.owlEditorKit, (ConstraintSystem)PatternBuilder.this.patternBuilderModel.getConstraintSystem()) : new GeneratedVariableEditor(PatternBuilder.this.owlEditorKit, (ConstraintSystem)PatternBuilder.this.patternBuilderModel.getConstraintSystem());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(variableEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            variableEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)PatternBuilder.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle(variableEditor.getEditorName());
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternBuilder.this.owlEditorKit.getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        Variable<?> variable = variableEditor.getVariable();
                        PatternBuilder.this.patternBuilderModel.addVariable(variable);
                    }
                    variableEditor.removeStatusChangedListener(verificationListener);
                    variableEditor.dispose();
                }
            });
            dlg.setVisible(true);
        }

        @Override
        protected void handleDelete() {
            Object selectedValue = this.getSelectedValue();
            if (PatternBuilderVariableListItem.class.isAssignableFrom(selectedValue.getClass())) {
                PatternBuilderVariableListItem item = (PatternBuilderVariableListItem)selectedValue;
                PatternBuilder.this.patternBuilderModel.removeVariable(item.getVariable());
            }
        }

        public PatternVariableList(OWLEditorKit owlEditorKit) {
            super(owlEditorKit, (ConstraintSystem)PatternBuilder.this.patternBuilderModel.getConstraintSystem());
            this.getDefaultModel().addElement(new InputVariableSectionHeader());
            this.getDefaultModel().addElement(new GeneratedVariableSectionHeader());
            this.getModel().addListDataListener(this);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updatePatternModel();
        }

        private void updatePatternModel() {
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                Object element = this.getModel().getElementAt(i);
                if (!(element instanceof PatternBuilderVariableListItem)) continue;
                PatternBuilderVariableListItem item = (PatternBuilderVariableListItem)element;
                if (PatternBuilder.this.patternModel == null || PatternBuilder.this.patternModel.getVariables().contains(item.getVariable())) continue;
                PatternBuilder.this.patternModel.addVariable(item.getVariable());
            }
        }

        public void clear() {
            this.getDefaultModel().clear();
            this.getDefaultModel().addElement(new InputVariableSectionHeader());
            this.getDefaultModel().addElement(new GeneratedVariableSectionHeader());
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updatePatternModel();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.updatePatternModel();
        }

        protected void placeListItem(PatternBuilderVariableListItem listItem) {
            int i = -1;
            if (listItem.getVariable() instanceof GeneratedVariable) {
                i = this.getModel().getSize();
            } else {
                Enumeration<Object> elements = this.getDefaultModel().elements();
                boolean found = false;
                while (!found && elements.hasMoreElements()) {
                    ++i;
                    Object element = elements.nextElement();
                    found = element instanceof GeneratedVariableSectionHeader;
                }
                if (!found) {
                    throw new RuntimeException("Section lost");
                }
            }
            this.getDefaultModel().add(i, listItem);
        }
    }

    private class PatternBuilderActionListItem
    extends ActionListItem {
        public PatternBuilderActionListItem(OWLAxiomChange axiomChange, boolean isEditable, boolean isDeleteable) {
            super(axiomChange, isEditable, isDeleteable);
        }

        @Override
        public void handleEdit() {
            PatternConstraintSystem cs = PatternBuilder.this.patternBuilderModel.getConstraintSystem();
            OWLAxiomChangeEditor actionEditor = new OWLAxiomChangeEditor(PatternBuilder.this.owlEditorKit, (ConstraintSystem)cs);
            actionEditor.setOWLAxiomChange(this.getAxiomChange());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(actionEditor);
            InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            actionEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)PatternBuilder.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Action editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternBuilder.this.owlEditorKit.getWorkspace());
            dlg.addComponentListener(new EditActionAdapter(optionPane, actionEditor, verificationListener));
            dlg.setVisible(true);
        }

        private final class EditActionAdapter
        extends ComponentAdapter {
            private final VerifyingOptionPane optionPane;
            private final OWLAxiomChangeEditor actionEditor;
            private final InputVerificationStatusChangedListener verificationListener;

            protected EditActionAdapter(VerifyingOptionPane optionPane, OWLAxiomChangeEditor actionEditor, InputVerificationStatusChangedListener verificationListener) {
                this.optionPane = optionPane;
                this.actionEditor = actionEditor;
                this.verificationListener = verificationListener;
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Object retVal = this.optionPane.getValue();
                if (retVal != null && retVal.equals(0)) {
                    OWLAxiomChange action = this.actionEditor.getOwlAxiomChange();
                    PatternBuilderActionListItem selectedValue = (PatternBuilderActionListItem)PatternBuilder.this.actionList.getSelectedValue();
                    PatternBuilder.this.patternBuilderModel.removeAction(selectedValue.getAxiomChange());
                    PatternBuilder.this.patternBuilderModel.addAction(action);
                    PatternBuilder.this.handleChange();
                }
                this.actionEditor.removeStatusChangedListener(this.verificationListener);
                this.actionEditor.dispose();
            }
        }
    }

    private class PatternBuilderActionList
    extends ActionList {
        private static final long serialVersionUID = 20100L;

        public PatternBuilderActionList() {
            super(PatternBuilder.this.owlEditorKit, (ConstraintSystem)PatternBuilder.this.patternBuilderModel.getConstraintSystem(), true);
        }

        protected void handleAdd() {
            OWLAxiomChangeEditor actionEditor = new OWLAxiomChangeEditor(PatternBuilder.this.owlEditorKit, (ConstraintSystem)PatternBuilder.this.patternBuilderModel.getConstraintSystem());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(actionEditor);
            InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            actionEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)PatternBuilder.this.owlEditorKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Action editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)PatternBuilder.this.owlEditorKit.getWorkspace());
            dlg.addComponentListener(new AddActionAdapter(optionPane, verificationListener, actionEditor));
            dlg.setVisible(true);
        }

        @Override
        protected void handleDelete() {
            Object selectedValue = this.getSelectedValue();
            if (PatternBuilderActionListItem.class.isAssignableFrom(selectedValue.getClass())) {
                PatternBuilderActionListItem item = (PatternBuilderActionListItem)selectedValue;
                OWLAxiomChange action = item.getAxiomChange();
                PatternBuilder.this.patternBuilderModel.removeAction(action);
            }
        }

        final class AddActionAdapter
        extends ComponentAdapter {
            private final VerifyingOptionPane optionPane;
            private final InputVerificationStatusChangedListener verificationListener;
            private final OWLAxiomChangeEditor actionEditor;

            AddActionAdapter(VerifyingOptionPane optionPane, InputVerificationStatusChangedListener verificationListener, OWLAxiomChangeEditor actionEditor) {
                this.optionPane = optionPane;
                this.verificationListener = verificationListener;
                this.actionEditor = actionEditor;
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Object retVal = this.optionPane.getValue();
                if (retVal != null && retVal.equals(0)) {
                    OWLAxiomChange action = this.actionEditor.getOwlAxiomChange();
                    PatternBuilder.this.patternBuilderModel.addAction(action);
                }
                this.actionEditor.removeStatusChangedListener(this.verificationListener);
                this.actionEditor.dispose();
            }
        }
    }

    private final class PatternBuilderModel {
        private String name = "";
        private final List<Variable<?>> variables = new ArrayList();
        private final List<OWLAxiomChange> actions = new ArrayList<OWLAxiomChange>();
        private Variable<?> returnVariable = null;
        private String modelRendering = "";
        private PatternConstraintSystem constraintSystem;

        public PatternBuilderModel(AbstractPatternModelFactory factory) {
            this.constraintSystem = factory.createConstraintSystem();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            boolean changed;
            boolean bl = changed = this.name == null && name != null || !this.name.equals(name);
            if (changed) {
                this.name = name;
                this.notifyBuilder();
            }
        }

        public Variable<?> getReturnVariable() {
            return this.returnVariable;
        }

        public void setReturnVariable(Variable<?> returnVariable) {
            boolean changed;
            boolean bl = changed = this.returnVariable == null && returnVariable != null || !this.returnVariable.equals(returnVariable);
            if (changed) {
                this.returnVariable = returnVariable;
                this.notifyBuilder();
            }
        }

        public List<Variable<?>> getVariables() {
            return new ArrayList(this.variables);
        }

        public void addVariable(Variable<?> v) {
            boolean modified = this.variables.add(v);
            if (modified) {
                this.constraintSystem.importVariable(v);
                this.notifyBuilder();
            }
        }

        public void removeVariable(Variable<?> v) {
            boolean modified = this.variables.remove(v);
            if (modified) {
                this.purgeActions(v);
                this.constraintSystem.removeVariable(v);
                this.notifyBuilder();
            }
        }

        public List<OWLAxiomChange> getActions() {
            return new ArrayList<OWLAxiomChange>(this.actions);
        }

        public void addAction(OWLAxiomChange action) {
            boolean modified = this.actions.add(action);
            if (modified) {
                this.notifyBuilder();
            }
        }

        public void removeAction(OWLAxiomChange action) {
            boolean modified = this.actions.remove(action);
            if (modified) {
                this.notifyBuilder();
            }
        }

        public boolean check() {
            boolean enoughActions;
            boolean validName = this.name.matches("\\S+");
            if (!validName) {
                PatternBuilder.this.errorListModel.addElement(new Error("Invalid name"));
            }
            boolean enoughVariables = !this.variables.isEmpty();
            boolean bl = enoughActions = !this.actions.isEmpty();
            if (!enoughVariables) {
                PatternBuilder.this.errorListModel.addElement(new Error("No Variables"));
            }
            if (!enoughActions) {
                PatternBuilder.this.errorListModel.addElement(new Error("No actions"));
            }
            boolean found = false;
            if (this.modelRendering != null) {
                StringTokenizer tokenizer = new StringTokenizer(this.modelRendering);
                while (tokenizer.hasMoreTokens()) {
                    String variableName;
                    String token = tokenizer.nextToken();
                    if (!token.startsWith("?") || !(found = !this.existsVariable(variableName = token.trim()))) continue;
                    PatternBuilder.this.errorListModel.addElement(new Error("Invalid variable name " + variableName));
                }
            }
            return validName && enoughVariables && enoughActions && !found;
        }

        private boolean existsVariable(String variableName) {
            boolean found = false;
            Iterator<Variable<?>> it = this.variables.iterator();
            while (!found && it.hasNext()) {
                found = it.next().getName().equals(variableName);
            }
            return found;
        }

        public String getRendering() {
            return this.modelRendering;
        }

        public void setRendering(String rendering) {
            boolean changed;
            boolean bl = changed = this.modelRendering == null && rendering != null || !this.modelRendering.equals(rendering);
            if (changed) {
                this.modelRendering = rendering;
                this.notifyBuilder();
            }
        }

        public void notifyBuilder() {
            PatternBuilder.this.handleChange();
        }

        public void importPatternModel(PatternModel pattern) {
            if (pattern != null) {
                this.constraintSystem = pattern.getConstraintSystem();
                this.name = pattern.getName();
                this.variables.clear();
                this.variables.addAll(pattern.getVariables());
                this.actions.clear();
                this.actions.addAll(pattern.getActions());
                this.modelRendering = pattern.getRendering();
                this.returnVariable = pattern.getReturnVariable();
                this.notifyBuilder();
            } else {
                this.reset();
            }
        }

        public void reset() {
            this.name = "";
            this.variables.clear();
            this.actions.clear();
            this.returnVariable = null;
            this.modelRendering = "";
            this.notifyBuilder();
        }

        public PatternConstraintSystem getConstraintSystem() {
            return this.constraintSystem;
        }

        private void purgeActions(Variable<?> v) {
            HashSet<OWLAxiomChange> toRemove = new HashSet<OWLAxiomChange>();
            for (OWLAxiomChange action : this.actions) {
                OWLAxiom axiom = action.getAxiom();
                Set axiomVariables = PatternBuilder.this.patternBuilderModel.getConstraintSystem().getAxiomVariables(axiom);
                if (!axiomVariables.contains(v)) continue;
                toRemove.add(action);
            }
            this.actions.removeAll(toRemove);
        }

        public void replaceVariable(Variable<?> oldVariable, Variable<?> newVariable) {
            boolean modified = this.variables.remove(oldVariable);
            if (modified) {
                if (oldVariable.getType() != newVariable.getType()) {
                    this.purgeActions(oldVariable);
                }
                this.variables.add(newVariable);
                this.constraintSystem.removeVariable(oldVariable);
                this.constraintSystem.importVariable(newVariable);
                this.notifyBuilder();
            }
        }
    }
}

