/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.coode.patterns.PatternModel;

public class PatternBorder
implements Border {
    private final PatternModel patternModel;

    public PatternBorder(PatternModel patternModel) {
        this.patternModel = patternModel;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, c.getFontMetrics((Font)c.getFont()).getStringBounds((String)this.patternModel.getName(), (Graphics)c.getGraphics()).getBounds().width + 8, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(Color.BLUE);
        g.drawString(this.patternModel.getName(), x + 4, y + 2 + g.getFontMetrics().getAscent() + g.getFontMetrics().getLeading());
        g.setColor(oldColor);
    }
}

