/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.table.TableModel;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.patterns.locality.LocalityChecker;
import org.coode.patterns.protege.ui.LocalityCheckResultTableModel;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLEntity;

public class LocalityCheckerActionListener
extends LocalityChecker
implements ActionListener {
    private static final String SAFETY_ANALYSIS_BREAKDOWN = "Safety analysis breakdown";
    protected static final int DIMENSION = 18;
    private final JButton resultButton;

    public LocalityCheckerActionListener(OWLEditorKit kit, Set<OWLEntity> signature, JButton resultButton, RuntimeExceptionHandler handler) {
        super(kit.getOWLModelManager().getOWLOntologyManager(), kit.getOWLModelManager().getReasoner(), signature, handler);
        this.resultButton = resultButton;
        this.resultButton.setIcon(this.generateIcon(Color.gray));
        this.resultButton.setToolTipText("Check not executed yet");
        this.resultButton.setEnabled(false);
    }

    public Icon generateIcon(final Color color) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color oldColor = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(color);
                g2.fillOval(x + 2, y + 2, 14, 14);
                g2.setColor(Color.LIGHT_GRAY);
                g2.drawOval(x + 2, y + 2, 14, 14);
                g2.setColor(oldColor);
            }

            @Override
            public int getIconWidth() {
                return 18;
            }

            @Override
            public int getIconHeight() {
                return 18;
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resultButton.setEnabled(true);
        this.resultButton.setToolTipText(SAFETY_ANALYSIS_BREAKDOWN);
        if (this.getInstantiatedPatternModel() != null) {
            if (!this.isLocal()) {
                this.resultButton.setIcon(this.generateIcon(Color.red));
            } else {
                this.resultButton.setIcon(this.generateIcon(Color.green));
            }
        }
    }

    public TableModel print() {
        return new LocalityCheckResultTableModel(this);
    }
}

