/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.patterns.locality.LocalityChecker;

public class LocalityCheckResultTableModel
implements TableModel {
    private final String[][] dataArray;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public String[][] getDataArray() {
        return this.dataArray;
    }

    public LocalityCheckResultTableModel(LocalityChecker checker) {
        ArrayList toAssign = new ArrayList(checker.getInstantiatedPatternModel().getInputVariables());
        List bindingsLocality = checker.getExploredNodesLocality();
        List bindings = checker.getExploredNodes();
        this.dataArray = new String[bindings.size() + 1][toAssign.size() + 1];
        this.dataArray[0][0] = "Safe";
        for (int i = 0; i < toAssign.size(); ++i) {
            this.dataArray[0][i + 1] = ((InputVariable)toAssign.get(i)).getName();
        }
        Set sigmaMinus = checker.getEntities();
        sigmaMinus.addAll(checker.getSigmaPlus());
        if (bindings.size() == bindingsLocality.size()) {
            for (int i = 0; i < bindings.size(); ++i) {
                this.setValueAt(bindingsLocality.get(i), i, 0);
                BindingNode node = (BindingNode)bindings.get(i);
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters((ConstraintSystem)checker.getInstantiatedPatternModel().getConstraintSystem(), node, checker.getHandler());
                for (int j = 0; j < toAssign.size(); ++j) {
                    Variable v = (Variable)toAssign.get(j);
                    if (sigmaMinus.contains(node.getAssignmentValue(v, (ValueComputationParameters)parameters))) {
                        this.setValueAt(values.PRESENT.value(), i, j + 1);
                        continue;
                    }
                    this.setValueAt(values.ABSENT.value(), i, j + 1);
                }
            }
            this.sort();
        }
    }

    private void sort() {
        String s;
        int i;
        ArrayList<String> trues = new ArrayList<String>();
        ArrayList<String> falses = new ArrayList<String>();
        for (i = 1; i < this.dataArray.length; ++i) {
            StringBuilder b = new StringBuilder();
            for (int j = 1; j < this.dataArray[i].length; ++j) {
                b.append(this.dataArray[i][j]);
            }
            String record = b.toString();
            if (Boolean.parseBoolean(this.dataArray[i][0])) {
                trues.add(record);
                continue;
            }
            falses.add(record);
        }
        Collections.sort(trues);
        Collections.sort(falses);
        for (i = 0; i < trues.size(); ++i) {
            s = (String)trues.get(i);
            this.dataArray[i + 1][0] = Boolean.TRUE.toString();
            for (int j = 1; j < this.dataArray[i + 1].length; ++j) {
                this.dataArray[i + 1][j] = values.getValue(s.charAt(j - 1));
            }
        }
        for (i = 0; i < falses.size(); ++i) {
            s = (String)falses.get(i);
            this.dataArray[i + 1 + trues.size()][0] = Boolean.FALSE.toString();
            for (int j = 1; j < this.dataArray[i + 1 + trues.size()].length; ++j) {
                this.dataArray[i + 1 + trues.size()][j] = values.getValue(s.charAt(j - 1));
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.dataArray[rowIndex + 1][columnIndex] = aValue.toString();
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataArray[rowIndex + 1][columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.dataArray.length - 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataArray[0][columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.dataArray[0].length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    private static enum values {
        PRESENT("X", 'X'),
        ABSENT(" ", ' ');

        private char v;
        private String val;

        private values(String val, char v) {
            this.val = val;
            this.v = v;
        }

        public String value() {
            return this.val;
        }

        public static String getValue(char v) {
            if (v == values.PRESENT.v) {
                return values.PRESENT.val;
            }
            if (v == values.ABSENT.v) {
                return values.ABSENT.val;
            }
            throw new RuntimeException("Unknown value: " + v);
        }
    }
}

