/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege;

import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternModel;
import org.coode.patterns.protege.ProtegePatternModel;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLObject;

public class ProtegeInstantiatedPatternModel
extends InstantiatedPatternModel {
    private final OWLModelManager modelManager;

    public ProtegeInstantiatedPatternModel(ProtegePatternModel patternModel, RuntimeExceptionHandler handler) {
        super((PatternModel)patternModel, handler);
        this.modelManager = patternModel.getModelManager();
    }

    protected String render(OWLObject owlObject) {
        return this.modelManager.getRendering(owlObject);
    }

    public String render() {
        StringBuilder toReturn = new StringBuilder("$" + this.getInstantiatedPatternLocalName() + "(");
        boolean first = true;
        for (Variable variable : this.getInputVariables()) {
            if (!first) {
                toReturn.append(", ");
            } else {
                first = false;
            }
            Set instantiationsValues = this.getInstantiations(variable);
            if (instantiationsValues != null && !instantiationsValues.isEmpty()) {
                if (instantiationsValues.size() == 1) {
                    OWLObject instantiation = (OWLObject)instantiationsValues.iterator().next();
                    toReturn.append(this.modelManager.getRendering(instantiation));
                    continue;
                }
                boolean firstInstantiation = true;
                toReturn.append("{");
                for (OWLObject instantiation : instantiationsValues) {
                    String instantiationRendering = this.modelManager.getRendering(instantiation);
                    toReturn.append(firstInstantiation ? instantiationRendering : ", " + instantiationRendering);
                    firstInstantiation = firstInstantiation ? false : firstInstantiation;
                }
                toReturn.append("}");
                continue;
            }
            toReturn.append(variable.getName());
        }
        toReturn.append(")");
        return toReturn.toString();
    }
}

