/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.protege;

import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.utils.ArgCheck;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternManager;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternOPPLScript;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.AnnotationContainer;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;

public class PatternAnnotationContainer
implements AnnotationContainer {
    private final OWLEditorKit owlEditorKit;
    private final PatternExtractor patternExtractor;

    public PatternAnnotationContainer(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.patternExtractor = new PatternExtractor(this.getOntology(), this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager(), PatternManager.getDefaultErrorListener());
    }

    public Set<OWLAnnotation> getAnnotations() {
        OWLOntology activeOntology = this.getOWLEditorKit().getOWLModelManager().getActiveOntology();
        Set toReturn = activeOntology.getAnnotations();
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            OWLAnnotation annotation = (OWLAnnotation)iterator.next();
            PatternModel extracted = this.getPatternModel(annotation);
            if (extracted != null) continue;
            iterator.remove();
        }
        return toReturn;
    }

    public PatternModel getPatternModel(OWLAnnotation annotation) {
        PatternOPPLScript extracted = (PatternOPPLScript)annotation.accept((OWLObjectVisitorEx)this.patternExtractor);
        return (PatternModel)extracted;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLOntology getOntology() {
        return this.getOWLEditorKit().getOWLModelManager().getActiveOntology();
    }
}

