/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.ui.ReportTreeCellRenderer;
import org.coode.parsers.oppl.testcase.ui.report.AssertionFailedExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.ConfigurationFailedExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.Report;
import org.coode.parsers.oppl.testcase.ui.report.ReportVisitorEx;
import org.coode.parsers.oppl.testcase.ui.report.RuntimeErrorEncounteredExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.SuccessfulExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.UnexecutedTestReport;

public class SummaryPanel
extends JPanel {
    private static final long serialVersionUID = 20100L;
    private final JLabel runTestSummary = new JLabel();
    private final JLabel okTestSummary = new JLabel();
    private final JLabel errorTestSummary = new JLabel();
    private final Map<OPPLTestCase, List<Report>> reports = new HashMap<OPPLTestCase, List<Report>>();

    public SummaryPanel() {
        this.initGUI();
        this.refresh();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.runTestSummary, "West");
        JPanel resultBreakDown = new JPanel();
        resultBreakDown.add(this.okTestSummary);
        resultBreakDown.add(this.errorTestSummary);
        this.okTestSummary.setIcon(ReportTreeCellRenderer.getSuccessIcon(16, 16));
        this.errorTestSummary.setIcon(ReportTreeCellRenderer.getErrorIcon(16, 16));
        this.add((Component)resultBreakDown, "East");
    }

    public void addReports(Map<OPPLTestCase, List<Report>> reportList) {
        this.reports.putAll(reportList);
        this.refresh();
    }

    private void refresh() {
        int count = 0;
        int okCount = 0;
        int errorCount = 0;
        for (OPPLTestCase testCase : this.reports.keySet()) {
            List<Report> testCaseReports = this.reports.get(testCase);
            if (testCaseReports == null) continue;
            ++count;
            for (Report report : testCaseReports) {
                boolean isSuccesful = report.accept(new ReportVisitorEx<Boolean>(){

                    @Override
                    public Boolean visitSuccessfulExecutionReport(SuccessfulExecutionReport successfulExecutionReport) {
                        return true;
                    }

                    @Override
                    public Boolean visitAssertionFailedExecutionReport(AssertionFailedExecutionReport assertionFailedExecutionReport) {
                        return false;
                    }

                    @Override
                    public Boolean visitConfigurationFailedExecutionReport(ConfigurationFailedExecutionReport configurationFailedExecutionReport) {
                        return false;
                    }

                    @Override
                    public Boolean visitRuntimeErrorEncounteredExecutionReport(RuntimeErrorEncounteredExecutionReport runtimeErrorEncounteredExecutionReport) {
                        return false;
                    }

                    @Override
                    public Boolean visitUnexecutedTestReport(UnexecutedTestReport unexecutedTestReport) {
                        return false;
                    }
                });
                if (isSuccesful) {
                    ++okCount;
                    continue;
                }
                ++errorCount;
            }
        }
        this.runTestSummary.setText(String.format("Run %d of %d", count, this.reports.keySet().size()));
        this.okTestSummary.setText(String.format("Succesful %d", okCount));
        this.errorTestSummary.setText(String.format("Failures %d", errorCount));
    }

    public void clear() {
        this.reports.clear();
        this.refresh();
    }
}

