/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.OPPLTest;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.TestCaseRunner;
import org.coode.parsers.oppl.testcase.ui.report.AssertionFailedExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.ConfigurationFailedExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.Report;
import org.coode.parsers.oppl.testcase.ui.report.RuntimeErrorEncounteredExecutionReport;
import org.coode.parsers.oppl.testcase.ui.report.SuccessfulExecutionReport;

public class ReportingTestRunner {
    protected final OPPLTestCase opplTestCase;

    public ReportingTestRunner(OPPLTestCase opplTestCase) {
        this.opplTestCase = (OPPLTestCase)ArgCheck.checkNotNull((Object)opplTestCase, (String)"opplTestCase");
    }

    public OPPLTestCase getOPPLTestCase() {
        return this.opplTestCase;
    }

    public Map<OPPLTestCase, List<Report>> run() {
        HashMap<OPPLTestCase, List<Report>> toReturn = new HashMap<OPPLTestCase, List<Report>>();
        OPPLTestCaseRunner testCaseRunner = new OPPLTestCaseRunner(this.opplTestCase, toReturn);
        testCaseRunner.run();
        return toReturn;
    }

    private final class OPPLTestCaseRunner
    extends TestCaseRunner {
        private final Map<OPPLTestCase, List<Report>> reports;

        public OPPLTestCaseRunner(OPPLTestCase opplTestCase, Map<OPPLTestCase, List<Report>> reports) {
            super(opplTestCase);
            assert (reports != null);
            this.reports = reports;
        }

        protected void configurationFailed(String message) {
            List tests = ReportingTestRunner.this.opplTestCase.getTests();
            ConfigurationFailedExecutionReport configurationFailedExecutionReport = new ConfigurationFailedExecutionReport(ReportingTestRunner.this.opplTestCase, message);
            ArrayList<ConfigurationFailedExecutionReport> reportList = new ArrayList<ConfigurationFailedExecutionReport>(tests.size() + 1);
            reportList.add(configurationFailedExecutionReport);
            this.reports.put(ReportingTestRunner.this.opplTestCase, reportList);
        }

        protected void success(OPPLTest test) {
            List<Report> previousReports = this.reports.get(ReportingTestRunner.this.opplTestCase);
            if (previousReports == null) {
                previousReports = new ArrayList<Report>();
                this.reports.put(ReportingTestRunner.this.opplTestCase, previousReports);
            }
            previousReports.add(new SuccessfulExecutionReport(ReportingTestRunner.this.opplTestCase, test));
        }

        protected void fail(OPPLTest test) {
            List<Report> previousReports = this.reports.get(ReportingTestRunner.this.opplTestCase);
            if (previousReports == null) {
                previousReports = new ArrayList<Report>();
                this.reports.put(ReportingTestRunner.this.opplTestCase, previousReports);
            }
            previousReports.add(new AssertionFailedExecutionReport(ReportingTestRunner.this.opplTestCase, test));
        }

        protected void fail(Throwable e) {
            List<Report> previousReports = this.reports.get(ReportingTestRunner.this.opplTestCase);
            if (previousReports == null) {
                previousReports = new ArrayList<Report>();
                this.reports.put(ReportingTestRunner.this.opplTestCase, previousReports);
            }
            previousReports.add(new RuntimeErrorEncounteredExecutionReport(ReportingTestRunner.this.opplTestCase, e));
        }
    }
}

