/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.ui.report.DefaultReportVisitorExAdapter;
import org.coode.parsers.oppl.testcase.ui.report.Report;
import org.coode.parsers.oppl.testcase.ui.report.SuccessfulExecutionReport;

public final class ReportTreeModel
implements TreeModel {
    private static final String TEST_CASES_EXECUTED = "Test Cases executed";
    private static final String DEFAULT_ROOT = "No Test Case";
    private final Map<OPPLTestCase, List<Report>> reportMap = new HashMap<OPPLTestCase, List<Report>>();
    private String root = "No Test Case";
    private final Set<TreeModelListener> listeners = new HashSet<TreeModelListener>();
    private static final Comparator<OPPLTestCase> LEXICOGRAPHIC_COMPARATOR = new Comparator<OPPLTestCase>(){

        @Override
        public int compare(OPPLTestCase o1, OPPLTestCase o2) {
            int toReturn = 0;
            toReturn = o1 == null ? -1 : (o2 == null ? 1 : o1.getName().compareTo(o2.getName()));
            return toReturn;
        }
    };

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Report toReturn = null;
        if (parent == this.getRoot()) {
            ArrayList<OPPLTestCase> list = new ArrayList<OPPLTestCase>(this.reportMap.keySet());
            Collections.sort(list, LEXICOGRAPHIC_COMPARATOR);
            if (index >= 0 && index < list.size()) {
                toReturn = list.get(index);
            }
        } else {
            List<Report> list = this.reportMap.get(parent);
            if (list != null && index >= 0 && index < list.size()) {
                toReturn = list.get(index);
            }
        }
        return toReturn;
    }

    @Override
    public int getChildCount(Object parent) {
        int toReturn = 0;
        if (parent == this.getRoot()) {
            toReturn = this.reportMap.keySet().size();
        } else {
            List<Report> list = this.reportMap.get(parent);
            toReturn = list.size();
        }
        return toReturn;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node == this.getRoot() && this.reportMap.isEmpty() || Report.class.isAssignableFrom(node.getClass());
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int toReturn = -1;
        if (parent == this.getRoot()) {
            ArrayList<OPPLTestCase> list = new ArrayList<OPPLTestCase>(this.reportMap.keySet());
            Collections.sort(list, LEXICOGRAPHIC_COMPARATOR);
            toReturn = list.indexOf(child);
        } else {
            List<Report> list = this.reportMap.get(parent);
            toReturn = list.indexOf(child);
        }
        return toReturn;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private void notifyListeners() {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }

    public void clear() {
        this.root = DEFAULT_ROOT;
        this.reportMap.clear();
        this.notifyListeners();
    }

    public void addReports(Map<OPPLTestCase, List<Report>> reports) {
        if (this.reportMap.isEmpty()) {
            this.root = TEST_CASES_EXECUTED;
        }
        this.reportMap.putAll(reports);
        this.notifyListeners();
    }

    public boolean isSuccessful() {
        boolean toReturn = this.reportMap.isEmpty();
        if (!toReturn) {
            Iterator<List<Report>> iterator = this.reportMap.values().iterator();
            boolean found = false;
            while (!found && iterator.hasNext()) {
                List<Report> list = iterator.next();
                Iterator<Report> listIterator = list.iterator();
                while (!found && listIterator.hasNext()) {
                    Report report = listIterator.next();
                    found = this.isUnsuccessful(report);
                }
            }
            toReturn = !found;
        }
        return toReturn;
    }

    public boolean isSuccessful(OPPLTestCase opplTestCase) {
        if (!this.reportMap.keySet().contains(opplTestCase)) {
            throw new IllegalArgumentException("The OPPL Test case is not contained into the reports in this model");
        }
        List<Report> reports = this.reportMap.get(ArgCheck.checkNotNull((Object)opplTestCase, (String)"opplTestCase"));
        Iterator<Report> iterator = reports.iterator();
        boolean found = false;
        while (!found && iterator.hasNext()) {
            Report report = iterator.next();
            found = this.isUnsuccessful(report);
        }
        return !found;
    }

    public boolean isUnsuccessful(Report report) {
        boolean found = report.accept(new DefaultReportVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

            @Override
            public Boolean visitSuccessfulExecutionReport(SuccessfulExecutionReport successfulExecutionReport) {
                return false;
            }
        });
        return found;
    }

    public TreePath[] getUnsuccessfulTreePaths() {
        HashSet<TreePath> toReturn = new HashSet<TreePath>();
        for (List<Report> reportList : this.reportMap.values()) {
            for (Report report : reportList) {
                if (!this.isUnsuccessful(report)) continue;
                toReturn.add(new TreePath(new Object[]{this.getRoot(), report.getOPPLTestCase()}));
            }
        }
        return toReturn.toArray(new TreePath[toReturn.size()]);
    }
}

